/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CatalogTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.CatalogTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonSerializer;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CatalogTableSpecBase {
    public static final String FIELD_NAME_IDENTIFIER = "identifier";
    public static final String FIELD_NAME_CATALOG_TABLE = "catalogTable";
    @JsonProperty(value="identifier", required=true)
    @JsonSerialize(using=ObjectIdentifierJsonSerializer.class)
    @JsonDeserialize(using=ObjectIdentifierJsonDeserializer.class)
    protected final ObjectIdentifier objectIdentifier;
    @JsonProperty(value="catalogTable", required=true)
    @JsonSerialize(using=CatalogTableJsonSerializer.class)
    @JsonDeserialize(using=CatalogTableJsonDeserializer.class)
    protected final ResolvedCatalogTable catalogTable;
    @JsonIgnore
    protected ClassLoader classLoader;
    @JsonIgnore
    protected ReadableConfig configuration;

    protected CatalogTableSpecBase(ObjectIdentifier objectIdentifier, ResolvedCatalogTable catalogTable) {
        this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier);
        this.catalogTable = (ResolvedCatalogTable)Preconditions.checkNotNull((Object)catalogTable);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setReadableConfig(ReadableConfig config) {
        this.configuration = config;
    }

    @JsonIgnore
    public ObjectIdentifier getObjectIdentifier() {
        return this.objectIdentifier;
    }

    @JsonIgnore
    public ResolvedCatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    @JsonIgnore
    @VisibleForTesting
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @JsonIgnore
    @VisibleForTesting
    public ReadableConfig getReadableConfig() {
        return this.configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogTableSpecBase that = (CatalogTableSpecBase)o;
        return this.objectIdentifier.equals(that.objectIdentifier) && this.catalogTable.toProperties().equals(that.catalogTable.toProperties());
    }

    public int hashCode() {
        return Objects.hash(this.objectIdentifier, this.catalogTable.toProperties());
    }
}

