/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.CatalogTableSpecBase;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DynamicTableSourceSpec
extends CatalogTableSpecBase {
    public static final String FIELD_NAME_SOURCE_ABILITY_SPECS = "sourceAbilitySpecs";
    @JsonIgnore
    private DynamicTableSource tableSource;
    @JsonProperty(value="sourceAbilitySpecs")
    @Nullable
    private final List<SourceAbilitySpec> sourceAbilitySpecs;

    @JsonCreator
    public DynamicTableSourceSpec(@JsonProperty(value="identifier") ObjectIdentifier objectIdentifier, @JsonProperty(value="catalogTable") ResolvedCatalogTable catalogTable, @Nullable @JsonProperty(value="sourceAbilitySpecs") List<SourceAbilitySpec> sourceAbilitySpecs) {
        super(objectIdentifier, catalogTable);
        this.sourceAbilitySpecs = sourceAbilitySpecs;
    }

    @JsonIgnore
    private DynamicTableSource getTableSource(PlannerBase planner) {
        Preconditions.checkNotNull((Object)this.configuration);
        if (this.tableSource == null) {
            this.tableSource = FactoryUtil.createTableSource(null, this.objectIdentifier, this.catalogTable, this.configuration, this.classLoader, true);
            if (this.sourceAbilitySpecs != null) {
                RowType newProducedType = (RowType)this.catalogTable.getResolvedSchema().toSourceRowDataType().getLogicalType();
                for (SourceAbilitySpec spec : this.sourceAbilitySpecs) {
                    SourceAbilityContext context = new SourceAbilityContext(planner.getFlinkContext(), newProducedType);
                    spec.apply(this.tableSource, context);
                    if (!spec.getProducedType().isPresent()) continue;
                    newProducedType = spec.getProducedType().get();
                }
            }
        }
        return this.tableSource;
    }

    @JsonIgnore
    public ScanTableSource getScanTableSource(PlannerBase planner) {
        DynamicTableSource tableSource = this.getTableSource(planner);
        if (tableSource instanceof ScanTableSource) {
            return (ScanTableSource)tableSource;
        }
        throw new TableException(String.format("%s is not a ScanTableSource.\nplease check it.", tableSource.getClass().getName()));
    }

    @JsonIgnore
    public LookupTableSource getLookupTableSource(PlannerBase planner) {
        DynamicTableSource tableSource = this.getTableSource(planner);
        if (tableSource instanceof LookupTableSource) {
            return (LookupTableSource)tableSource;
        }
        throw new TableException(String.format("%s is not a LookupTableSource.\nplease check it.", tableSource.getClass().getName()));
    }

    public void setTableSource(DynamicTableSource tableSource) {
        this.tableSource = tableSource;
    }

    @JsonIgnore
    @Nullable
    public List<SourceAbilitySpec> getSourceAbilitySpecs() {
        return this.sourceAbilitySpecs;
    }
}

