/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerWindowProperty;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.window.SlicingWindowAggOperatorBuilder;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SlicingWindowOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class StreamExecGlobalWindowAggregate
extends StreamExecWindowAggregateBase {
    public static final String FIELD_NAME_LOCAL_AGG_INPUT_ROW_TYPE = "localAggInputRowType";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="windowing")
    private final WindowingStrategy windowing;
    @JsonProperty(value="namedWindowProperties")
    private final PlannerNamedWindowProperty[] namedWindowProperties;
    @JsonProperty(value="localAggInputRowType")
    @JsonSerialize(using=LogicalTypeJsonSerializer.class)
    @JsonDeserialize(using=LogicalTypeJsonDeserializer.class)
    private final RowType localAggInputRowType;

    public StreamExecGlobalWindowAggregate(int[] grouping, AggregateCall[] aggCalls, WindowingStrategy windowing, PlannerNamedWindowProperty[] namedWindowProperties, InputProperty inputProperty, RowType localAggInputRowType, RowType outputType, String description) {
        this(grouping, aggCalls, windowing, namedWindowProperties, StreamExecGlobalWindowAggregate.getNewNodeId(), Collections.singletonList(inputProperty), localAggInputRowType, outputType, description);
    }

    @JsonCreator
    public StreamExecGlobalWindowAggregate(@JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="windowing") WindowingStrategy windowing, @JsonProperty(value="namedWindowProperties") PlannerNamedWindowProperty[] namedWindowProperties, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="localAggInputRowType") RowType localAggInputRowType, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.windowing = (WindowingStrategy)Preconditions.checkNotNull((Object)windowing);
        this.namedWindowProperties = (PlannerNamedWindowProperty[])Preconditions.checkNotNull((Object)namedWindowProperties);
        this.localAggInputRowType = localAggInputRowType;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        TableConfig config = planner.getTableConfig();
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone(this.windowing.getTimeAttributeType(), config);
        SliceAssigner sliceAssigner = this.createSliceAssigner(this.windowing, shiftTimeZone);
        AggregateInfoList localAggInfoList = AggregateUtil.deriveStreamWindowAggregateInfoList(this.localAggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.windowing.getWindow(), false);
        AggregateInfoList globalAggInfoList = AggregateUtil.deriveStreamWindowAggregateInfoList(this.localAggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.windowing.getWindow(), true);
        GeneratedNamespaceAggsHandleFunction<Long> localAggsHandler = this.createAggsHandler("LocalWindowAggsHandler", sliceAssigner, localAggInfoList, this.grouping.length, true, localAggInfoList.getAccTypes(), config, planner.getRelBuilder(), shiftTimeZone);
        GeneratedNamespaceAggsHandleFunction<Long> globalAggsHandler = this.createAggsHandler("GlobalWindowAggsHandler", sliceAssigner, globalAggInfoList, 0, true, localAggInfoList.getAccTypes(), config, planner.getRelBuilder(), shiftTimeZone);
        GeneratedNamespaceAggsHandleFunction<Long> stateAggsHandler = this.createAggsHandler("StateWindowAggsHandler", sliceAssigner, globalAggInfoList, 0, false, globalAggInfoList.getAccTypes(), config, planner.getRelBuilder(), shiftTimeZone);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.grouping, InternalTypeInfo.of(inputRowType));
        LogicalType[] accTypes = this.convertToLogicalTypes(globalAggInfoList.getAccTypes());
        SlicingWindowOperator<RowData, ?> windowOperator = SlicingWindowAggOperatorBuilder.builder().inputSerializer(new RowDataSerializer(inputRowType)).shiftTimeZone(shiftTimeZone).keySerializer((PagedTypeSerializer)selector.getProducedType().toSerializer()).assigner(sliceAssigner).countStarIndex(globalAggInfoList.getIndexOfCountStar()).globalAggregate(localAggsHandler, globalAggsHandler, stateAggsHandler, new RowDataSerializer(accTypes)).build();
        OneInputTransformation<?, ?> transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.getDescription(), SimpleOperatorFactory.of(windowOperator), InternalTypeInfo.of(this.getOutputType()), inputTransform.getParallelism(), 100L);
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType(selector.getProducedType());
        return transform;
    }

    private GeneratedNamespaceAggsHandleFunction<Long> createAggsHandler(String name, SliceAssigner sliceAssigner, AggregateInfoList aggInfoList, int mergedAccOffset, boolean mergedAccIsOnHeap, DataType[] mergedAccExternalTypes, TableConfig config, RelBuilder relBuilder, ZoneId shifTimeZone) {
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config), relBuilder, JavaScalaConversionUtil.toScala(this.localAggInputRowType.getChildren()), true).needAccumulate().needMerge(mergedAccOffset, mergedAccIsOnHeap, mergedAccExternalTypes);
        List windowProperties = Arrays.asList(Arrays.stream(this.namedWindowProperties).map(PlannerNamedWindowProperty::getProperty).toArray(PlannerWindowProperty[]::new));
        return generator.generateNamespaceAggsHandler(name, aggInfoList, JavaScalaConversionUtil.toScala(windowProperties), sliceAssigner, shifTimeZone);
    }
}

