/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Litmus;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowJoin;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.utils.PythonUtil$;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.types.logical.LogicalType;
import scala.None$;
import scala.Option;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001U\u0011\u0001d\u0015;sK\u0006l\u0007\u000b[=tS\u000e\fGnV5oI><(j\\5o\u0015\t\u0019A!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000b\u0019\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003\u000f!\tQA\\8eKNT!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u000511m\\7n_:L!a\u0007\r\u0003%\r{W.\\8o!\"L8/[2bY*{\u0017N\u001c\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011\u0011c\u0015;sK\u0006l\u0007\u000b[=tS\u000e\fGNU3m\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013aB2mkN$XM\u001d\t\u0003G\u001dj\u0011\u0001\n\u0006\u0003\u0013\u0015R!A\n\t\u0002\u000f\r\fGnY5uK&\u0011\u0001\u0006\n\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011)\u0002!\u0011!Q\u0001\n-\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003G1J!!\f\u0013\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00059A.\u001a4u%\u0016d\u0007CA\u00195\u001b\u0005\u0011$BA\u001a&\u0003\r\u0011X\r\\\u0005\u0003kI\u0012qAU3m\u001d>$W\r\u0003\u00058\u0001\t\u0005\t\u0015!\u00031\u0003!\u0011\u0018n\u001a5u%\u0016d\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u0011)|\u0017N\u001c+za\u0016\u0004\"a\u000f \u000e\u0003qR!!\u0010\u001a\u0002\t\r|'/Z\u0005\u0003\u007fq\u00121BS8j]J+G\u000eV=qK\"A\u0011\t\u0001B\u0001B\u0003%!)\u0001\nsK6\f\u0017N\\5oO\u000e{g\u000eZ5uS>t\u0007CA\"G\u001b\u0005!%BA#&\u0003\r\u0011X\r_\u0005\u0003\u000f\u0012\u0013qAU3y\u001d>$W\r\u0003\u0005J\u0001\t\u0015\r\u0011\"\u0001K\u00035aWM\u001a;XS:$wn^5oOV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u0011\u00059An\\4jG\u0006d\u0017B\u0001)N\u0005E9\u0016N\u001c3po&twm\u0015;sCR,w-\u001f\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0017\u0006qA.\u001a4u/&tGm\\<j]\u001e\u0004\u0003\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011\u0001&\u0002\u001dILw\r\u001b;XS:$wn^5oO\"Aa\u000b\u0001B\u0001B\u0003%1*A\bsS\u001eDGoV5oI><\u0018N\\4!\u0011\u0015A\u0006\u0001\"\u0001Z\u0003\u0019a\u0014N\\5u}QI!l\u0017/^=~\u0003\u0017M\u0019\t\u0003;\u0001AQ!I,A\u0002\tBQAK,A\u0002-BQaL,A\u0002ABQaN,A\u0002ABQ!O,A\u0002iBQ!Q,A\u0002\tCQ!S,A\u0002-CQ\u0001V,A\u0002-CQ\u0001\u001a\u0001\u0005B\u0015\fq![:WC2LG\rF\u0002gYR\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014qAQ8pY\u0016\fg\u000eC\u0003nG\u0002\u0007a.\u0001\u0004mSRlWo\u001d\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0016\nA!\u001e;jY&\u00111\u000f\u001d\u0002\u0007\u0019&$X.^:\t\u000bU\u001c\u0007\u0019\u0001<\u0002\u000f\r|g\u000e^3yiB\u0011qO\u001f\b\u0003caL!!\u001f\u001a\u0002\u000fI+GNT8eK&\u00111\u0010 \u0002\b\u0007>tG/\u001a=u\u0015\tI(\u0007C\u0003\u007f\u0001\u0011\u0005s0\u0001\tsKF,\u0018N]3XCR,'/\\1sWV\ta\rC\u0004\u0002\u0004\u0001!\t%!\u0002\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003\u000f\ti!a\u0004\u0002\u0014\u0005]\u00111DA\u000f!\rY\u0014\u0011B\u0005\u0004\u0003\u0017a$\u0001\u0002&pS:DaAKA\u0001\u0001\u0004Y\u0003bBA\t\u0003\u0003\u0001\rAQ\u0001\u000eG>tG-\u001b;j_:,\u0005\u0010\u001d:\t\u000f\u0005U\u0011\u0011\u0001a\u0001a\u0005!A.\u001a4u\u0011\u001d\tI\"!\u0001A\u0002A\nQA]5hQRDa!OA\u0001\u0001\u0004Q\u0004bBA\u0010\u0003\u0003\u0001\rAZ\u0001\rg\u0016l\u0017NS8j]\u0012{g.\u001a\u0005\b\u0003G\u0001A\u0011IA\u0013\u00031)\u0007\u0010\u001d7bS:$VM]7t)\u0011\t9#!\f\u0011\u0007E\nI#C\u0002\u0002,I\u0012\u0011BU3m/JLG/\u001a:\t\u0011\u0005=\u0012\u0011\u0005a\u0001\u0003O\t!\u0001]<\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005\u0019BO]1og2\fG/\u001a+p\u000bb,7MT8eKR\u0011\u0011q\u0007\u0019\u0005\u0003s\tI\u0005\u0005\u0004\u0002<\u0005\u0005\u0013QI\u0007\u0003\u0003{Q1!a\u0010\u0007\u0003\u0011)\u00070Z2\n\t\u0005\r\u0013Q\b\u0002\t\u000bb,7MT8eKB!\u0011qIA%\u0019\u0001!A\"a\u0013\u00022\u0005\u0005\t\u0011!B\u0001\u0003\u001b\u00121a\u0018\u00132#\u0011\ty%!\u0016\u0011\u0007\u001d\f\t&C\u0002\u0002T!\u0014qAT8uQ&tw\rE\u0002h\u0003/J1!!\u0017i\u0005\r\te.\u001f")
public class StreamPhysicalWindowJoin
extends CommonPhysicalJoin
implements StreamPhysicalRel {
    private final RelOptCluster cluster;
    private final RexNode remainingCondition;
    private final WindowingStrategy leftWindowing;
    private final WindowingStrategy rightWindowing;

    public WindowingStrategy leftWindowing() {
        return this.leftWindowing;
    }

    public WindowingStrategy rightWindowing() {
        return this.rightWindowing;
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        LogicalType logicalType = this.leftWindowing().getTimeAttributeType();
        LogicalType logicalType2 = this.rightWindowing().getTimeAttributeType();
        if (logicalType == null ? logicalType2 != null : !((Object)logicalType).equals(logicalType2)) {
            return litmus.fail("Currently, window join doesn't support different time attribute type of left and right inputs.", new Object[0]);
        }
        WindowSpec windowSpec = this.leftWindowing().getWindow();
        WindowSpec windowSpec2 = this.rightWindowing().getWindow();
        if (windowSpec == null ? windowSpec2 != null : !windowSpec.equals(windowSpec2)) {
            return litmus.fail("Currently, window join doesn't support different window table function of left and right inputs.", new Object[0]);
        }
        return super.isValid(litmus, context);
    }

    @Override
    public boolean requireWatermark() {
        return this.leftWindowing().isRowtime() || this.rightWindowing().isRowtime();
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new StreamPhysicalWindowJoin(this.cluster, traitSet, left, right, joinType, this.remainingCondition, this.leftWindowing(), this.rightWindowing());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String[] leftInputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.left.getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] rightInputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.right.getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        return pw.input("left", this.left).input("right", this.right).item("leftWindow", this.leftWindowing().toSummaryString(leftInputFieldNames)).item("rightWindow", this.rightWindowing().toSummaryString(rightInputFieldNames)).item("joinType", (Object)this.joinSpec().getJoinType()).item("where", this.getExpressionString(this.remainingCondition, (List<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.inputRowType().getFieldNames()).toList(), (Option<List<RexNode>>)None$.MODULE$, RelExplainUtil$.MODULE$.preferExpressionFormat(pw))).item("select", JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldNames()).mkString(", "));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        return new StreamExecWindowJoin(this.joinSpec(), this.leftWindowing(), this.rightWindowing(), InputProperty.DEFAULT, InputProperty.DEFAULT, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public StreamPhysicalWindowJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, JoinRelType joinType, RexNode remainingCondition, WindowingStrategy leftWindowing, WindowingStrategy rightWindowing) {
        this.cluster = cluster;
        this.remainingCondition = remainingCondition;
        this.leftWindowing = leftWindowing;
        this.rightWindowing = rightWindowing;
        super(cluster, traitSet, leftRel, rightRel, remainingCondition, joinType);
        if (this.joinSpec().getNonEquiCondition().isPresent() && PythonUtil$.MODULE$.containsPythonCall(this.joinSpec().getNonEquiCondition().get(), PythonUtil$.MODULE$.containsPythonCall$default$2())) {
            throw new TableException("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)");
        }
        this.isValid(Litmus.THROW, null);
    }
}

