/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.application.ApplicationClusterEntryPoint;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.client.program.DefaultPackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.DynamicParametersConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.entrypoint.YarnEntrypointUtils;
import org.apache.flink.yarn.entrypoint.YarnResourceManagerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

@Internal
public final class YarnApplicationClusterEntryPoint
extends ApplicationClusterEntryPoint {
    private YarnApplicationClusterEntryPoint(Configuration configuration, PackagedProgram program) {
        super(configuration, program, (ResourceManagerFactory)YarnResourceManagerFactory.getInstance());
    }

    protected String getRPCPortRange(Configuration configuration) {
        return configuration.getString(YarnConfigOptions.APPLICATION_MASTER_PORT);
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)YarnApplicationClusterEntryPoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Map<String, String> env = System.getenv();
        String workingDirectory = env.get(ApplicationConstants.Environment.PWD.key());
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (String)"Working directory variable (%s) not set", (Object[])new Object[]{ApplicationConstants.Environment.PWD.key()});
        try {
            YarnEntrypointUtils.logYarnEnvironmentInformation(env, LOG);
        }
        catch (IOException e) {
            LOG.warn("Could not log YARN environment information.", (Throwable)e);
        }
        Configuration dynamicParameters = (Configuration)ClusterEntrypointUtils.parseParametersOrExit((String[])args, (ParserResultFactory)new DynamicParametersConfigurationParserFactory(), YarnApplicationClusterEntryPoint.class);
        Configuration configuration = YarnEntrypointUtils.loadConfiguration(workingDirectory, dynamicParameters, env);
        PackagedProgram program = null;
        try {
            program = YarnApplicationClusterEntryPoint.getPackagedProgram(configuration);
        }
        catch (Exception e) {
            LOG.error("Could not create application program.", (Throwable)e);
            System.exit(1);
        }
        try {
            YarnApplicationClusterEntryPoint.configureExecution((Configuration)configuration, (PackagedProgram)program);
        }
        catch (Exception e) {
            LOG.error("Could not apply application configuration.", (Throwable)e);
            System.exit(1);
        }
        YarnApplicationClusterEntryPoint yarnApplicationClusterEntrypoint = new YarnApplicationClusterEntryPoint(configuration, program);
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)yarnApplicationClusterEntrypoint);
    }

    private static PackagedProgram getPackagedProgram(Configuration configuration) throws FlinkException {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.fromConfiguration((Configuration)configuration);
        PackagedProgramRetriever programRetriever = YarnApplicationClusterEntryPoint.getPackagedProgramRetriever(configuration, applicationConfiguration.getProgramArguments(), applicationConfiguration.getApplicationClassName());
        return programRetriever.getPackagedProgram();
    }

    private static PackagedProgramRetriever getPackagedProgramRetriever(Configuration configuration, String[] programArguments, @Nullable String jobClassName) throws FlinkException {
        File userLibDir = YarnEntrypointUtils.getUsrLibDir(configuration).orElse(null);
        File userApplicationJar = YarnApplicationClusterEntryPoint.getUserApplicationJar(userLibDir, configuration);
        return DefaultPackagedProgramRetriever.create((File)userLibDir, (File)userApplicationJar, (String)jobClassName, (String[])programArguments, (Configuration)configuration);
    }

    private static File getUserApplicationJar(File userLibDir, Configuration configuration) {
        List pipelineJars = ((List)configuration.get(PipelineOptions.JARS)).stream().map(uri -> new File(userLibDir, new Path(uri).getName())).collect(Collectors.toList());
        Preconditions.checkArgument((pipelineJars.size() == 1 ? 1 : 0) != 0, (Object)"Should only have one jar");
        return (File)pipelineJars.get(0);
    }
}

