/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProviderCreator;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.ietf.jgss.GSSException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpServerWithSpengo {
    static final Logger LOG = LoggerFactory.getLogger(TestHttpServerWithSpengo.class);
    private static final String SECRET_STR = "secret";
    private static final String HTTP_USER = "HTTP";
    private static final String PREFIX = "hadoop.http.authentication.";
    private static final long TIMEOUT = 20000L;
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static String realm = KerberosTestUtils.getRealm();
    private static File testRootDir = new File("target", TestHttpServerWithSpengo.class.getName() + "-root");
    private static MiniKdc testMiniKDC;
    private static File secretFile;
    private static UserGroupInformation authUgi;

    @BeforeClass
    public static void setUp() throws Exception {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            testMiniKDC.start();
            testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "keytab-user"});
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup MiniKDC", (boolean)false);
        }
        System.setProperty("sun.security.krb5.debug", "true");
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        authUgi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"keytab-user", (String)httpSpnegoKeytabFile.toString());
        FileWriter w = new FileWriter(secretFile);
        w.write(SECRET_STR);
        ((Writer)w).close();
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthenticationWithProxyUser() throws Exception {
        Configuration spengoConf = this.getSpengoConf(new Configuration());
        System.setProperty("hadoop.log.dir", testRootDir.getAbsolutePath());
        UserGroupInformation.createUserForTesting((String)"userA", (String[])new String[]{"groupA", "groupB"});
        UserGroupInformation.createUserForTesting((String)"userB", (String[])new String[]{"groupB"});
        UserGroupInformation.createUserForTesting((String)"userC", (String[])new String[]{"groupC"});
        spengoConf.set("hadoop.proxyuser.userA.hosts", "*");
        spengoConf.set("hadoop.proxyuser.userA.groups", "groupB");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)spengoConf);
        HttpServer2 httpServer = null;
        try {
            HttpURLConnection conn;
            httpServer = this.getCommonBuilder().setConf(spengoConf).setACL(new AccessControlList("userA groupA")).build();
            httpServer.start();
            Signer signer = this.getSignerToEncrypt();
            AuthenticatedURL.Token token = this.getEncryptedAuthToken(signer, "userA");
            String serverURL = "http://" + NetUtils.getHostPortString((InetSocketAddress)httpServer.getConnectorAddress(0)) + "/";
            AuthenticatedURL authUrl = new AuthenticatedURL();
            for (String servlet : new String[]{"stacks", "jmx", "conf"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet + "?doAs=userB"), token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            }
            for (String servlet : new String[]{"stacks", "jmx", "conf"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet + "?doAs=userC"), token);
                Assert.assertEquals((long)403L, (long)conn.getResponseCode());
            }
            for (String servlet : new String[]{"logLevel", "logs"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet), token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            }
            token = this.getEncryptedAuthToken(signer, "userB");
            for (String servlet : new String[]{"logLevel", "logs"}) {
                conn = authUrl.openConnection(new URL(serverURL + servlet), token);
                Assert.assertEquals((long)403L, (long)conn.getResponseCode());
            }
        }
        finally {
            if (httpServer != null) {
                httpServer.stop();
            }
        }
    }

    @Test
    public void testSessionCookie() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.setBoolean("hadoop.http.authentication.simple.anonymous.allowed", false);
        conf.set("hadoop.http.authentication.signer.secret.provider", TestSignerSecretProvider.class.getName());
        conf.set("hadoop.http.authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        conf.set("hadoop.http.authentication.kerberos.principal", httpSpnegoPrincipal);
        conf.set("hadoop.http.authentication.cookie.domain", realm);
        conf.setBoolean("hadoop.security.authorization", true);
        System.setProperty("hadoop.log.dir", testRootDir.getAbsolutePath());
        HttpServer2 httpServer = null;
        httpServer = this.getCommonBuilder().setConf(conf).build();
        httpServer.start();
        final Signer signer = new Signer((SignerSecretProvider)new TestSignerSecretProvider());
        final AuthenticatedURL authUrl = new AuthenticatedURL();
        final URL url = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)httpServer.getConnectorAddress(0)) + "/conf");
        UserGroupInformation simpleUgi = UserGroupInformation.createRemoteUser((String)"simple-user");
        authUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                int i;
                TestSignerSecretProvider.rollSecret();
                HttpURLConnection conn = null;
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                String cookie = token.toString();
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                Assert.assertEquals((Object)cookie, (Object)token.toString());
                TestSignerSecretProvider.rollSecret();
                conn = authUrl.openConnection(url, token);
                if (conn.getResponseCode() == 401) {
                    Assert.assertFalse((boolean)token.isSet());
                    conn = authUrl.openConnection(url, token);
                }
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                Assert.assertNotEquals((Object)cookie, (Object)token.toString());
                cookie = token.toString();
                for (int i2 = 0; i2 < 3; ++i2) {
                    conn = authUrl.openConnection(url, token);
                    Assert.assertEquals((String)("attempt" + i2), (long)200L, (long)conn.getResponseCode());
                    Assert.assertTrue((boolean)token.isSet());
                    Assert.assertEquals((Object)cookie, (Object)token.toString());
                }
                Subject s = Subject.getSubject(AccessController.getContext());
                HashSet<Object> oldCreds = new HashSet<Object>(s.getPrivateCredentials());
                s.getPrivateCredentials().clear();
                for (i = 0; i < 3; ++i) {
                    try {
                        conn = authUrl.openConnection(url, token);
                        Assert.assertEquals((String)("attempt" + i), (long)200L, (long)conn.getResponseCode());
                    }
                    catch (AuthenticationException ae) {
                        Assert.fail((String)("attempt" + i + " " + (Object)((Object)ae)));
                    }
                    Assert.assertTrue((boolean)token.isSet());
                    Assert.assertEquals((Object)cookie, (Object)token.toString());
                }
                TestSignerSecretProvider.rollSecret();
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)401L, (long)conn.getResponseCode());
                Assert.assertFalse((boolean)token.isSet());
                Assert.assertEquals((Object)"", (Object)token.toString());
                s.getPrivateCredentials().addAll(oldCreds);
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                cookie = token.toString();
                for (i = 0; i < 3; ++i) {
                    conn = authUrl.openConnection(url, token);
                    Assert.assertEquals((String)("attempt" + i), (long)200L, (long)conn.getResponseCode());
                    Assert.assertTrue((boolean)token.isSet());
                    Assert.assertEquals((Object)cookie, (Object)token.toString());
                }
                return null;
            }
        });
        simpleUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestSignerSecretProvider.rollSecret();
                AuthenticatedURL authUrl = new AuthenticatedURL();
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                HttpURLConnection conn = null;
                try {
                    authUrl.openConnection(url, token);
                    Assert.fail((String)"should fail with no credentials");
                }
                catch (AuthenticationException ae) {
                    Assert.assertNotNull((Object)ae.getCause());
                    Assert.assertEquals(GSSException.class, ae.getCause().getClass());
                    GSSException gsse = (GSSException)ae.getCause();
                    Assert.assertEquals((long)13L, (long)gsse.getMajor());
                }
                catch (Throwable t) {
                    Assert.fail((String)("Unexpected exception" + t));
                }
                Assert.assertFalse((boolean)token.isSet());
                token = TestHttpServerWithSpengo.this.getEncryptedAuthToken(signer, "valid");
                String cookie = token.toString();
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                Assert.assertEquals((Object)cookie, (Object)token.toString());
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)200L, (long)conn.getResponseCode());
                Assert.assertTrue((boolean)token.isSet());
                Assert.assertEquals((Object)cookie, (Object)token.toString());
                TestSignerSecretProvider.rollSecret();
                conn = authUrl.openConnection(url, token);
                Assert.assertEquals((long)401L, (long)conn.getResponseCode());
                Assert.assertFalse((boolean)token.isSet());
                Assert.assertEquals((Object)"", (Object)token.toString());
                return null;
            }
        });
    }

    private AuthenticatedURL.Token getEncryptedAuthToken(Signer signer, String user) throws Exception {
        AuthenticationToken token = new AuthenticationToken(user, user, "kerberos");
        token.setExpires(System.currentTimeMillis() + 20000L);
        return new AuthenticatedURL.Token(signer.sign(token.toString()));
    }

    private Signer getSignerToEncrypt() throws Exception {
        StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", SECRET_STR);
        secretProvider.init(secretProviderProps, null, 20000L);
        return new Signer((SignerSecretProvider)secretProvider);
    }

    private Configuration getSpengoConf(Configuration conf) {
        conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        conf.set("hadoop.http.authentication.type", "kerberos");
        conf.setBoolean("hadoop.http.authentication.simple.anonymous.allowed", false);
        conf.set("hadoop.http.authentication.signature.secret.file", secretFile.getAbsolutePath());
        conf.set("hadoop.http.authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        conf.set("hadoop.http.authentication.kerberos.principal", httpSpnegoPrincipal);
        conf.set("hadoop.http.authentication.cookie.domain", realm);
        conf.setBoolean("hadoop.security.authorization", true);
        return conf;
    }

    private HttpServer2.Builder getCommonBuilder() throws Exception {
        return new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost:0")).setFindPort(true);
    }

    static {
        secretFile = new File(testRootDir, SECRET_STR);
    }

    public static class TestSignerSecretProvider
    extends SignerSecretProvider {
        static int n = 0;
        static byte[] secret;

        static void rollSecret() {
            secret = ("secret[" + n++ + "]").getBytes();
        }

        public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
            TestSignerSecretProvider.rollSecret();
        }

        public byte[] getCurrentSecret() {
            return secret;
        }

        public byte[][] getAllSecrets() {
            return new byte[][]{secret};
        }
    }
}

