/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestPermission {
    public static final Log LOG = LogFactory.getLog(TestPermission.class);
    private static final Path ROOT_PATH = new Path("/data");
    private static final Path CHILD_DIR1 = new Path(ROOT_PATH, "child1");
    private static final Path CHILD_DIR2 = new Path(ROOT_PATH, "child2");
    private static final Path CHILD_FILE1 = new Path(ROOT_PATH, "file1");
    private static final Path CHILD_FILE2 = new Path(ROOT_PATH, "file2");
    private static final Path CHILD_FILE3 = new Path(ROOT_PATH, "file3");
    private static final int FILE_LEN = 100;
    private static final Random RAN = new Random();
    private static final String USER_NAME = "user" + RAN.nextInt();
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2"};

    static FsPermission checkPermission(FileSystem fs, String path, FsPermission expected) throws IOException {
        FileStatus s = fs.getFileStatus(new Path(path));
        LOG.info((Object)(s.getPath() + ": " + s.isDirectory() + " " + s.getPermission() + ":" + s.getOwner() + ":" + s.getGroup()));
        if (expected != null) {
            Assert.assertEquals((Object)expected, (Object)s.getPermission());
            Assert.assertEquals((long)expected.toShort(), (long)s.getPermission().toShort());
        }
        return s.getPermission();
    }

    @Test
    public void testBackwardCompatibility() {
        FsPermission perm = new FsPermission(18);
        Configuration conf = new Configuration();
        FsPermission.setUMask((Configuration)conf, (FsPermission)perm);
        Assert.assertEquals((long)18L, (long)FsPermission.getUMask((Configuration)conf).toShort());
        perm = new FsPermission(18);
        conf = new Configuration();
        conf.set("dfs.umask", "18");
        Assert.assertEquals((long)18L, (long)FsPermission.getUMask((Configuration)conf).toShort());
        conf = new Configuration();
        conf.set("dfs.umask", "18");
        conf.set("fs.permissions.umask-mode", "000");
        Assert.assertEquals((long)18L, (long)FsPermission.getUMask((Configuration)conf).toShort());
        conf = new Configuration();
        conf.set("fs.permissions.umask-mode", "022");
        Assert.assertEquals((long)18L, (long)FsPermission.getUMask((Configuration)conf).toShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.set("fs.permissions.umask-mode", "000");
        MiniDFSCluster cluster = null;
        FileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fs = FileSystem.get((Configuration)conf);
            FsPermission rootPerm = TestPermission.checkPermission(fs, "/", null);
            FsPermission inheritPerm = FsPermission.createImmutable((short)((short)(rootPerm.toShort() | 0xC0)));
            FsPermission dirPerm = new FsPermission(511);
            fs.mkdirs(new Path("/a1/a2/a3"), dirPerm);
            TestPermission.checkPermission(fs, "/a1", dirPerm);
            TestPermission.checkPermission(fs, "/a1/a2", dirPerm);
            TestPermission.checkPermission(fs, "/a1/a2/a3", dirPerm);
            dirPerm = new FsPermission(83);
            FsPermission permission = FsPermission.createImmutable((short)((short)(dirPerm.toShort() | 0xC0)));
            fs.mkdirs(new Path("/aa/1/aa/2/aa/3"), dirPerm);
            TestPermission.checkPermission(fs, "/aa/1", permission);
            TestPermission.checkPermission(fs, "/aa/1/aa/2", permission);
            TestPermission.checkPermission(fs, "/aa/1/aa/2/aa/3", dirPerm);
            FsPermission filePerm = new FsPermission(292);
            Path p = new Path("/b1/b2/b3.txt");
            FSDataOutputStream out = fs.create(p, filePerm, true, conf.getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(p), fs.getDefaultBlockSize(p), null);
            out.write(123);
            out.close();
            TestPermission.checkPermission(fs, "/b1", inheritPerm);
            TestPermission.checkPermission(fs, "/b1/b2", inheritPerm);
            TestPermission.checkPermission(fs, "/b1/b2/b3.txt", filePerm);
            conf.set("fs.permissions.umask-mode", "022");
            permission = FsPermission.createImmutable((short)438);
            FileSystem.mkdirs((FileSystem)fs, (Path)new Path("/c1"), (FsPermission)new FsPermission(permission));
            FileSystem.create((FileSystem)fs, (Path)new Path("/c1/c2.txt"), (FsPermission)new FsPermission(permission));
            TestPermission.checkPermission(fs, "/c1", permission);
            TestPermission.checkPermission(fs, "/c1/c2.txt", permission);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
            try {
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilePermision() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        try {
            FileSystem nnfs = FileSystem.get((Configuration)conf);
            Assert.assertFalse((boolean)nnfs.exists(CHILD_FILE1));
            try {
                nnfs.setOwner(CHILD_FILE1, "foo", "bar");
                Assert.assertTrue((boolean)false);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)("GOOD: got " + e));
            }
            try {
                nnfs.setPermission(CHILD_FILE1, new FsPermission(511));
                Assert.assertTrue((boolean)false);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)("GOOD: got " + e));
            }
            FSDataOutputStream out = nnfs.create(CHILD_FILE1, new FsPermission(511), true, 1024, (short)1, 1024L, null);
            FileStatus status = nnfs.getFileStatus(CHILD_FILE1);
            Assert.assertTrue((boolean)status.getPermission().toString().equals("rwxr-xr-x"));
            nnfs.delete(CHILD_FILE1, false);
            nnfs.mkdirs(CHILD_DIR1);
            out = nnfs.create(CHILD_FILE1);
            status = nnfs.getFileStatus(CHILD_FILE1);
            Assert.assertTrue((boolean)status.getPermission().toString().equals("rw-r--r--"));
            byte[] data = new byte[100];
            RAN.nextBytes(data);
            out.write(data);
            out.close();
            nnfs.setPermission(CHILD_FILE1, new FsPermission("700"));
            status = nnfs.getFileStatus(CHILD_FILE1);
            Assert.assertTrue((boolean)status.getPermission().toString().equals("rwx------"));
            byte[] dataIn = new byte[100];
            FSDataInputStream fin = nnfs.open(CHILD_FILE1);
            int bytesRead = fin.read(dataIn);
            Assert.assertTrue((bytesRead == 100 ? 1 : 0) != 0);
            for (int i = 0; i < 100; ++i) {
                Assert.assertEquals((long)data[i], (long)dataIn[i]);
            }
            nnfs.setPermission(CHILD_FILE1, new FsPermission("755"));
            status = nnfs.getFileStatus(CHILD_FILE1);
            Assert.assertTrue((boolean)status.getPermission().toString().equals("rwxr-xr-x"));
            nnfs.setPermission(CHILD_FILE1, new FsPermission("744"));
            status = nnfs.getFileStatus(CHILD_FILE1);
            Assert.assertTrue((boolean)status.getPermission().toString().equals("rwxr--r--"));
            nnfs.setPermission(CHILD_FILE1, new FsPermission("700"));
            UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
            FileSystem userfs = DFSTestUtil.getFileSystemAs(userGroupInfo, (Configuration)conf);
            userfs.mkdirs(CHILD_DIR1);
            Assert.assertTrue((!TestPermission.canMkdirs(userfs, CHILD_DIR2) ? 1 : 0) != 0);
            Assert.assertTrue((!TestPermission.canCreate(userfs, CHILD_FILE2) ? 1 : 0) != 0);
            Assert.assertTrue((!TestPermission.canOpen(userfs, CHILD_FILE1) ? 1 : 0) != 0);
            nnfs.setPermission(ROOT_PATH, new FsPermission(493));
            nnfs.setPermission(CHILD_DIR1, new FsPermission("777"));
            nnfs.setPermission(new Path("/"), new FsPermission(511));
            Path RENAME_PATH = new Path("/foo/bar");
            userfs.mkdirs(RENAME_PATH);
            Assert.assertTrue((boolean)TestPermission.canRename(userfs, RENAME_PATH, CHILD_DIR1));
            Assert.assertFalse((boolean)userfs.exists(CHILD_FILE3));
            try {
                userfs.setOwner(CHILD_FILE3, "foo", "bar");
                Assert.fail((String)"setOwner should fail for non-exist file");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            try {
                userfs.setPermission(CHILD_FILE3, new FsPermission(511));
                Assert.fail((String)"setPermission should fail for non-exist file");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static boolean canMkdirs(FileSystem fs, Path p) throws IOException {
        try {
            fs.mkdirs(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canCreate(FileSystem fs, Path p) throws IOException {
        try {
            fs.create(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canOpen(FileSystem fs, Path p) throws IOException {
        try {
            fs.open(p);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    static boolean canRename(FileSystem fs, Path src, Path dst) throws IOException {
        try {
            fs.rename(src, dst);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

