/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.quotas.RegionSizeReportingChore;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.quotas.RegionSizeStoreImpl;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionSizeReportingChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSizeReportingChore.class);

    @Test
    public void testDefaultConfigurationProperties() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        RegionSizeReportingChore chore = new RegionSizeReportingChore((RegionServerServices)rs);
        Assert.assertEquals((long)30000L, (long)chore.getInitialDelay());
        Assert.assertEquals((long)60000L, (long)chore.getPeriod());
        Assert.assertEquals((Object)((Object)TimeUnit.valueOf(RegionSizeReportingChore.REGION_SIZE_REPORTING_CHORE_TIMEUNIT_DEFAULT)), (Object)((Object)chore.getTimeUnit()));
    }

    @Test
    public void testNonDefaultConfigurationProperties() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        int period = 60001;
        long delay = 30001L;
        String timeUnit = TimeUnit.SECONDS.name();
        conf.setInt("hbase.regionserver.quotas.region.size.reporting.chore.period", 60001);
        conf.setLong("hbase.regionserver.quotas.region.size.reporting.chore.delay", 30001L);
        conf.set("hbase.regionserver.quotas.region.size.reporting.chore.timeunit", timeUnit);
        RegionSizeReportingChore chore = new RegionSizeReportingChore((RegionServerServices)rs);
        Assert.assertEquals((long)30001L, (long)chore.getInitialDelay());
        Assert.assertEquals((long)60001L, (long)chore.getPeriod());
        Assert.assertEquals((Object)((Object)TimeUnit.valueOf(timeUnit)), (Object)((Object)chore.getTimeUnit()));
    }

    @Test
    public void testRemovableOfNonOnlineRegions() {
        Configuration conf = this.getDefaultHBaseConfiguration();
        HRegionServer rs = this.mockRegionServer(conf);
        RegionSizeReportingChore chore = new RegionSizeReportingChore((RegionServerServices)rs);
        RegionInfo infoA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"T1")).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        RegionInfo infoB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"T1")).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"d")).build();
        RegionInfo infoC = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"T1")).setStartKey(Bytes.toBytes((String)"c")).setEndKey(Bytes.toBytes((String)"d")).build();
        RegionSizeStoreImpl store = new RegionSizeStoreImpl();
        store.put(infoA, 1024L);
        store.put(infoB, 1024L);
        store.put(infoC, 1024L);
        chore.removeNonOnlineRegions((RegionSizeStore)store, Collections.emptySet());
        Assert.assertTrue((boolean)store.isEmpty());
        store.put(infoA, 1024L);
        store.put(infoB, 1024L);
        store.put(infoC, 1024L);
        chore.removeNonOnlineRegions((RegionSizeStore)store, new HashSet<RegionInfo>(Arrays.asList(infoA, infoC)));
        Assert.assertEquals((long)2L, (long)store.size());
        Assert.assertNotNull((Object)store.getRegionSize(infoA));
        Assert.assertNotNull((Object)store.getRegionSize(infoC));
    }

    private Configuration getDefaultHBaseConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.addResource("hbase-default.xml");
        return conf;
    }

    private HRegionServer mockRegionServer(Configuration conf) {
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)rs.getConfiguration()).thenReturn((Object)conf);
        return rs;
    }
}

