/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.master.procedure.Queue;
import org.apache.hadoop.hbase.util.AvlUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FairQueue<T extends Comparable<T>> {
    private Queue<T> queueHead = null;
    private int size = 0;

    public boolean hasRunnables() {
        return this.size > 0;
    }

    public void add(Queue<T> queue) {
        if (this.queueHead == null || queue.getPriority() == 1) {
            this.queueHead = (Queue)AvlUtil.AvlIterableList.append(this.queueHead, queue);
            ++this.size;
            return;
        }
        Queue base = this.queueHead;
        do {
            if (base.getPriority() >= queue.getPriority()) continue;
            this.queueHead = (Queue)AvlUtil.AvlIterableList.prepend(this.queueHead, (AvlUtil.AvlLinkedNode)base, queue);
            ++this.size;
            return;
        } while ((base = (Queue)AvlUtil.AvlIterableList.readNext(base)) != this.queueHead);
        this.queueHead = (Queue)AvlUtil.AvlIterableList.append(this.queueHead, queue);
        ++this.size;
    }

    public void remove(Queue<T> queue) {
        this.queueHead = (Queue)AvlUtil.AvlIterableList.remove(this.queueHead, queue);
        --this.size;
    }

    public Queue<T> poll() {
        if (this.queueHead == null) {
            return null;
        }
        Queue q = this.queueHead;
        do {
            if (!q.isAvailable()) continue;
            if (q.getPriority() == 1) {
                this.queueHead = (Queue)AvlUtil.AvlIterableList.remove(this.queueHead, (AvlUtil.AvlLinkedNode)q);
                this.queueHead = (Queue)AvlUtil.AvlIterableList.append(this.queueHead, (AvlUtil.AvlLinkedNode)q);
            }
            return q;
        } while ((q = (Queue)AvlUtil.AvlIterableList.readNext(q)) != this.queueHead);
        return null;
    }
}

