/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class SortedDynPartitionOptimizer
implements Transform {
    private static final String BUCKET_NUMBER_COL_NAME = "_bucket_number";

    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        String FS = FileSinkOperator.getOperatorName() + "%";
        opRules.put(new RuleRegExp("Sorted Dynamic Partition", FS), this.getSortDynPartProc(pCtx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private NodeProcessor getSortDynPartProc(ParseContext pCtx) {
        return new SortedDynamicPartitionProc(pCtx);
    }

    class SortedDynamicPartitionProc
    implements NodeProcessor {
        private final Log LOG = LogFactory.getLog(SortedDynPartitionOptimizer.class);
        protected ParseContext parseCtx;

        public SortedDynamicPartitionProc(ParseContext pCtx) {
            this.parseCtx = pCtx;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FileSinkOperator fsOp = (FileSinkOperator)nd;
            this.LOG.info((Object)"Sorted dynamic partitioning optimization kicked in..");
            if (((FileSinkDesc)fsOp.getConf()).getDynPartCtx() == null) {
                this.LOG.debug((Object)"Bailing out of sort dynamic partition optimization as dynamic partitioning context is null");
                return null;
            }
            ListBucketingCtx lbCtx = ((FileSinkDesc)fsOp.getConf()).getLbCtx();
            if (lbCtx != null && !lbCtx.getSkewedColNames().isEmpty() && !lbCtx.getSkewedColValues().isEmpty()) {
                this.LOG.debug((Object)"Bailing out of sort dynamic partition optimization as list bucketing is enabled");
                return null;
            }
            Table destTable = ((FileSinkDesc)fsOp.getConf()).getTable();
            if (destTable == null) {
                this.LOG.debug((Object)"Bailing out of sort dynamic partition optimization as destination table is null");
                return null;
            }
            if (!this.removeRSInsertedByEnforceBucketing(fsOp)) {
                this.LOG.debug((Object)"Bailing out of sort dynamic partition optimization as some partition columns got constant folded.");
                return null;
            }
            Operator<OperatorDesc> fsParent = fsOp.getParentOperators().get(0);
            fsParent.getChildOperators().clear();
            DynamicPartitionCtx dpCtx = ((FileSinkDesc)fsOp.getConf()).getDynPartCtx();
            int numBuckets = destTable.getNumBuckets();
            dpCtx.setNumBuckets(numBuckets);
            List<Integer> bucketPositions = this.getBucketPositions(destTable.getBucketCols(), destTable.getCols());
            ObjectPair<List<Integer>, List<Integer>> sortOrderPositions = this.getSortPositionsOrder(destTable.getSortCols(), destTable.getCols());
            List<Integer> sortPositions = null;
            List<Integer> sortOrder = null;
            if (((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.DELETE) {
                sortPositions = Arrays.asList(0);
                sortOrder = Arrays.asList(1);
            } else {
                sortPositions = sortOrderPositions.getFirst();
                sortOrder = sortOrderPositions.getSecond();
            }
            this.LOG.debug((Object)"Got sort order");
            for (int i : sortPositions) {
                this.LOG.debug((Object)("sort position " + i));
            }
            for (int i : sortOrder) {
                this.LOG.debug((Object)("sort order " + i));
            }
            List<Integer> partitionPositions = this.getPartitionPositions(dpCtx, fsParent.getSchema());
            ArrayList<ColumnInfo> colInfos = fsParent.getSchema().getSignature();
            ArrayList<ExprNodeDesc> bucketColumns = this.getPositionsToExprNodes(bucketPositions, colInfos);
            ((FileSinkDesc)fsOp.getConf()).setMultiFileSpray(false);
            ((FileSinkDesc)fsOp.getConf()).setNumFiles(1);
            ((FileSinkDesc)fsOp.getConf()).setTotalFiles(1);
            RowSchema outRS = new RowSchema(fsParent.getSchema());
            ArrayList<ColumnInfo> valColInfo = Lists.newArrayList(fsParent.getSchema().getSignature());
            ArrayList<ExprNodeDesc> newValueCols = Lists.newArrayList();
            HashMap<String, ExprNodeDesc> colExprMap = Maps.newHashMap();
            for (ColumnInfo ci : valColInfo) {
                newValueCols.add(new ExprNodeColumnDesc(ci));
                colExprMap.put(ci.getInternalName(), newValueCols.get(newValueCols.size() - 1));
            }
            ReduceSinkDesc rsConf = this.getReduceSinkDesc(partitionPositions, sortPositions, sortOrder, newValueCols, bucketColumns, numBuckets, fsParent, ((FileSinkDesc)fsOp.getConf()).getWriteType());
            if (!bucketColumns.isEmpty()) {
                String tableAlias = outRS.getSignature().get(0).getTabAlias();
                ColumnInfo ci = new ColumnInfo(SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME, TypeInfoFactory.stringTypeInfo, tableAlias, true, true);
                outRS.getSignature().add(ci);
            }
            ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsConf, new RowSchema(outRS.getSignature()), fsParent);
            rsOp.setColumnExprMap(colExprMap);
            RowSchema exRR = new RowSchema(outRS);
            ExtractDesc exConf = new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false));
            ExtractOperator exOp = (ExtractOperator)OperatorFactory.getAndMakeChild(exConf, exRR, rsOp);
            fsOp.getParentOperators().clear();
            fsOp.getParentOperators().add(exOp);
            exOp.getChildOperators().add(fsOp);
            ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_SORTED);
            if (bucketColumns.size() > 0) {
                ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED);
            }
            ArrayList<ExprNodeDesc> partitionColumns = this.getPositionsToExprNodes(partitionPositions, rsOp.getSchema().getSignature());
            ((FileSinkDesc)fsOp.getConf()).setPartitionCols(partitionColumns);
            this.LOG.info((Object)("Inserted " + rsOp.getOperatorId() + " and " + exOp.getOperatorId() + " as parent of " + fsOp.getOperatorId() + " and child of " + fsParent.getOperatorId()));
            return null;
        }

        private boolean removeRSInsertedByEnforceBucketing(FileSinkOperator fsOp) {
            HiveConf hconf = this.parseCtx.getConf();
            boolean enforceBucketing = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEENFORCEBUCKETING);
            boolean enforceSorting = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEENFORCESORTING);
            if (enforceBucketing || enforceSorting) {
                Set<ReduceSinkOperator> reduceSinks = OperatorUtils.findOperatorsUpstream(fsOp, ReduceSinkOperator.class);
                Operator rsToRemove = null;
                List<ReduceSinkOperator> rsOps = this.parseCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting();
                boolean found = false;
                for (ReduceSinkOperator reduceSink : reduceSinks) {
                    for (ReduceSinkOperator rsOp : rsOps) {
                        if (!reduceSink.equals(rsOp)) continue;
                        rsToRemove = reduceSink;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) {
                    Operator<OperatorDesc> rsParent = rsToRemove.getParentOperators().get(0);
                    Operator<OperatorDesc> rsChild = rsToRemove.getChildOperators().get(0);
                    Operator<OperatorDesc> rsGrandChild = rsChild.getChildOperators().get(0);
                    if (rsChild instanceof ExtractOperator) {
                        if (rsParent.getSchema().getSignature().size() != rsChild.getSchema().getSignature().size()) {
                            return false;
                        }
                        rsParent.getChildOperators().clear();
                        rsParent.getChildOperators().add(rsGrandChild);
                        rsGrandChild.getParentOperators().clear();
                        rsGrandChild.getParentOperators().add(rsParent);
                        this.LOG.info((Object)("Removed " + rsToRemove.getOperatorId() + " and " + rsChild.getOperatorId() + " as it was introduced by enforce bucketing/sorting."));
                    }
                }
            }
            return true;
        }

        private List<Integer> getPartitionPositions(DynamicPartitionCtx dpCtx, RowSchema schema) {
            int numPartCols = dpCtx.getNumDPCols();
            int numCols = schema.getSignature().size();
            ArrayList<Integer> partPos = Lists.newArrayList();
            for (int i = numCols - numPartCols; i < numCols; ++i) {
                partPos.add(i);
            }
            return partPos;
        }

        private List<Integer> getBucketPositions(List<String> tabBucketCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> posns = new ArrayList<Integer>();
            block0: for (String bucketCol : tabBucketCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (bucketCol.equals(tabCol.getName())) {
                        posns.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return posns;
        }

        public ReduceSinkDesc getReduceSinkDesc(List<Integer> partitionPositions, List<Integer> sortPositions, List<Integer> sortOrder, ArrayList<ExprNodeDesc> newValueCols, ArrayList<ExprNodeDesc> bucketColumns, int numBuckets, Operator<? extends OperatorDesc> parent, AcidUtils.Operation writeType) {
            String parentRSOpOrder;
            boolean isOrderBy;
            ArrayList<Integer> keyColsPosInVal = Lists.newArrayList();
            ArrayList<ExprNodeDesc> newKeyCols = Lists.newArrayList();
            ArrayList<Integer> newSortOrder = Lists.newArrayList();
            int numPartAndBuck = partitionPositions.size();
            keyColsPosInVal.addAll(partitionPositions);
            if (!bucketColumns.isEmpty()) {
                keyColsPosInVal.add(-1);
                ++numPartAndBuck;
            }
            keyColsPosInVal.addAll(sortPositions);
            Integer order = 1;
            if (sortOrder != null && !sortOrder.isEmpty() && sortOrder.get(0) == 0) {
                order = 0;
            }
            for (int i = 0; i < numPartAndBuck; ++i) {
                newSortOrder.add(order);
            }
            newSortOrder.addAll(sortOrder);
            String orderStr = "";
            for (Integer i : newSortOrder) {
                if (i == 1) {
                    orderStr = orderStr + "+";
                    continue;
                }
                orderStr = orderStr + "-";
            }
            ArrayList<ExprNodeDesc> newPartCols = Lists.newArrayList();
            for (Integer idx : keyColsPosInVal) {
                if (idx < 0) {
                    ExprNodeConstantDesc encd = new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME);
                    newKeyCols.add(encd);
                    newValueCols.add(encd);
                    continue;
                }
                newKeyCols.add(newValueCols.get(idx).clone());
            }
            for (Integer idx : partitionPositions) {
                newPartCols.add(newValueCols.get(idx).clone());
            }
            ReduceSinkOperator parentRSOp = OperatorUtils.findSingleOperatorUpstream(parent, ReduceSinkOperator.class);
            boolean bl = isOrderBy = this.parseCtx.getQB().getParseInfo().getDestToOrderBy().size() > 0;
            if (parentRSOp != null && isOrderBy && (parentRSOpOrder = ((ReduceSinkDesc)parentRSOp.getConf()).getOrder()) != null && !parentRSOpOrder.isEmpty() && sortPositions.isEmpty()) {
                newKeyCols.addAll(((ReduceSinkDesc)parentRSOp.getConf()).getKeyCols());
                orderStr = orderStr + parentRSOpOrder;
            }
            List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(newKeyCols, "reducesinkkey");
            TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, orderStr);
            ArrayList<String> outputKeyCols = Lists.newArrayList();
            for (int i = 0; i < newKeyCols.size(); ++i) {
                outputKeyCols.add("reducesinkkey" + i);
            }
            List<String> outCols = Utilities.getInternalColumnNamesFromSignature(parent.getSchema().getSignature());
            ArrayList<String> outValColNames = Lists.newArrayList(outCols);
            if (!bucketColumns.isEmpty()) {
                outValColNames.add(SortedDynPartitionOptimizer.BUCKET_NUMBER_COL_NAME);
            }
            List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(newValueCols, outValColNames, 0, "");
            TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
            ArrayList<List<Integer>> distinctColumnIndices = Lists.newArrayList();
            ReduceSinkDesc rsConf = new ReduceSinkDesc(newKeyCols, newKeyCols.size(), newValueCols, outputKeyCols, distinctColumnIndices, outValColNames, -1, newPartCols, -1, keyTable, valueTable, writeType);
            rsConf.setBucketCols(bucketColumns);
            rsConf.setNumBuckets(numBuckets);
            return rsConf;
        }

        private ObjectPair<List<Integer>, List<Integer>> getSortPositionsOrder(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> sortPositions = Lists.newArrayList();
            ArrayList<Integer> sortOrders = Lists.newArrayList();
            block0: for (Order sortCol : tabSortCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (sortCol.getCol().equals(tabCol.getName())) {
                        sortPositions.add(pos);
                        sortOrders.add(sortCol.getOrder());
                        continue block0;
                    }
                    ++pos;
                }
            }
            return new ObjectPair<List<Integer>, List<Integer>>(sortPositions, sortOrders);
        }

        private ArrayList<ExprNodeDesc> getPositionsToExprNodes(List<Integer> pos, List<ColumnInfo> colInfos) {
            ArrayList<ExprNodeDesc> cols = Lists.newArrayList();
            for (Integer idx : pos) {
                ColumnInfo ci = colInfos.get(idx);
                ExprNodeColumnDesc encd = new ExprNodeColumnDesc(ci);
                cols.add(encd);
            }
            return cols;
        }
    }
}

