/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.exec.spark.KryoSerializer;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.Reporter;
import scala.Tuple2;

public class HiveKVResultCache {
    public static final int IN_MEMORY_CACHE_SIZE = 512;
    private static final String COL_NAMES = "key,value";
    private static final String COL_TYPES = "binary:binary";
    private RowContainer backupContainer;
    private RowContainer container;
    private Configuration conf;
    private int cursor = 0;

    public HiveKVResultCache(Configuration conf) {
        this.container = HiveKVResultCache.initRowContainer(conf);
        this.conf = conf;
    }

    private static RowContainer initRowContainer(Configuration conf) {
        RowContainer container;
        try {
            container = new RowContainer(512, conf, Reporter.NULL);
            String fileFormat = HiveConf.getVar(conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
            TableDesc tableDesc = PlanUtils.getDefaultQueryOutputTableDesc(COL_NAMES, COL_TYPES, fileFormat);
            SerDe serDe = (SerDe)tableDesc.getDeserializer();
            ObjectInspector oi = ObjectInspectorUtils.getStandardObjectInspector(serDe.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            container.setSerDe(serDe, oi);
            container.setTableDesc(tableDesc);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create RowContainer", ex);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HiveKey key, BytesWritable value) {
        byte[] hiveKeyBytes = KryoSerializer.serialize((Object)key);
        BytesWritable wrappedHiveKey = new BytesWritable(hiveKeyBytes);
        ArrayList<BytesWritable> row = new ArrayList<BytesWritable>(2);
        row.add(wrappedHiveKey);
        row.add(value);
        HiveKVResultCache hiveKVResultCache = this;
        synchronized (hiveKVResultCache) {
            try {
                if (this.cursor == 0) {
                    this.container.addRow(row);
                } else {
                    if (this.backupContainer == null) {
                        this.backupContainer = HiveKVResultCache.initRowContainer(this.conf);
                    }
                    this.backupContainer.addRow(row);
                }
            }
            catch (HiveException ex) {
                throw new RuntimeException("Failed to add KV pair to RowContainer", ex);
            }
        }
    }

    public synchronized void clear() {
        if (this.cursor == 0) {
            return;
        }
        try {
            this.container.clearRows();
        }
        catch (HiveException ex) {
            throw new RuntimeException("Failed to clear rows in RowContainer", ex);
        }
        this.cursor = 0;
    }

    public synchronized boolean hasNext() {
        if (this.container.rowCount() > 0 && this.cursor < this.container.rowCount()) {
            return true;
        }
        if (this.backupContainer == null || this.backupContainer.rowCount() == 0) {
            return false;
        }
        this.clear();
        RowContainer tmp = this.container;
        this.container = this.backupContainer;
        this.backupContainer = tmp;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple2<HiveKey, BytesWritable> next() {
        try {
            Object row;
            HiveKVResultCache hiveKVResultCache = this;
            synchronized (hiveKVResultCache) {
                Preconditions.checkState(this.hasNext());
                row = this.cursor == 0 ? this.container.first() : this.container.next();
                ++this.cursor;
            }
            HiveKey key = KryoSerializer.deserialize(((BytesWritable)row.get(0)).getBytes(), HiveKey.class);
            return new Tuple2((Object)key, row.get(1));
        }
        catch (HiveException ex) {
            throw new RuntimeException("Failed to get row from RowContainer", ex);
        }
    }
}

