/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupByOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Log LOG = LogFactory.getLog(Vectorizer.class);
    Pattern supportedDataTypesPattern;
    List<Task<? extends Serializable>> vectorizableTasks = new ArrayList<Task<? extends Serializable>>();
    Set<Class<?>> supportedGenericUDFs = new HashSet();
    Set<String> supportedAggregationUdfs = new HashSet<String>();
    private PhysicalContext physicalContext = null;

    public Vectorizer() {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|boolean");
        patternBuilder.append("|binary");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|void");
        patternBuilder.append("|decimal.*");
        patternBuilder.append("|char.*");
        patternBuilder.append("|varchar.*");
        this.supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(UDFLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(UDFRegExp.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(GenericUDFElt.class);
        this.supportedGenericUDFs.add(GenericUDFInitCap.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFToChar.class);
        this.supportedGenericUDFs.add(GenericUDFToVarchar.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
    }

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        this.physicalContext = pctx;
        boolean vectorPath = HiveConf.getBoolVar(pctx.getConf(), HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (!vectorPath) {
            LOG.info((Object)"Vectorization is disabled");
            return pctx;
        }
        VectorizationDispatcher disp = new VectorizationDispatcher(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    boolean validateMapWorkOperator(Operator<? extends OperatorDesc> op, MapWork mWork, boolean isTez) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                ret = this.validateGroupByOperator((GroupByOperator)op, false, isTez);
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case TABLESCAN: {
                ret = this.validateTableScanOperator((TableScanOperator)op, mWork);
                break;
            }
            case FILESINK: 
            case LIMIT: 
            case EVENT: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    boolean validateReduceWorkOperator(Operator<? extends OperatorDesc> op) {
        boolean ret = false;
        switch (op.getType()) {
            case EXTRACT: {
                ret = this.validateExtractOperator((ExtractOperator)op);
                break;
            }
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                if (HiveConf.getBoolVar(this.physicalContext.getConf(), HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_GROUPBY_ENABLED)) {
                    ret = this.validateGroupByOperator((GroupByOperator)op, true, true);
                    break;
                }
                ret = false;
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case FILESINK: {
                ret = this.validateFileSinkOperator((FileSinkOperator)op);
                break;
            }
            case LIMIT: 
            case EVENT: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public Boolean nonVectorizableChildOfGroupBy(Operator<? extends OperatorDesc> op) {
        Operator<? extends OperatorDesc> currentOp = op;
        while (currentOp.getParentOperators().size() > 0) {
            if (!(currentOp = currentOp.getParentOperators().get(0)).getType().equals(OperatorType.GROUPBY)) continue;
            GroupByDesc desc = (GroupByDesc)currentOp.getConf();
            boolean isVectorOutput = desc.getVectorDesc().isVectorOutput();
            if (isVectorOutput) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op, MapWork mWork) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        if (desc.isGatherStats()) {
            return false;
        }
        String columns = "";
        String types = "";
        String partitionColumns = "";
        String partitionTypes = "";
        boolean haveInfo = false;
        LinkedHashMap<String, PartitionDesc> partitionDescs = mWork.getPathToPartitionInfo();
        for (Map.Entry<String, PartitionDesc> entry : partitionDescs.entrySet()) {
            PartitionDesc partDesc = entry.getValue();
            if (partDesc.getPartSpec() == null || partDesc.getPartSpec().isEmpty()) continue;
            Properties partProps = partDesc.getProperties();
            if (!haveInfo) {
                columns = partProps.getProperty("columns");
                types = partProps.getProperty("columns.types");
                partitionColumns = partProps.getProperty("partition_columns");
                partitionTypes = partProps.getProperty("partition_columns.types");
                haveInfo = true;
                continue;
            }
            String nextColumns = partProps.getProperty("columns");
            String nextTypes = partProps.getProperty("columns.types");
            String nextPartitionColumns = partProps.getProperty("partition_columns");
            String nextPartitionTypes = partProps.getProperty("partition_columns.types");
            if (!columns.equalsIgnoreCase(nextColumns)) {
                LOG.info((Object)String.format("Could not vectorize partition %s.  Its column names %s do not match the other column names %s", entry.getKey(), nextColumns, columns));
                return false;
            }
            if (!types.equalsIgnoreCase(nextTypes)) {
                LOG.info((Object)String.format("Could not vectorize partition %s.  Its column types %s do not match the other column types %s", entry.getKey(), nextTypes, types));
                return false;
            }
            if (!partitionColumns.equalsIgnoreCase(nextPartitionColumns)) {
                LOG.info((Object)String.format("Could not vectorize partition %s.  Its partition column names %s do not match the other partition column names %s", entry.getKey(), nextPartitionColumns, partitionColumns));
                return false;
            }
            if (partitionTypes.equalsIgnoreCase(nextPartitionTypes)) continue;
            LOG.info((Object)String.format("Could not vectorize partition %s.  Its partition column types %s do not match the other partition column types %s", entry.getKey(), nextPartitionTypes, partitionTypes));
            return false;
        }
        return true;
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        return this.validateExprNodeDesc(filterExprs, VectorExpressionDescriptor.Mode.FILTER) && this.validateExprNodeDesc(keyExprs) && this.validateExprNodeDesc(valueExprs);
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs) && this.validateExprNodeDesc(partitionDescs) && this.validateExprNodeDesc(valueDesc);
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.FILTER);
    }

    private boolean validateGroupByOperator(GroupByOperator op, boolean isReduce, boolean isTez) {
        GroupByDesc desc = (GroupByDesc)op.getConf();
        VectorGroupByDesc vectorDesc = desc.getVectorDesc();
        if (desc.isGroupingSetsPresent()) {
            LOG.info((Object)"Grouping sets not supported in vector mode");
            return false;
        }
        boolean ret = this.validateExprNodeDesc(desc.getKeys());
        if (!ret) {
            return false;
        }
        ret = this.validateAggregationDesc(desc.getAggregators(), isReduce);
        if (!ret) {
            return false;
        }
        if (isReduce) {
            if (desc.isDistinct()) {
                LOG.info((Object)"Distinct not supported in reduce vector mode");
                return false;
            }
            if (desc.getMode() != GroupByDesc.Mode.COMPLETE && desc.getMode() != GroupByDesc.Mode.PARTIAL1 && desc.getMode() != GroupByDesc.Mode.PARTIAL2 && desc.getMode() != GroupByDesc.Mode.MERGEPARTIAL) {
                LOG.info((Object)"Reduce vector mode not supported when input for GROUP BY not sorted");
                return false;
            }
            LOG.info((Object)("Reduce GROUP BY mode is " + desc.getMode().name()));
            if (desc.getGroupKeyNotReductionKey()) {
                LOG.info((Object)"Reduce vector mode not supported when group key is not reduction key");
                return false;
            }
            if (!this.aggregatorsOutputIsPrimitive(desc.getAggregators(), isReduce)) {
                LOG.info((Object)"Reduce vector mode only supported when aggregate outputs are primitive types");
                return false;
            }
            if (desc.getKeys().size() > 0) {
                if (op.getParentOperators().size() > 0) {
                    LOG.info((Object)"Reduce vector mode can only handle a key group GROUP BY operator when it is fed by reduce-shuffle");
                    return false;
                }
                LOG.info((Object)"Reduce-side GROUP BY will process key groups");
                vectorDesc.setVectorGroupBatches(true);
            } else {
                LOG.info((Object)"Reduce-side GROUP BY will do global aggregation");
            }
            vectorDesc.setVectorOutput(true);
            vectorDesc.setIsReduce(true);
        }
        return true;
    }

    private boolean validateExtractOperator(ExtractOperator op) {
        ExprNodeDesc expr = ((ExtractDesc)op.getConf()).getCol();
        boolean ret = this.validateExprNodeDesc(expr);
        return ret;
    }

    private boolean validateFileSinkOperator(FileSinkOperator op) {
        return true;
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs) {
        return this.validateExprNodeDesc(descs, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, mode);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateAggregationDesc(List<AggregationDesc> descs, boolean isReduce) {
        for (AggregationDesc d : descs) {
            boolean ret = this.validateAggregationDesc(d, isReduce);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc) {
        ExprNodeGenericFuncDesc d;
        boolean r;
        ExprNodeColumnDesc c;
        if (desc instanceof ExprNodeColumnDesc && VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((c = (ExprNodeColumnDesc)desc).getColumn())) {
            LOG.info((Object)("Cannot vectorize virtual column " + c.getColumn()));
            return false;
        }
        String typeName = desc.getTypeInfo().getTypeName();
        boolean ret = this.validateDataType(typeName);
        if (!ret) {
            LOG.info((Object)("Cannot vectorize " + desc.toString() + " of type " + typeName));
            return false;
        }
        if (desc instanceof ExprNodeGenericFuncDesc && !(r = this.validateGenericUdf(d = (ExprNodeGenericFuncDesc)desc))) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc d2 : desc.getChildren()) {
                boolean r2 = this.validateExprNodeDescRecursive(d2);
                if (r2) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc) {
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        if (!this.validateExprNodeDescRecursive(desc)) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
            if (vc.getVectorExpression(desc, mode) == null) {
                LOG.info((Object)"getVectorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to vectorize", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
            return this.supportedGenericUDFs.contains(udf);
        }
        return this.supportedGenericUDFs.contains(genericUDF.getClass());
    }

    private boolean validateAggregationDesc(AggregationDesc aggDesc, boolean isReduce) {
        if (!this.supportedAggregationUdfs.contains(aggDesc.getGenericUDAFName().toLowerCase())) {
            return false;
        }
        if (aggDesc.getParameters() != null && !this.validateExprNodeDesc(aggDesc.getParameters())) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
            if (vc.getAggregatorExpression(aggDesc, isReduce) == null) {
                LOG.info((Object)"getAggregatorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to vectorize", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean aggregatorsOutputIsPrimitive(List<AggregationDesc> descs, boolean isReduce) {
        for (AggregationDesc d : descs) {
            boolean ret = this.aggregatorsOutputIsPrimitive(d, isReduce);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean aggregatorsOutputIsPrimitive(AggregationDesc aggDesc, boolean isReduce) {
        VectorAggregateExpression vectorAggrExpr;
        ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
        try {
            vectorAggrExpr = vc.getAggregatorExpression(aggDesc, isReduce);
        }
        catch (Exception e) {
            LOG.info((Object)"Vectorization of aggreation should have succeeded ", (Throwable)e);
            return false;
        }
        ObjectInspector outputObjInspector = vectorAggrExpr.getOutputObjectInspector();
        return outputObjInspector.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    private boolean validateDataType(String type) {
        return this.supportedDataTypesPattern.matcher(type.toLowerCase()).matches();
    }

    private VectorizationContext getVectorizationContext(Operator op, PhysicalContext pctx) {
        RowSchema rs = op.getSchema();
        VectorizationContext vContext = new VectorizationContext();
        for (ColumnInfo c : rs.getSignature()) {
            if (this.isVirtualColumn(c)) continue;
            vContext.addInitialColumn(c.getInternalName());
        }
        vContext.finishedAddingInitialColumns();
        return vContext;
    }

    private void fixupParentChildOperators(Operator<? extends OperatorDesc> op, Operator<? extends OperatorDesc> vectorOp) {
        if (op.getParentOperators() != null) {
            vectorOp.setParentOperators(op.getParentOperators());
            for (Operator<OperatorDesc> p : op.getParentOperators()) {
                p.replaceChild(op, vectorOp);
            }
        }
        if (op.getChildOperators() != null) {
            vectorOp.setChildOperators(op.getChildOperators());
            for (Operator<OperatorDesc> c : op.getChildOperators()) {
                c.replaceParent(op, vectorOp);
            }
        }
    }

    Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext) throws HiveException {
        Operator<? extends OperatorDesc> vectorOp = null;
        switch (op.getType()) {
            case MAPJOIN: 
            case GROUPBY: 
            case FILTER: 
            case SELECT: 
            case REDUCESINK: 
            case FILESINK: 
            case LIMIT: 
            case EVENT: 
            case EXTRACT: {
                vectorOp = OperatorFactory.getVectorOperator(op.getConf(), vContext);
                break;
            }
            default: {
                vectorOp = op;
            }
        }
        if (vectorOp != op) {
            this.fixupParentChildOperators(op, vectorOp);
            ((AbstractOperatorDesc)vectorOp.getConf()).setVectorMode(true);
        }
        return vectorOp;
    }

    private boolean isVirtualColumn(ColumnInfo column) {
        return VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(column.getInternalName());
    }

    public void debugDisplayAllMaps(Map<String, Map<String, Integer>> allColumnVectorMaps, Map<String, Map<Integer, String>> allScratchColumnVectorTypeMaps) {
        Comparator<String> comparerShorterString = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer length1 = o1.length();
                Integer length2 = o2.length();
                return length1.compareTo(length2);
            }
        };
        Comparator<Integer> comparerInteger = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        };
        TreeMap sortedAllColumnVectorMaps = new TreeMap(comparerShorterString);
        for (Map.Entry<String, Map<String, Integer>> entry : allColumnVectorMaps.entrySet()) {
            TreeMap<Integer, String> sortedColumnMap = new TreeMap<Integer, String>(comparerInteger);
            for (Map.Entry<String, Integer> innerEntry : entry.getValue().entrySet()) {
                sortedColumnMap.put(innerEntry.getValue(), innerEntry.getKey());
            }
            sortedAllColumnVectorMaps.put(entry.getKey(), sortedColumnMap);
        }
        LOG.debug((Object)("sortedAllColumnVectorMaps " + sortedAllColumnVectorMaps));
        TreeMap sortedAllScratchColumnVectorTypeMap = new TreeMap(comparerShorterString);
        for (Map.Entry<String, Map<Integer, String>> entry : allScratchColumnVectorTypeMaps.entrySet()) {
            TreeMap<Integer, String> sortedScratchColumnTypeMap = new TreeMap<Integer, String>(comparerInteger);
            sortedScratchColumnTypeMap.putAll(entry.getValue());
            sortedAllScratchColumnVectorTypeMap.put(entry.getKey(), sortedScratchColumnTypeMap);
        }
        LOG.debug((Object)("sortedAllScratchColumnVectorTypeMap " + sortedAllScratchColumnVectorTypeMap));
    }

    private static class ValidatorVectorizationContext
    extends VectorizationContext {
        private ValidatorVectorizationContext() {
        }

        @Override
        protected int getInputColumnIndex(String name) {
            return 0;
        }

        @Override
        protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
            return 0;
        }
    }

    class ReduceWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private List<String> reduceColumnNames;
        private VectorizationContext reduceShuffleVectorizationContext;
        private Operator<? extends OperatorDesc> rootVectorOp;

        public Operator<? extends OperatorDesc> getRootVectorOp() {
            return this.rootVectorOp;
        }

        public ReduceWorkVectorizationNodeProcessor(List<String> reduceColumnNames) {
            this.reduceColumnNames = reduceColumnNames;
            this.rootVectorOp = null;
            this.reduceShuffleVectorizationContext = null;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            LOG.info((Object)("ReduceWorkVectorizationNodeProcessor processing Operator: " + op.getName() + "..."));
            VectorizationContext vContext = null;
            boolean saveRootVectorOp = false;
            if (op.getParentOperators().size() == 0) {
                LOG.info((Object)("ReduceWorkVectorizationNodeProcessor process reduceColumnNames " + this.reduceColumnNames.toString()));
                vContext = new VectorizationContext(this.reduceColumnNames);
                vContext.setFileKey("_REDUCE_SHUFFLE_");
                this.scratchColumnContext.put("_REDUCE_SHUFFLE_", vContext);
                this.reduceShuffleVectorizationContext = vContext;
                saveRootVectorOp = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Vectorized ReduceWork reduce shuffle vectorization context " + vContext.toString()));
                }
            } else {
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.reduceShuffleVectorizationContext;
                }
            }
            assert (vContext != null);
            if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                if (!this.opsDone.contains(op)) {
                    this.opsDone.add(op);
                }
                return null;
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Vectorized ReduceWork operator " + vectorOp.getName() + " vectorization context " + vContext.toString()));
                if (vectorOp instanceof VectorizationContextRegion) {
                    VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                    VectorizationContext vOutContext = vcRegion.getOuputVectorizationContext();
                    LOG.debug((Object)("Vectorized ReduceWork operator " + vectorOp.getName() + " added vectorization context " + vContext.toString()));
                }
            }
            if (vectorOp instanceof VectorGroupByOperator) {
                VectorGroupByOperator groupBy = (VectorGroupByOperator)vectorOp;
                VectorGroupByDesc vectorDesc = ((GroupByDesc)groupBy.getConf()).getVectorDesc();
                vectorDesc.setVectorGroupBatches(true);
            }
            if (saveRootVectorOp && op != vectorOp) {
                this.rootVectorOp = vectorOp;
            }
            return null;
        }
    }

    class MapWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final MapWork mWork;

        public MapWorkVectorizationNodeProcessor(MapWork mWork) {
            this.mWork = mWork;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            LOG.info((Object)("MapWorkVectorizationNodeProcessor processing Operator: " + op.getName() + "..."));
            VectorizationContext vContext = null;
            if (op instanceof TableScanOperator) {
                vContext = Vectorizer.this.getVectorizationContext(op, Vectorizer.this.physicalContext);
                block0: for (String onefile : this.mWork.getPathToAliases().keySet()) {
                    List aliases = this.mWork.getPathToAliases().get(onefile);
                    for (String alias : aliases) {
                        Operator<? extends OperatorDesc> opRoot = this.mWork.getAliasToWork().get(alias);
                        if (op != opRoot) continue;
                        vContext.setFileKey(onefile);
                        this.scratchColumnContext.put(onefile, vContext);
                        if (!LOG.isDebugEnabled()) continue block0;
                        LOG.debug((Object)("Vectorized MapWork operator " + op.getName() + " vectorization context " + vContext.toString()));
                        continue block0;
                    }
                }
                this.vContextsByOp.put(op, vContext);
            } else {
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    throw new SemanticException(String.format("Did not find vectorization context for operator %s in operator stack", op.getName()));
                }
            }
            assert (vContext != null);
            if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                if (!this.opsDone.contains(op)) {
                    this.opsDone.add(op);
                }
                return null;
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Vectorized MapWork operator " + vectorOp.getName() + " vectorization context " + vContext.toString()));
                if (vectorOp instanceof VectorizationContextRegion) {
                    VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                    VectorizationContext vOutContext = vcRegion.getOuputVectorizationContext();
                    LOG.debug((Object)("Vectorized MapWork operator " + vectorOp.getName() + " added vectorization context " + vContext.toString()));
                }
            }
            return null;
        }
    }

    class VectorizationNodeProcessor
    implements NodeProcessor {
        protected final Map<String, VectorizationContext> scratchColumnContext = new HashMap<String, VectorizationContext>();
        protected final Map<Operator<? extends OperatorDesc>, VectorizationContext> vContextsByOp = new HashMap<Operator<? extends OperatorDesc>, VectorizationContext>();
        protected final Set<Operator<? extends OperatorDesc>> opsDone = new HashSet<Operator<? extends OperatorDesc>>();

        VectorizationNodeProcessor() {
        }

        public Map<String, Map<Integer, String>> getAllScratchColumnVectorTypeMaps() {
            HashMap<String, Map<Integer, String>> allScratchColumnVectorTypeMaps = new HashMap<String, Map<Integer, String>>();
            for (String onefile : this.scratchColumnContext.keySet()) {
                VectorizationContext vc = this.scratchColumnContext.get(onefile);
                Map<Integer, String> cmap = vc.getScratchColumnTypeMap();
                allScratchColumnVectorTypeMaps.put(onefile, cmap);
            }
            return allScratchColumnVectorTypeMaps;
        }

        public Map<String, Map<String, Integer>> getAllColumnVectorMaps() {
            HashMap<String, Map<String, Integer>> allColumnVectorMaps = new HashMap<String, Map<String, Integer>>();
            for (String oneFile : this.scratchColumnContext.keySet()) {
                VectorizationContext vc = this.scratchColumnContext.get(oneFile);
                Map<String, Integer> cmap = vc.getProjectionColumnMap();
                allColumnVectorMaps.put(oneFile, cmap);
            }
            return allColumnVectorMaps;
        }

        public VectorizationContext walkStackToFindVectorizationContext(Stack<Node> stack, Operator<? extends OperatorDesc> op) throws SemanticException {
            VectorizationContext vContext = null;
            if (stack.size() <= 1) {
                throw new SemanticException(String.format("Expected operator stack for operator %s to have at least 2 operators", op.getName()));
            }
            int i = stack.size() - 2;
            while (vContext == null) {
                if (i < 0) {
                    return null;
                }
                Operator opParent = (Operator)stack.get(i);
                vContext = this.vContextsByOp.get(opParent);
                --i;
            }
            return vContext;
        }

        public Operator<? extends OperatorDesc> doVectorize(Operator<? extends OperatorDesc> op, VectorizationContext vContext) throws SemanticException {
            Operator<? extends OperatorDesc> vectorOp = op;
            try {
                if (!this.opsDone.contains(op)) {
                    vectorOp = Vectorizer.this.vectorizeOperator(op, vContext);
                    this.opsDone.add(op);
                    if (vectorOp != op) {
                        this.opsDone.add(vectorOp);
                    }
                    if (vectorOp instanceof VectorizationContextRegion) {
                        VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                        VectorizationContext vOutContext = vcRegion.getOuputVectorizationContext();
                        this.vContextsByOp.put(op, vOutContext);
                        this.scratchColumnContext.put(vOutContext.getFileKey(), vOutContext);
                    }
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            return vectorOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            throw new SemanticException("Must be overridden");
        }
    }

    class ReduceWorkValidationNodeProcessor
    implements NodeProcessor {
        ReduceWorkValidationNodeProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateReduceWorkOperator(op);
                if (ret) continue;
                LOG.info((Object)("ReduceWork Operator: " + op.getName() + " could not be vectorized."));
                return new Boolean(false);
            }
            return new Boolean(true);
        }
    }

    class MapWorkValidationNodeProcessor
    implements NodeProcessor {
        private MapWork mapWork;
        private boolean isTez;

        public MapWorkValidationNodeProcessor(MapWork mapWork, boolean isTez) {
            this.mapWork = mapWork;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateMapWorkOperator(op, this.mapWork, this.isTez);
                if (ret) continue;
                LOG.info((Object)("MapWork Operator: " + op.getName() + " could not be vectorized."));
                return new Boolean(false);
            }
            return new Boolean(true);
        }
    }

    class VectorizationDispatcher
    implements Dispatcher {
        private PhysicalContext pctx;
        private List<String> reduceColumnNames;
        private List<TypeInfo> reduceTypeInfos;

        public VectorizationDispatcher(PhysicalContext pctx) {
            this.pctx = pctx;
            this.reduceColumnNames = null;
            this.reduceTypeInfos = null;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            block5: {
                Task currTask;
                block6: {
                    block4: {
                        currTask = (Task)nd;
                        if (!(currTask instanceof MapRedTask)) break block4;
                        this.convertMapWork(((MapredWork)((MapRedTask)currTask).getWork()).getMapWork(), false);
                        break block5;
                    }
                    if (!(currTask instanceof TezTask)) break block6;
                    TezWork work = (TezWork)((TezTask)currTask).getWork();
                    for (BaseWork w : work.getAllWork()) {
                        if (w instanceof MapWork) {
                            this.convertMapWork((MapWork)w, true);
                            continue;
                        }
                        if (!(w instanceof ReduceWork) || !HiveConf.getBoolVar(this.pctx.getConf(), HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                        this.convertReduceWork((ReduceWork)w);
                    }
                    break block5;
                }
                if (!(currTask instanceof SparkTask)) break block5;
                SparkWork sparkWork = (SparkWork)currTask.getWork();
                for (BaseWork baseWork : sparkWork.getAllWork()) {
                    if (baseWork instanceof MapWork) {
                        this.convertMapWork((MapWork)baseWork, false);
                        continue;
                    }
                    if (!(baseWork instanceof ReduceWork) || !HiveConf.getBoolVar(this.pctx.getConf(), HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                    this.convertReduceWork((ReduceWork)baseWork);
                }
            }
            return null;
        }

        private void convertMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            boolean ret = this.validateMapWork(mapWork, isTez);
            if (ret) {
                this.vectorizeMapWork(mapWork);
            }
        }

        private void addMapWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), np);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), np);
        }

        private boolean validateMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            LOG.info((Object)"Validating MapWork...");
            for (String path : mapWork.getPathToPartitionInfo().keySet()) {
                PartitionDesc pd = mapWork.getPathToPartitionInfo().get(path);
                List<Class<?>> interfaceList = Arrays.asList(pd.getInputFileFormatClass().getInterfaces());
                if (interfaceList.contains(VectorizedInputFormatInterface.class)) continue;
                LOG.info((Object)("Input format: " + pd.getInputFileFormatClassName() + ", doesn't provide vectorized input"));
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkValidationNodeProcessor vnp = new MapWorkValidationNodeProcessor(mapWork, isTez);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private void vectorizeMapWork(MapWork mapWork) throws SemanticException {
            LOG.info((Object)"Vectorizing MapWork...");
            mapWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkVectorizationNodeProcessor vnp = new MapWorkVectorizationNodeProcessor(mapWork);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            Map<String, Map<Integer, String>> allScratchColumnVectorTypeMaps = vnp.getAllScratchColumnVectorTypeMaps();
            mapWork.setAllScratchColumnVectorTypeMaps(allScratchColumnVectorTypeMaps);
            Map<String, Map<String, Integer>> allColumnVectorMaps = vnp.getAllColumnVectorMaps();
            mapWork.setAllColumnVectorMaps(allColumnVectorMaps);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(allColumnVectorMaps, allScratchColumnVectorTypeMaps);
            }
        }

        private void convertReduceWork(ReduceWork reduceWork) throws SemanticException {
            boolean ret = this.validateReduceWork(reduceWork);
            if (ret) {
                this.vectorizeReduceWork(reduceWork);
            }
        }

        private boolean getOnlyStructObjectInspectors(ReduceWork reduceWork) throws SemanticException {
            try {
                ObjectInspector keyObjectInspector = reduceWork.getKeyObjectInspector();
                if (keyObjectInspector == null || !(keyObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector keyStructObjectInspector = (StructObjectInspector)keyObjectInspector;
                List<? extends StructField> keyFields = keyStructObjectInspector.getAllStructFieldRefs();
                if (reduceWork.getNeedsTagging()) {
                    return false;
                }
                ObjectInspector valueObjectInspector = reduceWork.getValueObjectInspector();
                if (valueObjectInspector == null || !(valueObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector valueStructObjectInspector = (StructObjectInspector)valueObjectInspector;
                List<? extends StructField> valueFields = valueStructObjectInspector.getAllStructFieldRefs();
                this.reduceColumnNames = new ArrayList<String>();
                this.reduceTypeInfos = new ArrayList<TypeInfo>();
                for (StructField structField : keyFields) {
                    this.reduceColumnNames.add(Utilities.ReduceField.KEY.toString() + "." + structField.getFieldName());
                    this.reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
                for (StructField structField : valueFields) {
                    this.reduceColumnNames.add(Utilities.ReduceField.VALUE.toString() + "." + structField.getFieldName());
                    this.reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
            return true;
        }

        private void addReduceWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", ExtractOperator.getOperatorName() + ".*"), np);
            opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + ".*"), np);
            opRules.put(new RuleRegExp("R3", SelectOperator.getOperatorName() + ".*"), np);
        }

        private boolean validateReduceWork(ReduceWork reduceWork) throws SemanticException {
            LOG.info((Object)"Validating ReduceWork...");
            if (!this.getOnlyStructObjectInspectors(reduceWork)) {
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkValidationNodeProcessor vnp = new ReduceWorkValidationNodeProcessor();
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private void vectorizeReduceWork(ReduceWork reduceWork) throws SemanticException {
            LOG.info((Object)"Vectorizing ReduceWork...");
            reduceWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkVectorizationNodeProcessor vnp = new ReduceWorkVectorizationNodeProcessor(this.reduceColumnNames);
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            LOG.info((Object)("vectorizeReduceWork reducer Operator: " + reduceWork.getReducer().getName() + "..."));
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            reduceWork.setReducer(vnp.getRootVectorOp());
            Operator<?> reducer = reduceWork.getReducer();
            if (reducer.getType().equals(OperatorType.EXTRACT)) {
                ((VectorExtractOperator)reducer).setReduceTypeInfos(this.reduceTypeInfos);
            }
            Map<String, Map<Integer, String>> allScratchColumnVectorTypeMaps = vnp.getAllScratchColumnVectorTypeMaps();
            reduceWork.setAllScratchColumnVectorTypeMaps(allScratchColumnVectorTypeMaps);
            Map<String, Map<String, Integer>> allColumnVectorMaps = vnp.getAllColumnVectorMaps();
            reduceWork.setAllColumnVectorMaps(allColumnVectorMaps);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(allColumnVectorMaps, allScratchColumnVectorTypeMaps);
            }
        }
    }
}

