/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 673: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 674: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 722: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 676: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 703: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 589: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 590: 
                    case 591: 
                    case 592: 
                    case 597: 
                    case 598: 
                    case 599: 
                    case 603: 
                    case 604: 
                    case 606: 
                    case 607: 
                    case 609: 
                    case 612: 
                    case 614: 
                    case 615: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 617: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 618: 
                    case 619: 
                    case 620: 
                    case 621: 
                    case 622: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 777);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 595: 
            case 635: 
            case 637: 
            case 640: 
            case 657: 
            case 658: 
            case 659: 
            case 665: 
            case 667: 
            case 669: 
            case 670: 
            case 671: 
            case 686: 
            case 688: 
            case 724: 
            case 725: 
            case 728: 
            case 785: 
            case 786: 
            case 799: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 834: 
            case 876: 
            case 880: 
            case 881: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 636: 
            case 666: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 623: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 639: 
            case 668: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 656: 
            case 882: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(conf) : new SemanticAnalyzer(conf);
        return semAnalyzer;
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(673, HiveOperation.EXPLAIN);
        commandType.put(722, HiveOperation.LOAD);
        commandType.put(676, HiveOperation.EXPORT);
        commandType.put(703, HiveOperation.IMPORT);
        commandType.put(635, HiveOperation.CREATEDATABASE);
        commandType.put(665, HiveOperation.DROPDATABASE);
        commandType.put(834, HiveOperation.SWITCHDATABASE);
        commandType.put(641, HiveOperation.CREATETABLE);
        commandType.put(876, HiveOperation.TRUNCATETABLE);
        commandType.put(670, HiveOperation.DROPTABLE);
        commandType.put(659, HiveOperation.DESCTABLE);
        commandType.put(658, HiveOperation.DESCFUNCTION);
        commandType.put(728, HiveOperation.MSCK);
        commandType.put(590, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(609, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(607, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(606, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(597, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(591, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(614, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(592, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(615, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(604, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(598, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(801, HiveOperation.SHOWDATABASES);
        commandType.put(807, HiveOperation.SHOWTABLES);
        commandType.put(799, HiveOperation.SHOWCOLUMNS);
        commandType.put(815, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(816, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(809, HiveOperation.SHOW_CREATETABLE);
        commandType.put(803, HiveOperation.SHOWFUNCTIONS);
        commandType.put(804, HiveOperation.SHOWINDEXES);
        commandType.put(806, HiveOperation.SHOWPARTITIONS);
        commandType.put(805, HiveOperation.SHOWLOCKS);
        commandType.put(802, HiveOperation.SHOWLOCKS);
        commandType.put(800, HiveOperation.SHOWCONF);
        commandType.put(636, HiveOperation.CREATEFUNCTION);
        commandType.put(666, HiveOperation.DROPFUNCTION);
        commandType.put(639, HiveOperation.CREATEMACRO);
        commandType.put(668, HiveOperation.DROPMACRO);
        commandType.put(642, HiveOperation.CREATEVIEW);
        commandType.put(671, HiveOperation.DROPVIEW);
        commandType.put(637, HiveOperation.CREATEINDEX);
        commandType.put(667, HiveOperation.DROPINDEX);
        commandType.put(588, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(587, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(621, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(620, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(618, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(619, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(622, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(617, HiveOperation.ALTERVIEW_AS);
        commandType.put(777, HiveOperation.QUERY);
        commandType.put(725, HiveOperation.LOCKTABLE);
        commandType.put(881, HiveOperation.UNLOCKTABLE);
        commandType.put(724, HiveOperation.LOCKDB);
        commandType.put(880, HiveOperation.UNLOCKDB);
        commandType.put(640, HiveOperation.CREATEROLE);
        commandType.put(669, HiveOperation.DROPROLE);
        commandType.put(686, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(785, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(810, HiveOperation.SHOW_GRANT);
        commandType.put(688, HiveOperation.GRANT_ROLE);
        commandType.put(786, HiveOperation.REVOKE_ROLE);
        commandType.put(811, HiveOperation.SHOW_ROLES);
        commandType.put(814, HiveOperation.SHOW_ROLES);
        commandType.put(813, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(812, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(586, HiveOperation.ALTERDATABASE);
        commandType.put(585, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(657, HiveOperation.DESCDATABASE);
        commandType.put(612, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(623, HiveOperation.ANALYZE_TABLE);
        commandType.put(603, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(808, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(817, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(605, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(600, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(601, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(602, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(611, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(610, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(608, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(596, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(613, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(593, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(595, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(616, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

