/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hive.spark.client.JobContext;
import org.apache.hive.spark.client.MonitorCallback;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaSparkContext;

class JobContextImpl
implements JobContext {
    private final JavaSparkContext sc;
    private final ThreadLocal<MonitorCallback> monitorCb;
    private final Map<String, List<JavaFutureAction<?>>> monitoredJobs;
    private final List<String> addedJars;

    public JobContextImpl(JavaSparkContext sc) {
        this.sc = sc;
        this.monitorCb = new ThreadLocal();
        this.monitoredJobs = new ConcurrentHashMap();
        this.addedJars = new CopyOnWriteArrayList<String>();
    }

    @Override
    public JavaSparkContext sc() {
        return this.sc;
    }

    @Override
    public <T> JavaFutureAction<T> monitor(JavaFutureAction<T> job, SparkCounters sparkCounters, Set<Integer> cachedRDDIds) {
        this.monitorCb.get().call(job, sparkCounters, cachedRDDIds);
        return job;
    }

    @Override
    public Map<String, List<JavaFutureAction<?>>> getMonitoredJobs() {
        return this.monitoredJobs;
    }

    @Override
    public List<String> getAddedJars() {
        return this.addedJars;
    }

    void setMonitorCb(MonitorCallback cb) {
        this.monitorCb.set(cb);
    }

    void stop() {
        this.monitoredJobs.clear();
        this.sc.stop();
    }
}

