/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.JobExecutionStatus;

public class RemoteSparkJobMonitor
extends SparkJobMonitor {
    private RemoteSparkJobStatus sparkJobStatus;
    private final HiveConf hiveConf;

    public RemoteSparkJobMonitor(HiveConf hiveConf, RemoteSparkJobStatus sparkJobStatus) {
        super(hiveConf);
        this.sparkJobStatus = sparkJobStatus;
        this.hiveConf = hiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int startMonitor() {
        running = false;
        done = false;
        rc = 0;
        lastProgressMap = null;
        this.perfLogger.PerfLogBegin(RemoteSparkJobMonitor.CLASS_NAME, "SparkRunJob");
        this.perfLogger.PerfLogBegin(RemoteSparkJobMonitor.CLASS_NAME, "SparkSubmitToRunning");
        this.startTime = System.currentTimeMillis();
        while (true) {
            try {
                state = this.sparkJobStatus.getRemoteJobState();
                switch (1.$SwitchMap$org$apache$hive$spark$client$JobHandle$State[state.ordinal()]) {
                    case 1: 
                    case 2: {
                        timeCount = (System.currentTimeMillis() - this.startTime) / 1000L;
                        if (timeCount > this.monitorTimeoutInterval) {
                            this.console.printError("Job hasn't been submitted after " + timeCount + "s. Aborting it.\nPossible reasons include network issues, errors in remote driver or the cluster has no available resources, etc.\nPlease check YARN or Spark driver's logs for further information.");
                            this.console.printError("Status: " + (Object)state);
                            running = false;
                            done = true;
                            rc = 2;
                        }
                        if (!RemoteSparkJobMonitor.LOG.isDebugEnabled()) break;
                        this.console.printInfo("state = " + (Object)state);
                        break;
                    }
                    case 3: {
                        sparkJobState = this.sparkJobStatus.getState();
                        if (sparkJobState == JobExecutionStatus.RUNNING) {
                            progressMap = this.sparkJobStatus.getSparkStageProgress();
                            if (!running) {
                                this.perfLogger.PerfLogEnd(RemoteSparkJobMonitor.CLASS_NAME, "SparkSubmitToRunning");
                                this.printAppInfo();
                                this.console.printInfo("\nQuery Hive on Spark job[" + this.sparkJobStatus.getJobId() + "] stages: " + Arrays.toString(this.sparkJobStatus.getStageIds()));
                                this.console.printInfo("\nStatus: Running (Hive on Spark job[" + this.sparkJobStatus.getJobId() + "])");
                                running = true;
                                format = "Job Progress Format\nCurrentTime StageId_StageAttemptId: SucceededTasksCount(+RunningTasksCount-FailedTasksCount)/TotalTasksCount";
                                if (!this.inPlaceUpdate) {
                                    this.console.printInfo(format);
                                } else {
                                    this.console.logInfo(format);
                                }
                            }
                            this.printStatus(progressMap, lastProgressMap);
                            lastProgressMap = progressMap;
                            break;
                        }
                        if (sparkJobState != null) break;
                        Preconditions.checkState(this.sparkJobStatus.isRemoteActive(), "Remote context becomes inactive.");
                        break;
                    }
                    case 4: {
                        progressMap = this.sparkJobStatus.getSparkStageProgress();
                        this.printStatus(progressMap, lastProgressMap);
                        lastProgressMap = progressMap;
                        duration = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                        this.console.printInfo("Status: Finished successfully in " + String.format("%.2f seconds", new Object[]{duration}));
                        running = false;
                        done = true;
                        break;
                    }
                    case 5: {
                        detail = this.sparkJobStatus.getError().getMessage();
                        errBuilder = new StringBuilder();
                        errBuilder.append("Job failed with ");
                        if (detail == null) {
                            errBuilder.append("UNKNOWN reason");
                        } else {
                            CAUSE_CAPTION = "Caused by: ";
                            index = detail.lastIndexOf("Caused by: ");
                            if (index != -1) {
                                rootCause = detail.substring(index + "Caused by: ".length());
                                if ((index = rootCause.indexOf(System.getProperty("line.separator"))) != -1) {
                                    errBuilder.append(rootCause.substring(0, index));
                                } else {
                                    errBuilder.append(rootCause);
                                }
                            } else {
                                errBuilder.append(detail);
                            }
                            detail = System.getProperty("line.separator") + detail;
                        }
                        this.console.printError(errBuilder.toString(), detail);
                        running = false;
                        done = true;
                        rc = 3;
                    }
                }
                if (done) continue;
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                msg = " with exception '" + Utilities.getNameMessage(e) + "'";
                msg = "Failed to monitor Job[" + this.sparkJobStatus.getJobId() + "]" + msg;
                RemoteSparkJobMonitor.LOG.error(msg, (Throwable)e);
                this.console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
                rc = 1;
                done = true;
                this.sparkJobStatus.setError(e);
            }
            finally {
                if (done) ** break;
                continue;
            }
            break;
        }
        this.perfLogger.PerfLogEnd(RemoteSparkJobMonitor.CLASS_NAME, "SparkRunJob");
        return rc;
    }

    private void printAppInfo() {
        String appID;
        String sparkMaster = this.hiveConf.get("spark.master");
        if (sparkMaster != null && sparkMaster.startsWith("yarn") && (appID = this.sparkJobStatus.getAppID()) != null) {
            this.console.printInfo("Running with YARN Application = " + appID);
            this.console.printInfo("Kill Command = " + HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.YARNBIN) + " application -kill " + appID);
        }
    }
}

