/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseStatsUtils;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;

public class HBaseStatsPublisher
implements StatsPublisher {
    private HTable htable;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());

    public boolean connect(Configuration hiveconf) {
        try {
            this.htable = new HTable(HBaseConfiguration.create((Configuration)hiveconf), "PARTITION_STAT_TBL");
            this.htable.setAutoFlush(false);
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during HBase connection. " + e));
            return false;
        }
        return true;
    }

    public boolean publishStat(String rowID, Map<String, String> stats) {
        if (stats.isEmpty()) {
            return true;
        }
        if (!HBaseStatsUtils.isValidStatisticSet(stats.keySet())) {
            this.LOG.warn((Object)("Warning. Invalid statistic: " + stats.keySet().toString() + ", supported stats: " + HBaseStatsUtils.getSupportedStatistics()));
            return false;
        }
        try {
            Get get = new Get(Bytes.toBytes((String)rowID));
            Result result = this.htable.get(get);
            byte[] family = HBaseStatsUtils.getFamilyName();
            byte[] column = HBaseStatsUtils.getColumnName(HBaseStatsUtils.getBasicStat());
            long val = Long.parseLong(HBaseStatsUtils.getStatFromMap(HBaseStatsUtils.getBasicStat(), stats));
            long oldVal = 0L;
            if (!result.isEmpty()) {
                oldVal = Long.parseLong(Bytes.toString((byte[])result.getValue(family, column)));
            }
            if (oldVal >= val) {
                return true;
            }
            Put row = new Put(Bytes.toBytes((String)rowID));
            for (String statType : HBaseStatsUtils.getSupportedStatistics()) {
                column = HBaseStatsUtils.getColumnName(statType);
                row.add(family, column, Bytes.toBytes((String)HBaseStatsUtils.getStatFromMap(statType, stats)));
            }
            this.htable.put(row);
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during publishing statistics. " + e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection() {
        try {
            this.htable.flushCommits();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Cannot commit changes in stats publishing.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.htable != null) {
                IOUtils.closeQuietly((Closeable)this.htable);
                this.htable = null;
            }
        }
    }

    public boolean init(Configuration hiveconf) {
        try {
            HBaseAdmin hbase = new HBaseAdmin(HBaseConfiguration.create((Configuration)hiveconf));
            if (!hbase.tableExists("PARTITION_STAT_TBL")) {
                HTableDescriptor table = new HTableDescriptor("PARTITION_STAT_TBL");
                HColumnDescriptor family = new HColumnDescriptor(HBaseStatsUtils.getFamilyName());
                table.addFamily(family);
                hbase.createTable(table);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during HBase initialization. " + e));
            return false;
        }
        return true;
    }
}

