/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class AuthChallenge {
    private final ChallengeType challengeType;
    private final String scheme;
    private final String value;
    private final List<NameValuePair> params;

    public AuthChallenge(ChallengeType challengeType, String scheme, String value, List<? extends NameValuePair> params) {
        this.challengeType = (ChallengeType)((Object)Args.notNull((Object)((Object)challengeType), (String)"Challenge type"));
        this.scheme = (String)Args.notNull((Object)scheme, (String)"Auth scheme");
        this.value = value;
        this.params = params != null ? Collections.unmodifiableList(new ArrayList<NameValuePair>(params)) : null;
    }

    public AuthChallenge(ChallengeType challengeType, String scheme, NameValuePair ... params) {
        this(challengeType, scheme, null, Arrays.asList(params));
    }

    public ChallengeType getChallengeType() {
        return this.challengeType;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getValue() {
        return this.value;
    }

    public List<NameValuePair> getParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.scheme).append(" ");
        if (this.value != null) {
            buffer.append(this.value);
        } else if (this.params != null) {
            buffer.append(this.params);
        }
        return buffer.toString();
    }
}

