/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;

@ConfigClassProperty(name="DynamoDB based Locks Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configs that control DynamoDB based locking mechanisms required for concurrency control  between writers to a Hudi table. Concurrency between Hudi's own table services  are auto managed internally.")
public class DynamoDbBasedLockConfig
extends HoodieConfig {
    public static final String DYNAMODB_BASED_LOCK_PROPERTY_PREFIX = "hoodie.write.lock.dynamodb.";
    public static final ConfigProperty<String> DYNAMODB_LOCK_TABLE_NAME = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.table").noDefaultValue().sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, the name of the DynamoDB table acting as lock table");
    public static final ConfigProperty<String> DYNAMODB_LOCK_PARTITION_KEY = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.partition_key").noDefaultValue().sinceVersion("0.10.0").withInferFunction(cfg -> {
        if (cfg.contains(HoodieTableConfig.NAME)) {
            return Option.of((Object)cfg.getString(HoodieTableConfig.NAME));
        }
        return Option.empty();
    }).withDocumentation("For DynamoDB based lock provider, the partition key for the DynamoDB lock table. Each Hudi dataset should has it's unique key so concurrent writers could refer to the same partition key. By default we use the Hudi table name specified to be the partition key");
    public static final ConfigProperty<String> DYNAMODB_LOCK_REGION = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.region").defaultValue((Object)"us-east-1").sinceVersion("0.10.0").withInferFunction(cfg -> {
        String regionFromEnv = System.getenv("AWS_REGION");
        if (regionFromEnv != null) {
            return Option.of((Object)RegionUtils.getRegion((String)regionFromEnv).getName());
        }
        return Option.empty();
    }).withDocumentation("For DynamoDB based lock provider, the region used in endpoint for Amazon DynamoDB service. Would try to first get it from AWS_REGION environment variable. If not find, by default use us-east-1");
    public static final ConfigProperty<String> DYNAMODB_LOCK_BILLING_MODE = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.billing_mode").defaultValue((Object)BillingMode.PAY_PER_REQUEST.name()).sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, by default it is PAY_PER_REQUEST mode");
    public static final ConfigProperty<String> DYNAMODB_LOCK_READ_CAPACITY = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.read_capacity").defaultValue((Object)"20").sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, read capacity units when using PROVISIONED billing mode");
    public static final ConfigProperty<String> DYNAMODB_LOCK_WRITE_CAPACITY = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.write_capacity").defaultValue((Object)"10").sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, write capacity units when using PROVISIONED billing mode");
    public static final ConfigProperty<String> DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.table_creation_timeout").defaultValue((Object)String.valueOf(600000)).sinceVersion("0.10.0").withDocumentation("For DynamoDB based lock provider, the maximum number of milliseconds to wait for creating DynamoDB table");
    public static final ConfigProperty<String> DYNAMODB_ENDPOINT_URL = ConfigProperty.key((String)"hoodie.write.lock.dynamodb.endpoint_url").noDefaultValue().sinceVersion("0.10.1").withDocumentation("For DynamoDB based lock provider, the url endpoint used for Amazon DynamoDB service. Useful for development with a local dynamodb instance.");
}

