/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieMetaserverBasedTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metaserver.client.HoodieMetaserverClient;
import org.apache.hudi.metaserver.client.HoodieMetaserverClientProxy;
import org.apache.hudi.metaserver.thrift.NoSuchObjectException;
import org.apache.hudi.metaserver.thrift.Table;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTableMetaserverClient
extends HoodieTableMetaClient {
    private static final Logger LOG = LogManager.getLogger(HoodieTableMetaserverClient.class);
    private final String databaseName;
    private final String tableName;
    private final Table table;
    private final transient HoodieMetaserverClient metaserverClient;

    public HoodieTableMetaserverClient(Configuration conf, String basePath, ConsistencyGuardConfig consistencyGuardConfig, String mergerStrategy, FileSystemRetryConfig fileSystemRetryConfig, String databaseName, String tableName, HoodieMetaserverConfig config) {
        super(conf, basePath, false, consistencyGuardConfig, Option.of(TimelineLayoutVersion.CURR_LAYOUT_VERSION), config.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME), mergerStrategy, fileSystemRetryConfig);
        ValidationUtils.checkArgument(StringUtils.nonEmpty(databaseName), "database name is required.");
        ValidationUtils.checkArgument(StringUtils.nonEmpty(tableName), "table name is required.");
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.metaserverConfig = config;
        this.metaserverClient = HoodieMetaserverClientProxy.getProxy(config);
        this.table = this.initOrGetTable(databaseName, tableName, config);
        this.tableConfig = new HoodieTableConfig();
        this.tableConfig.setTableVersion(HoodieTableVersion.current());
        this.tableConfig.setAll(config.getProps());
    }

    private Table initOrGetTable(String db, String tb, HoodieMetaserverConfig config) {
        Table table;
        try {
            table = this.metaserverClient.getTable(this.databaseName, this.tableName);
        }
        catch (HoodieException e) {
            if (e.getCause() instanceof NoSuchObjectException) {
                String user = "";
                try {
                    user = UserGroupInformation.getCurrentUser().getShortUserName();
                }
                catch (IOException ioException) {
                    LOG.info((Object)"Failed to get the user", (Throwable)ioException);
                }
                LOG.info((Object)String.format("Table %s.%s doesn't exist, will create it.", db, tb));
                table = new Table();
                table.setDatabaseName(db);
                table.setTableName(tb);
                table.setLocation(config.getString(HoodieWriteConfig.BASE_PATH));
                table.setOwner(user);
                table.setTableType(config.getString(HoodieTableConfig.TYPE.key()));
                this.metaserverClient.createTable(table);
                table = this.metaserverClient.getTable(this.databaseName, this.tableName);
            }
            throw e;
        }
        return table;
    }

    @Override
    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.table.getTableType());
    }

    @Override
    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HoodieMetaserverBasedTimeline((HoodieTableMetaClient)this, this.metaserverConfig);
        }
        return this.activeTimeline;
    }

    @Override
    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = new HoodieMetaserverBasedTimeline((HoodieTableMetaClient)this, this.metaserverConfig);
        return this.activeTimeline;
    }

    @Override
    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) {
        throw new HoodieException("Unsupport operation");
    }

    @Override
    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Path timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) {
        throw new HoodieException("Unsupport operation");
    }

    public void setBasePath(String basePath) {
        throw new HoodieException("Unsupport operation");
    }

    public void setMetaPath(String metaPath) {
        throw new HoodieException("Unsupport operation");
    }

    public void setActiveTimeline(HoodieActiveTimeline activeTimeline) {
        throw new HoodieException("Unsupport operation");
    }

    public HoodieMetaserverClient getMetaserverClient() {
        return this.metaserverClient;
    }
}

