/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.Locale;
import org.apache.hudi.hive.expression.AttributeReferenceExpression;
import org.apache.hudi.hive.expression.BinaryOperator;
import org.apache.hudi.hive.expression.Expression;
import org.apache.hudi.hive.expression.ExpressionVisitor;
import org.apache.hudi.hive.expression.Literal;

public class FilterGenVisitor
implements ExpressionVisitor<String> {
    private String makeBinaryOperatorString(String left, Expression.Operator operator, String right) {
        return String.format("%s %s %s", left, operator.sqlOperator, right);
    }

    private String quoteStringLiteral(String value) {
        if (!value.contains("\"")) {
            return "\"" + value + "\"";
        }
        if (!value.contains("'")) {
            return "'" + value + "'";
        }
        throw new UnsupportedOperationException("Cannot pushdown filters if \" and ' both exist");
    }

    private String visitAnd(Expression left, Expression right) {
        String leftResult = left.accept(this);
        String rightResult = right.accept(this);
        if (leftResult.isEmpty()) {
            if (rightResult.isEmpty()) {
                return "";
            }
            return rightResult;
        }
        if (rightResult.isEmpty()) {
            return leftResult;
        }
        return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.AND, rightResult) + ")";
    }

    private String visitOr(Expression left, Expression right) {
        String leftResult = left.accept(this);
        String rightResult = right.accept(this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return "(" + this.makeBinaryOperatorString(leftResult, Expression.Operator.OR, rightResult) + ")";
        }
        return "";
    }

    private String visitBinaryComparator(Expression left, Expression.Operator operator, Expression right) {
        String leftResult = left.accept(this);
        String rightResult = right.accept(this);
        if (!leftResult.isEmpty() && !rightResult.isEmpty()) {
            return this.makeBinaryOperatorString(leftResult, operator, rightResult);
        }
        return "";
    }

    @Override
    public String visitBinaryOperator(BinaryOperator expr) {
        switch (expr.getOperator()) {
            case AND: {
                return this.visitAnd(expr.getLeft(), expr.getRight());
            }
            case OR: {
                return this.visitOr(expr.getLeft(), expr.getRight());
            }
            case EQ: 
            case GT: 
            case LT: 
            case GT_EQ: 
            case LT_EQ: {
                return this.visitBinaryComparator(expr.getLeft(), expr.getOperator(), expr.getRight());
            }
        }
        return "";
    }

    @Override
    public String visitLiteral(Literal literalExpr) {
        switch (literalExpr.getType().toLowerCase(Locale.ROOT)) {
            case "string": {
                return this.quoteStringLiteral(literalExpr.getValue());
            }
            case "int": 
            case "bigint": 
            case "date": {
                return literalExpr.getValue();
            }
        }
        return "";
    }

    @Override
    public String visitAttribute(AttributeReferenceExpression attribute) {
        return attribute.getName();
    }
}

