/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CompleteScanResultCache
implements ScanResultCache {
    private int numberOfCompleteRows;
    private final List<Result> partialResults = new ArrayList<Result>();

    CompleteScanResultCache() {
    }

    private Result combine() throws IOException {
        Result result = Result.createCompleteResult(this.partialResults);
        this.partialResults.clear();
        return result;
    }

    private Result[] prependCombined(Result[] results, int length) throws IOException {
        int start2;
        if (length == 0) {
            return new Result[]{this.combine()};
        }
        if (Bytes.equals(this.partialResults.get(0).getRow(), results[0].getRow())) {
            this.partialResults.add(results[0]);
            start2 = 1;
            --length;
        } else {
            start2 = 0;
        }
        Result[] prependResults = new Result[length + 1];
        prependResults[0] = this.combine();
        System.arraycopy(results, start2, prependResults, 1, length);
        return prependResults;
    }

    private Result[] updateNumberOfCompleteResultsAndReturn(Result ... results) {
        this.numberOfCompleteRows += results.length;
        return results;
    }

    @Override
    public Result[] addAndGet(Result[] results, boolean isHeartbeatMessage) throws IOException {
        if (results.length == 0) {
            if (!this.partialResults.isEmpty() && !isHeartbeatMessage) {
                return this.updateNumberOfCompleteResultsAndReturn(this.combine());
            }
            return EMPTY_RESULT_ARRAY;
        }
        Result last = results[results.length - 1];
        if (last.mayHaveMoreCellsInRow()) {
            if (this.partialResults.isEmpty()) {
                this.partialResults.add(last);
                return this.updateNumberOfCompleteResultsAndReturn(Arrays.copyOf(results, results.length - 1));
            }
            if (results.length == 1) {
                if (Bytes.equals(this.partialResults.get(0).getRow(), last.getRow())) {
                    this.partialResults.add(last);
                    return EMPTY_RESULT_ARRAY;
                }
                Result completeResult = this.combine();
                this.partialResults.add(last);
                return this.updateNumberOfCompleteResultsAndReturn(completeResult);
            }
            Result[] resultsToReturn = this.prependCombined(results, results.length - 1);
            this.partialResults.add(last);
            return this.updateNumberOfCompleteResultsAndReturn(resultsToReturn);
        }
        if (!this.partialResults.isEmpty()) {
            return this.updateNumberOfCompleteResultsAndReturn(this.prependCombined(results, results.length));
        }
        return this.updateNumberOfCompleteResultsAndReturn(results);
    }

    @Override
    public void clear() {
        this.partialResults.clear();
    }

    @Override
    public int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }
}

