/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Arrays;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class KeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(KeyPrefixRegionSplitPolicy.class);
    @Deprecated
    public static final String PREFIX_LENGTH_KEY_DEPRECATED = "prefix_split_key_policy.prefix_length";
    public static final String PREFIX_LENGTH_KEY = "KeyPrefixRegionSplitPolicy.prefix_length";
    private int prefixLength = 0;

    @Override
    public String toString() {
        return "KeyPrefixRegionSplitPolicy{prefixLength=" + this.prefixLength + ", " + super.toString() + '}';
    }

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        this.prefixLength = 0;
        String prefixLengthString = region.getTableDescriptor().getValue(PREFIX_LENGTH_KEY);
        if (prefixLengthString == null && (prefixLengthString = region.getTableDescriptor().getValue(PREFIX_LENGTH_KEY_DEPRECATED)) == null) {
            LOG.error("KeyPrefixRegionSplitPolicy.prefix_length not specified for table " + region.getTableDescriptor().getTableName() + ". Using default RegionSplitPolicy");
            return;
        }
        try {
            this.prefixLength = Integer.parseInt(prefixLengthString);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Number format exception when parsing KeyPrefixRegionSplitPolicy.prefix_length for table " + region.getTableDescriptor().getTableName() + ":" + prefixLengthString + ". " + nfe);
            return;
        }
        if (this.prefixLength <= 0) {
            LOG.error("Invalid value for KeyPrefixRegionSplitPolicy.prefix_length for table " + region.getTableDescriptor().getTableName() + ":" + prefixLengthString + ". Using default RegionSplitPolicy");
        }
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (this.prefixLength > 0 && splitPoint != null && splitPoint.length > 0) {
            return Arrays.copyOf(splitPoint, Math.min(this.prefixLength, splitPoint.length));
        }
        return splitPoint;
    }
}

