/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public class OperationStatus {
    public static final OperationStatus SUCCESS = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    public static final OperationStatus FAILURE = new OperationStatus(HConstants.OperationStatusCode.FAILURE);
    public static final OperationStatus NOT_RUN = new OperationStatus(HConstants.OperationStatusCode.NOT_RUN);
    private final HConstants.OperationStatusCode code;
    private final Result result;
    private final String exceptionMsg;

    public OperationStatus(HConstants.OperationStatusCode code) {
        this(code, null, "");
    }

    public OperationStatus(HConstants.OperationStatusCode code, Result result) {
        this(code, result, "");
    }

    public OperationStatus(HConstants.OperationStatusCode code, String exceptionMsg) {
        this(code, null, exceptionMsg);
    }

    public OperationStatus(HConstants.OperationStatusCode code, Exception e) {
        this(code, null, e == null ? "" : e.getClass().getName() + ": " + e.getMessage());
    }

    private OperationStatus(HConstants.OperationStatusCode code, Result result, String exceptionMsg) {
        this.code = code;
        this.result = result;
        this.exceptionMsg = exceptionMsg;
    }

    public HConstants.OperationStatusCode getOperationStatusCode() {
        return this.code;
    }

    public Result getResult() {
        return this.result;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }
}

