/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSinkSource;
import org.apache.hudi.org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hudi.org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsReplicationSinkSourceImpl
implements MetricsReplicationSinkSource {
    private final MutableHistogram ageHist;
    private final MutableFastCounter batchesCounter;
    private final MutableFastCounter opsCounter;
    private final MutableFastCounter hfilesCounter;

    public MetricsReplicationSinkSourceImpl(MetricsReplicationSourceImpl rms) {
        this.ageHist = rms.getMetricsRegistry().getHistogram("sink.ageOfLastAppliedOp");
        this.batchesCounter = rms.getMetricsRegistry().getCounter("sink.appliedBatches", 0L);
        this.opsCounter = rms.getMetricsRegistry().getCounter("sink.appliedOps", 0L);
        this.hfilesCounter = rms.getMetricsRegistry().getCounter("sink.appliedHFiles", 0L);
    }

    @Override
    public void setLastAppliedOpAge(long age) {
        this.ageHist.add(age);
    }

    @Override
    public void incrAppliedBatches(long batches) {
        this.batchesCounter.incr(batches);
    }

    @Override
    public void incrAppliedOps(long batchsize) {
        this.opsCounter.incr(batchsize);
    }

    @Override
    public long getLastAppliedOpAge() {
        return this.ageHist.getMax();
    }

    @Override
    public void incrAppliedHFiles(long hfiles) {
        this.hfilesCounter.incr(hfiles);
    }

    @Override
    public long getSinkAppliedOps() {
        return this.opsCounter.value();
    }
}

