/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.source.stats.ColumnStatsIndices;
import org.apache.hudi.source.stats.ExpressionEvaluator;
import org.apache.hudi.util.DataTypeUtils;
import org.apache.hudi.util.ExpressionUtils;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndex {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndex.class);
    private final Path path;
    private final RowType rowType;
    private final HoodieMetadataConfig metadataConfig;
    private final boolean dataSkippingEnabled;
    private List<String> partitionPaths;
    private List<ResolvedExpression> filters;
    private final boolean tableExists;

    private FileIndex(Path path, Configuration conf, RowType rowType) {
        this.path = path;
        this.rowType = rowType;
        this.metadataConfig = FileIndex.metadataConfig(conf);
        this.dataSkippingEnabled = conf.getBoolean(FlinkOptions.READ_DATA_SKIPPING_ENABLED);
        this.tableExists = StreamerUtil.tableExists(path.toString(), HadoopConfigurations.getHadoopConf(conf));
    }

    public static FileIndex instance(Path path, Configuration conf, RowType rowType) {
        return new FileIndex(path, conf, rowType);
    }

    public List<Map<String, String>> getPartitions(List<String> partitionKeys, String defaultParName, boolean hivePartition) {
        if (partitionKeys.size() == 0) {
            return Collections.emptyList();
        }
        List<String> partitionPaths = this.getOrBuildPartitionPaths();
        if (partitionPaths.size() == 1 && partitionPaths.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partitionPath : partitionPaths) {
            String[] paths = partitionPath.split("/");
            LinkedHashMap<String, String> partitionMapping = new LinkedHashMap<String, String>();
            if (hivePartition) {
                Arrays.stream(paths).forEach(p -> {
                    String[] kv = p.split("=");
                    if (kv.length == 2) {
                        partitionMapping.put(kv[0], defaultParName.equals(kv[1]) ? null : kv[1]);
                    }
                });
            } else {
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partitionMapping.put(partitionKeys.get(i), defaultParName.equals(paths[i]) ? null : paths[i]);
                }
            }
            partitions.add(partitionMapping);
        }
        return partitions;
    }

    public FileStatus[] getFilesInPartitions() {
        if (!this.tableExists) {
            return new FileStatus[0];
        }
        String[] partitions = (String[])this.getOrBuildPartitionPaths().stream().map(p -> FileIndex.fullPartitionPath(this.path, p)).toArray(String[]::new);
        FileStatus[] allFileStatus = (FileStatus[])FSUtils.getFilesInPartitions(HoodieFlinkEngineContext.DEFAULT, this.metadataConfig, this.path.toString(), partitions).values().stream().flatMap(Arrays::stream).toArray(FileStatus[]::new);
        Set<String> candidateFiles = this.candidateFilesInMetadataTable(allFileStatus);
        if (candidateFiles == null) {
            return allFileStatus;
        }
        return (FileStatus[])((Stream)Arrays.stream(allFileStatus).parallel()).filter(fileStatus -> candidateFiles.contains(fileStatus.getPath().getName())).toArray(FileStatus[]::new);
    }

    private static String fullPartitionPath(Path basePath, String partitionPath) {
        if (partitionPath.isEmpty()) {
            return basePath.toString();
        }
        return new Path(basePath, partitionPath).toString();
    }

    @VisibleForTesting
    public void reset() {
        this.partitionPaths = null;
    }

    public void setPartitionPaths(@Nullable Set<String> partitionPaths) {
        if (partitionPaths != null) {
            this.partitionPaths = new ArrayList<String>(partitionPaths);
        }
    }

    public void setFilters(List<ResolvedExpression> filters) {
        if (filters.size() > 0) {
            this.filters = new ArrayList<ResolvedExpression>(filters);
        }
    }

    @Nullable
    private Set<String> candidateFilesInMetadataTable(FileStatus[] allFileStatus) {
        if (!this.metadataConfig.enabled() || !this.dataSkippingEnabled) {
            this.validateConfig();
            return null;
        }
        if (this.filters == null || this.filters.size() == 0) {
            return null;
        }
        String[] referencedCols = ExpressionUtils.referencedColumns(this.filters);
        if (referencedCols.length == 0) {
            return null;
        }
        try {
            List<RowData> colStats = ColumnStatsIndices.readColumnStatsIndex(this.path.toString(), this.metadataConfig, referencedCols);
            Pair<List<RowData>, String[]> colStatsTable = ColumnStatsIndices.transposeColumnStatsIndex(colStats, referencedCols, this.rowType);
            List<RowData> transposedColStats = colStatsTable.getLeft();
            String[] queryCols = colStatsTable.getRight();
            if (queryCols.length == 0) {
                return null;
            }
            RowType.RowField[] queryFields = DataTypeUtils.projectRowFields(this.rowType, queryCols);
            Set allIndexedFileNames = ((Stream)transposedColStats.stream().parallel()).map(row -> row.getString(0).toString()).collect(Collectors.toSet());
            Set<String> candidateFileNames = ((Stream)transposedColStats.stream().parallel()).filter(row -> ExpressionEvaluator.filterExprs(this.filters, row, queryFields)).map(row -> row.getString(0).toString()).collect(Collectors.toSet());
            Set nonIndexedFileNames = Arrays.stream(allFileStatus).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toSet());
            nonIndexedFileNames.removeAll(allIndexedFileNames);
            candidateFileNames.addAll(nonIndexedFileNames);
            return candidateFileNames;
        }
        catch (Throwable throwable) {
            LOG.warn("Read column stats for data skipping error", throwable);
            return null;
        }
    }

    private void validateConfig() {
        if (this.dataSkippingEnabled && !this.metadataConfig.enabled()) {
            LOG.warn("Data skipping requires Metadata Table to be enabled! isMetadataTableEnabled = {}", (Object)this.metadataConfig.enabled());
        }
    }

    public List<String> getOrBuildPartitionPaths() {
        if (this.partitionPaths != null) {
            return this.partitionPaths;
        }
        this.partitionPaths = this.tableExists ? FSUtils.getAllPartitionPaths(HoodieFlinkEngineContext.DEFAULT, this.metadataConfig, this.path.toString()) : Collections.emptyList();
        return this.partitionPaths;
    }

    private static HoodieMetadataConfig metadataConfig(Configuration conf) {
        Properties properties = new Properties();
        properties.put(HoodieMetadataConfig.ENABLE.key(), (Object)conf.getBoolean(FlinkOptions.METADATA_ENABLED));
        return HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
    }

    @VisibleForTesting
    public List<ResolvedExpression> getFilters() {
        return this.filters;
    }
}

