/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;

public class HoodieAvroReadSupport<T>
extends AvroReadSupport<T> {
    public HoodieAvroReadSupport(GenericData model) {
        super(model);
    }

    public HoodieAvroReadSupport() {
    }

    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        boolean legacyMode = this.checkLegacyMode(fileSchema.getFields());
        if (!legacyMode && configuration.get("parquet.avro.write-old-list-structure") == null) {
            configuration.set("parquet.avro.write-old-list-structure", "false", "support reading avro from non-legacy map/list in parquet file");
        }
        ReadSupport.ReadContext readContext = super.init(configuration, keyValueMetaData, fileSchema);
        MessageType requestedSchema = readContext.getRequestedSchema();
        if (!legacyMode) {
            requestedSchema = new MessageType(requestedSchema.getName(), this.convertLegacyMap(requestedSchema.getFields()));
        }
        return new ReadSupport.ReadContext(requestedSchema, readContext.getReadSupportMetadata());
    }

    private boolean checkLegacyMode(List<Type> parquetFields) {
        for (Type type : parquetFields) {
            if (type.isPrimitive()) continue;
            GroupType groupType = type.asGroupType();
            OriginalType originalType = groupType.getOriginalType();
            if (originalType == OriginalType.MAP && groupType.getFields().get(0).getOriginalType() != OriginalType.MAP_KEY_VALUE) {
                return false;
            }
            if (originalType == OriginalType.LIST && !groupType.getType(0).getName().equals("array")) {
                return false;
            }
            if (this.checkLegacyMode(groupType.getFields())) continue;
            return false;
        }
        return true;
    }

    private List<Type> convertLegacyMap(List<Type> oldTypes) {
        ArrayList<Type> newTypes = new ArrayList<Type>(oldTypes.size());
        for (Type type : oldTypes) {
            if (!type.isPrimitive()) {
                GroupType parent = type.asGroupType();
                List<Type> types = this.convertLegacyMap(parent.getFields());
                if (type.getOriginalType() == OriginalType.MAP_KEY_VALUE) {
                    newTypes.add(new GroupType(parent.getRepetition(), "key_value", types));
                    continue;
                }
                newTypes.add(new GroupType(parent.getRepetition(), parent.getName(), parent.getOriginalType(), types));
                continue;
            }
            newTypes.add(type);
        }
        return newTypes;
    }
}

