/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.links;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.wicket.markup.html.link.AbstractLink;

public class LinkAndLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AbstractLink link;
    private final String label;
    private final String disabledReasonIfAny;
    private final String descriptionIfAny;
    private final boolean blobOrClob;
    private final boolean prototype;
    private final String actionIdentifier;
    private final String cssClass;
    private final String cssClassFa;
    private final CssClassFaPosition cssClassFaPosition;
    private final ActionLayout.Position position;

    public static List<LinkAndLabel> positioned(List<LinkAndLabel> entityActionLinks, ActionLayout.Position position) {
        return Lists.newArrayList((Iterable)Iterables.filter(entityActionLinks, Predicates.positioned(position)));
    }

    public LinkAndLabel(AbstractLink link, String label, String disabledReasonIfAny, String descriptionIfAny, boolean blobOrClob, boolean prototype, String identifier, String cssClass, String cssClassFa, CssClassFaPosition cssClassFaPosition, ActionLayout.Position position) {
        this.link = link;
        this.label = label;
        this.disabledReasonIfAny = disabledReasonIfAny;
        this.descriptionIfAny = descriptionIfAny;
        this.blobOrClob = blobOrClob;
        this.prototype = prototype;
        this.actionIdentifier = identifier;
        this.cssClass = cssClass;
        this.cssClassFa = cssClassFa;
        this.cssClassFaPosition = cssClassFaPosition;
        this.position = position;
    }

    public AbstractLink getLink() {
        return this.link;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDisabledReasonIfAny() {
        return this.disabledReasonIfAny;
    }

    public String getDescriptionIfAny() {
        return this.descriptionIfAny;
    }

    public boolean isBlobOrClob() {
        return this.blobOrClob;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public String getActionIdentifier() {
        return this.actionIdentifier;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getCssClassFa() {
        return this.cssClassFa;
    }

    public CssClassFaPosition getCssClassFaPosition() {
        return this.cssClassFaPosition;
    }

    public ActionLayout.Position getPosition() {
        return this.position;
    }

    public static class Predicates {
        public static Predicate<LinkAndLabel> positioned(final ActionLayout.Position position) {
            return new Predicate<LinkAndLabel>(){

                public boolean apply(LinkAndLabel input) {
                    return input.getPosition() == position;
                }
            };
        }
    }
}

