/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecifications;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.services.memento.MementoServiceDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EntityModel
extends BookmarkableModel<ObjectAdapter> {
    private static final long serialVersionUID = 1L;
    private ObjectAdapterMemento adapterMemento;
    private Mode mode = Mode.VIEW;
    private RenderingHint renderingHint = RenderingHint.REGULAR;
    private final Map<PropertyMemento, ScalarModel> propertyScalarModels = Maps.newHashMap();
    private ObjectSpecifications.MemberGroupLayoutHint memberGroupLayoutHint;
    private boolean entityDetailsVisible;
    private ConcurrencyException concurrencyException;
    private final HintPageParameterSerializer hintPageParameterSerializer = new HintPageParameterSerializerDirect();
    private final PendingModel pendingModel;
    private ObjectAdapterMemento contextAdapterIfAny;

    public static PageParameters createPageParameters(ObjectAdapter adapter) {
        PageParameters pageParameters = PageParametersUtils.newPageParameters();
        Boolean persistent = adapter != null && adapter.representsPersistent();
        if (persistent.booleanValue()) {
            String oidStr = adapter.getOid().enStringNoVersion(EntityModel.getOidMarshaller());
            PageParameterNames.OBJECT_OID.addStringTo(pageParameters, oidStr);
        }
        return pageParameters;
    }

    public EntityModel() {
        this.pendingModel = new PendingModel(this);
    }

    public EntityModel(PageParameters pageParameters) {
        this(ObjectAdapterMemento.createPersistent(EntityModel.rootOidFrom(pageParameters)));
        this.hintPageParameterSerializer.pageParametersToHints(pageParameters, this.getHints());
    }

    public EntityModel(ObjectAdapter adapter) {
        this(ObjectAdapterMemento.createOrNull(adapter));
        this.setObject(adapter);
    }

    public EntityModel(ObjectAdapterMemento adapterMemento) {
        this.adapterMemento = adapterMemento;
        this.pendingModel = new PendingModel(this);
    }

    public static String oidStr(PageParameters pageParameters) {
        return PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
    }

    private static RootOid rootOidFrom(PageParameters pageParameters) {
        return (RootOid)EntityModel.getOidMarshaller().unmarshal(EntityModel.oidStr(pageParameters), RootOid.class);
    }

    @Override
    public PageParameters getPageParameters() {
        PageParameters pageParameters = EntityModel.createPageParameters((ObjectAdapter)this.getObject());
        this.hintPageParameterSerializer.hintsToPageParameters(this.getHints(), pageParameters);
        return pageParameters;
    }

    @Deprecated
    public PageParameters asPageParameters() {
        return this.getPageParameters();
    }

    public PageParameters getPageParametersWithoutUiHints() {
        return EntityModel.createPageParameters((ObjectAdapter)this.getObject());
    }

    @Override
    public String getTitle() {
        return ((ObjectAdapter)this.getObject()).titleString(null);
    }

    @Override
    public boolean hasAsRootPolicy() {
        return this.hasBookmarkPolicy(BookmarkPolicy.AS_ROOT);
    }

    public boolean hasAsChildPolicy() {
        return this.hasBookmarkPolicy(BookmarkPolicy.AS_CHILD);
    }

    private boolean hasBookmarkPolicy(BookmarkPolicy policy) {
        BookmarkPolicyFacet facet = this.getBookmarkPolicyFacetIfAny();
        return facet != null && facet.value() == policy;
    }

    private BookmarkPolicyFacet getBookmarkPolicyFacetIfAny() {
        ObjectSpecId specId = this.getObjectAdapterMemento().getObjectSpecId();
        ObjectSpecification objectSpec = this.getSpecificationLoader().lookupBySpecId(specId);
        return (BookmarkPolicyFacet)objectSpec.getFacet(BookmarkPolicyFacet.class);
    }

    public ObjectAdapterMemento getObjectAdapterMemento() {
        return this.adapterMemento;
    }

    public ObjectSpecification getTypeOfSpecification() {
        if (this.adapterMemento == null) {
            return null;
        }
        return this.getSpecificationFor(this.adapterMemento.getObjectSpecId());
    }

    private ObjectSpecification getSpecificationFor(ObjectSpecId objectSpecId) {
        return this.getSpecificationLoader().lookupBySpecId(objectSpecId);
    }

    public ObjectAdapter load(AdapterManager.ConcurrencyChecking concurrencyChecking) {
        if (this.adapterMemento == null) {
            return null;
        }
        ObjectAdapter objectAdapter = this.adapterMemento.getObjectAdapter(concurrencyChecking);
        return objectAdapter;
    }

    public ObjectAdapter load() {
        return this.load(AdapterManager.ConcurrencyChecking.CHECK);
    }

    public void setObject(ObjectAdapter adapter) {
        super.setObject((Object)adapter);
        this.adapterMemento = ObjectAdapterMemento.createOrNull(adapter);
    }

    public ScalarModel getPropertyModel(PropertyMemento pm) {
        ScalarModel scalarModel = this.propertyScalarModels.get(pm);
        if (scalarModel == null) {
            scalarModel = new ScalarModel(this.getObjectAdapterMemento(), pm);
            if (this.isViewMode()) {
                scalarModel.toViewMode();
            } else {
                scalarModel.toEditMode();
            }
            this.propertyScalarModels.put(pm, scalarModel);
        }
        return scalarModel;
    }

    public void resetPropertyModels() {
        this.adapterMemento.resetVersion();
        for (PropertyMemento pm : this.propertyScalarModels.keySet()) {
            ScalarModel scalarModel = this.propertyScalarModels.get(pm);
            ObjectAdapter associatedAdapter = pm.getProperty().get((ObjectAdapter)this.getObject());
            scalarModel.setObject(associatedAdapter);
        }
    }

    public RenderingHint getRenderingHint() {
        return this.renderingHint;
    }

    public void setRenderingHint(RenderingHint renderingHint) {
        this.renderingHint = renderingHint;
    }

    public ObjectAdapterMemento getContextAdapterIfAny() {
        return this.contextAdapterIfAny;
    }

    public void setContextAdapterIfAny(ObjectAdapterMemento contextAdapterIfAny) {
        this.contextAdapterIfAny = contextAdapterIfAny;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isViewMode() {
        return this.mode == Mode.VIEW;
    }

    public boolean isEditMode() {
        return this.mode == Mode.EDIT;
    }

    public EntityModel toEditMode() {
        this.setMode(Mode.EDIT);
        for (ScalarModel scalarModel : this.propertyScalarModels.values()) {
            scalarModel.toEditMode();
        }
        return this;
    }

    public EntityModel toViewMode() {
        this.setMode(Mode.VIEW);
        for (ScalarModel scalarModel : this.propertyScalarModels.values()) {
            scalarModel.toViewMode();
        }
        return this;
    }

    public boolean isEntityDetailsVisible() {
        return this.entityDetailsVisible;
    }

    public void toggleDetails() {
        this.entityDetailsVisible = !this.entityDetailsVisible;
    }

    public ObjectSpecifications.MemberGroupLayoutHint getMemberGroupLayoutHint() {
        return this.memberGroupLayoutHint;
    }

    public void setMemberGroupLayoutHint(ObjectSpecifications.MemberGroupLayoutHint memberGroupLayoutHint) {
        this.memberGroupLayoutHint = memberGroupLayoutHint;
    }

    public void setException(ConcurrencyException ex) {
        this.concurrencyException = ex;
    }

    public String getAndClearConcurrencyExceptionIfAny() {
        if (this.concurrencyException == null) {
            return null;
        }
        String message = this.concurrencyException.getMessage();
        this.concurrencyException = null;
        return message;
    }

    public String getReasonInvalidIfAny() {
        ObjectAdapter adapter = this.getObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
        Consent validity = adapter.getSpecification().isValid(adapter);
        return validity.isAllowed() ? null : validity.getReason();
    }

    public ObjectAdapter apply() {
        Object viewModel;
        boolean cloneable;
        ObjectAdapter adapter = this.getObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.CHECK);
        for (ScalarModel scalarModel : this.propertyScalarModels.values()) {
            OneToOneAssociation property = scalarModel.getPropertyMemento().getProperty();
            if (property.containsDoOpFacet(DisabledFacet.class)) continue;
            ObjectAdapter associate = (ObjectAdapter)scalarModel.getObject();
            property.set(adapter, associate);
        }
        ViewModelFacet recreatableObjectFacet = (ViewModelFacet)adapter.getSpecification().getFacet(ViewModelFacet.class);
        if (recreatableObjectFacet != null && (cloneable = recreatableObjectFacet.isCloneable(viewModel = adapter.getObject()))) {
            Object newViewModel = recreatableObjectFacet.clone(viewModel);
            adapter = this.getAdapterManager().adapterFor(newViewModel);
        }
        this.getObjectAdapterMemento().setAdapter(adapter);
        this.toViewMode();
        return adapter;
    }

    public ObjectAdapter getPendingElseCurrentAdapter() {
        return this.pendingModel.getPendingElseCurrentAdapter();
    }

    public ObjectAdapter getPendingAdapter() {
        return this.pendingModel.getPendingAdapter();
    }

    public ObjectAdapterMemento getPending() {
        return this.pendingModel.getPending();
    }

    public void setPending(ObjectAdapterMemento selectedAdapterMemento) {
        this.pendingModel.setPending(selectedAdapterMemento);
    }

    public void clearPending() {
        this.pendingModel.clearPending();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adapterMemento == null ? 0 : this.adapterMemento.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityModel other = (EntityModel)obj;
        return !(this.adapterMemento == null ? other.adapterMemento != null : !this.adapterMemento.equals(other.adapterMemento));
    }

    protected static OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    private static final class PendingModel
    extends Model<ObjectAdapterMemento> {
        private static final long serialVersionUID = 1L;
        private final EntityModel entityModel;
        private boolean hasPending;
        private ObjectAdapterMemento pending;

        public PendingModel(EntityModel entityModel) {
            this.entityModel = entityModel;
        }

        public ObjectAdapterMemento getObject() {
            if (this.hasPending) {
                return this.pending;
            }
            ObjectAdapter adapter = (ObjectAdapter)this.entityModel.getObject();
            return ObjectAdapterMemento.createOrNull(adapter);
        }

        public void setObject(ObjectAdapterMemento adapterMemento) {
            this.pending = adapterMemento;
            this.hasPending = true;
        }

        public void clearPending() {
            this.hasPending = false;
            this.pending = null;
        }

        private ObjectAdapter getPendingAdapter() {
            ObjectAdapterMemento memento = this.getObject();
            return memento != null ? memento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null;
        }

        public ObjectAdapter getPendingElseCurrentAdapter() {
            return this.hasPending ? this.getPendingAdapter() : (ObjectAdapter)this.entityModel.getObject();
        }

        public ObjectAdapterMemento getPending() {
            return this.pending;
        }

        public void setPending(ObjectAdapterMemento selectedAdapterMemento) {
            this.pending = selectedAdapterMemento;
            this.hasPending = true;
        }
    }

    static class HintPageParameterSerializerUsingViewModelSupport
    implements HintPageParameterSerializer,
    Serializable {
        private static final long serialVersionUID = 1L;

        HintPageParameterSerializerUsingViewModelSupport() {
        }

        @Override
        public void hintsToPageParameters(Map<String, String> hints, PageParameters pageParameters) {
            if (hints.isEmpty()) {
                return;
            }
            MementoServiceDefault vms = new MementoServiceDefault();
            MementoService.Memento memento = vms.create();
            Set<String> hintKeys = hints.keySet();
            for (String key : hintKeys) {
                String safeKey = key.replace(':', '_');
                Serializable value = (Serializable)((Object)hints.get(key));
                memento.set(safeKey, (Object)value);
            }
            String serializedHints = memento.asString();
            PageParameterNames.ANCHOR.addStringTo(pageParameters, serializedHints);
        }

        @Override
        public void pageParametersToHints(PageParameters pageParameters, Map<String, String> hints) {
            String hintsStr = PageParameterNames.ANCHOR.getStringFrom(pageParameters);
            if (hintsStr != null) {
                try {
                    MementoService.Memento memento = new MementoServiceDefault().parse(hintsStr);
                    Set keys = memento.keySet();
                    for (String safeKey : keys) {
                        String value = (String)memento.get(safeKey, String.class);
                        String key = safeKey.replace('_', ':');
                        hints.put(key, value);
                    }
                }
                catch (RuntimeException ex) {
                    System.err.println(ex);
                }
            }
        }
    }

    static class HintPageParameterSerializerDirect
    implements HintPageParameterSerializer,
    Serializable {
        private static final long serialVersionUID = 1L;

        HintPageParameterSerializerDirect() {
        }

        @Override
        public void hintsToPageParameters(Map<String, String> hints, PageParameters pageParameters) {
            Set<String> hintKeys = hints.keySet();
            for (String key : hintKeys) {
                String value = hints.get(key);
                pageParameters.add("hint-" + key, (Object)value);
            }
        }

        @Override
        public void pageParametersToHints(PageParameters pageParameters, Map<String, String> hints) {
            Set namedKeys = pageParameters.getNamedKeys();
            for (String namedKey : namedKeys) {
                if (!namedKey.startsWith("hint-")) continue;
                String value = pageParameters.get(namedKey).toString(null);
                String key = namedKey.substring(5);
                hints.put(key, value);
            }
        }
    }

    static interface HintPageParameterSerializer {
        public void hintsToPageParameters(Map<String, String> var1, PageParameters var2);

        public void pageParametersToHints(PageParameters var1, Map<String, String> var2);
    }

    public static enum Mode {
        VIEW,
        EDIT;

    }

    public static enum RenderingHint {
        REGULAR,
        PROPERTY_COLUMN,
        PARENTED_TITLE_COLUMN,
        STANDALONE_TITLE_COLUMN;


        public boolean isRegular() {
            return this == REGULAR;
        }

        public boolean isInTablePropertyColumn() {
            return this == PROPERTY_COLUMN;
        }

        public boolean isInTable() {
            return this.isInTablePropertyColumn() || this.isInTableTitleColumn();
        }

        public boolean isInTableTitleColumn() {
            return this.isInParentedTableTitleColumn() || this.isInStandaloneTableTitleColumn();
        }

        public boolean isInParentedTableTitleColumn() {
            return this == PARENTED_TITLE_COLUMN;
        }

        public boolean isInStandaloneTableTitleColumn() {
            return this == STANDALONE_TITLE_COLUMN;
        }
    }
}

