/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;

public class ServiceActionsModel
extends ModelAbstract<List<ObjectAdapter>> {
    private static final long serialVersionUID = 1L;
    private final DomainServiceLayout.MenuBar menuBar;

    public ServiceActionsModel(DomainServiceLayout.MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public DomainServiceLayout.MenuBar getMenuBar() {
        return this.menuBar;
    }

    protected List<ObjectAdapter> load() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getServiceAdapters(), ServiceActionsModel.with(this.menuBar)));
    }

    private static Predicate<ObjectAdapter> with(final DomainServiceLayout.MenuBar menuBar) {
        return new Predicate<ObjectAdapter>(){

            public boolean apply(ObjectAdapter input) {
                DomainServiceLayoutFacet facet = (DomainServiceLayoutFacet)input.getSpecification().getFacet(DomainServiceLayoutFacet.class);
                return facet != null && facet.getMenuBar() == menuBar;
            }
        };
    }

    protected List<ObjectAdapter> getServiceAdapters() {
        return this.getPersistenceSession().getServices();
    }
}

