/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinJdbcFactory;
import org.apache.kylin.jdbc.KylinMeta;
import org.apache.kylin.jdbc.shaded.com.google.common.collect.Sets;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.DriverVersion;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:kylin:";
    protected static final Set<String> CLIENT_CALCITE_PROP_NAMES = Sets.newHashSet("caseSensitive", "unquotedCasing", "quoting", "conformance");

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-kylin-jdbc.properties", "Kylin JDBC Driver", "unknown version", "Kylin", "unknown version");
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                throw new UnsupportedOperationException();
            }
            case JDBC_40: {
                return KylinJdbcFactory.Version40.class.getName();
            }
        }
        return KylinJdbcFactory.Version41.class.getName();
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new KylinMeta((KylinConnection)connection);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occurred while registering JDBC driver " + Driver.class.getName() + ": " + e.toString());
        }
    }
}

