/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import org.apache.lucene.util.BytesRef;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.TermEntry;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.vectorizer.Weight;

public class TFDFMapper {
    private Vector vector;
    private final Weight weight;
    private long numTerms;
    private final TermInfo termInfo;
    private String field;
    private final int numDocs;

    public TFDFMapper(int numDocs, Weight weight, TermInfo termInfo) {
        this.weight = weight;
        this.termInfo = termInfo;
        this.numDocs = numDocs;
    }

    public void setExpectations(String field, long numTerms) {
        this.field = field;
        this.vector = new RandomAccessSparseVector(this.termInfo.totalTerms(field));
        this.numTerms = numTerms;
    }

    public void map(BytesRef term, int frequency) {
        TermEntry entry = this.termInfo.getTermEntry(this.field, term.utf8ToString());
        if (entry != null) {
            this.vector.setQuick(entry.getTermIdx(), this.weight.calculate(frequency, entry.getDocFreq(), (int)this.numTerms, this.numDocs));
        }
    }

    public Vector getVector() {
        return this.vector;
    }
}

