/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.hash;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="file")
public class JarFileHashAnalyzer
implements JarHashAnalyzer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String computeHash(JarAnalyzer jarAnalyzer) {
        JarData jarData = jarAnalyzer.getJarData();
        String result = jarData.getFileHash();
        if (result == null) {
            try (InputStream inputStream = Files.newInputStream(jarData.getFile().toPath(), new OpenOption[0]);){
                jarData.setFileHash(DigestUtils.sha1Hex((InputStream)inputStream));
            }
            catch (IOException e) {
                this.logger.warn("Unable to calculate the hashcode.", (Throwable)e);
            }
        }
        return result;
    }
}

