/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.client.java.message;

import org.apache.rocketmq.shaded.com.google.common.base.Objects;
import org.apache.rocketmq.client.apis.message.MessageId;

public class MessageIdImpl implements MessageId {
    private final String version;
    private final String suffix;

    public MessageIdImpl(String version, String suffix) {
        this.version = version;
        this.suffix = suffix;
    }

    /**
     * See {@link MessageId#getVersion()}
     */
    @Override
    public String getVersion() {
        return version;
    }

    /**
     * See {@link MessageId#toString()}
     */
    @Override
    public String toString() {
        // Use suffix directly for V0
        if (MessageIdCodec.MESSAGE_ID_VERSION_V0.equals(version)) {
            return suffix;
        }
        return version + suffix;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageIdImpl messageId = (MessageIdImpl) o;
        return Objects.equal(version, messageId.version) && Objects.equal(suffix, messageId.suffix);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(version, suffix);
    }
}
