/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/backend.proto

package org.apache.rocketmq.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * A backend rule provides configuration for an individual API element.
 * </pre>
 *
 * Protobuf type {@code google.api.BackendRule}
 */
public final class BackendRule extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.BackendRule)
    BackendRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackendRule.newBuilder() to construct.
  private BackendRule(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendRule() {
    selector_ = "";
    address_ = "";
    pathTranslation_ = 0;
    protocol_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendRule();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BackendRule(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              selector_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              address_ = s;
              break;
            }
          case 25:
            {
              deadline_ = input.readDouble();
              break;
            }
          case 33:
            {
              minDeadline_ = input.readDouble();
              break;
            }
          case 41:
            {
              operationDeadline_ = input.readDouble();
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              pathTranslation_ = rawValue;
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();
              authenticationCase_ = 7;
              authentication_ = s;
              break;
            }
          case 64:
            {
              authentication_ = input.readBool();
              authenticationCase_ = 8;
              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              protocol_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.api.BackendProto.internal_static_google_api_BackendRule_descriptor;
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.api.BackendProto.internal_static_google_api_BackendRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.api.BackendRule.class, org.apache.rocketmq.shaded.com.google.api.BackendRule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Path Translation specifies how to combine the backend address with the
   * request path in order to produce the appropriate forwarding URL for the
   * request.
   * Path Translation is applicable only to HTTP-based backends. Backends which
   * do not accept requests over HTTP/HTTPS should leave `path_translation`
   * unspecified.
   * </pre>
   *
   * Protobuf enum {@code google.api.BackendRule.PathTranslation}
   */
  public enum PathTranslation implements org.apache.rocketmq.shaded.com.google.protobuf.ProtocolMessageEnum {
    /** <code>PATH_TRANSLATION_UNSPECIFIED = 0;</code> */
    PATH_TRANSLATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the backend address as-is, with no modification to the path. If the
     * URL pattern contains variables, the variable names and values will be
     * appended to the query string. If a query string parameter and a URL
     * pattern variable have the same name, this may result in duplicate keys in
     * the query string.
     * # Examples
     * Given the following operation config:
     *     Method path:        /api/company/{cid}/user/{uid}
     *     Backend address:    https://example.cloudfunctions.net/getUser
     * Requests to the following request paths will call the backend at the
     * translated path:
     *     Request path: /api/company/widgetworks/user/johndoe
     *     Translated:
     *     https://example.cloudfunctions.net/getUser?cid=widgetworks&amp;uid=johndoe
     *     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
     *     Translated:
     *     https://example.cloudfunctions.net/getUser?timezone=EST&amp;cid=widgetworks&amp;uid=johndoe
     * </pre>
     *
     * <code>CONSTANT_ADDRESS = 1;</code>
     */
    CONSTANT_ADDRESS(1),
    /**
     *
     *
     * <pre>
     * The request path will be appended to the backend address.
     * # Examples
     * Given the following operation config:
     *     Method path:        /api/company/{cid}/user/{uid}
     *     Backend address:    https://example.appspot.com
     * Requests to the following request paths will call the backend at the
     * translated path:
     *     Request path: /api/company/widgetworks/user/johndoe
     *     Translated:
     *     https://example.appspot.com/api/company/widgetworks/user/johndoe
     *     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
     *     Translated:
     *     https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
     * </pre>
     *
     * <code>APPEND_PATH_TO_ADDRESS = 2;</code>
     */
    APPEND_PATH_TO_ADDRESS(2),
    UNRECOGNIZED(-1),
    ;

    /** <code>PATH_TRANSLATION_UNSPECIFIED = 0;</code> */
    public static final int PATH_TRANSLATION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the backend address as-is, with no modification to the path. If the
     * URL pattern contains variables, the variable names and values will be
     * appended to the query string. If a query string parameter and a URL
     * pattern variable have the same name, this may result in duplicate keys in
     * the query string.
     * # Examples
     * Given the following operation config:
     *     Method path:        /api/company/{cid}/user/{uid}
     *     Backend address:    https://example.cloudfunctions.net/getUser
     * Requests to the following request paths will call the backend at the
     * translated path:
     *     Request path: /api/company/widgetworks/user/johndoe
     *     Translated:
     *     https://example.cloudfunctions.net/getUser?cid=widgetworks&amp;uid=johndoe
     *     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
     *     Translated:
     *     https://example.cloudfunctions.net/getUser?timezone=EST&amp;cid=widgetworks&amp;uid=johndoe
     * </pre>
     *
     * <code>CONSTANT_ADDRESS = 1;</code>
     */
    public static final int CONSTANT_ADDRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The request path will be appended to the backend address.
     * # Examples
     * Given the following operation config:
     *     Method path:        /api/company/{cid}/user/{uid}
     *     Backend address:    https://example.appspot.com
     * Requests to the following request paths will call the backend at the
     * translated path:
     *     Request path: /api/company/widgetworks/user/johndoe
     *     Translated:
     *     https://example.appspot.com/api/company/widgetworks/user/johndoe
     *     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
     *     Translated:
     *     https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
     * </pre>
     *
     * <code>APPEND_PATH_TO_ADDRESS = 2;</code>
     */
    public static final int APPEND_PATH_TO_ADDRESS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PathTranslation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PathTranslation forNumber(int value) {
      switch (value) {
        case 0:
          return PATH_TRANSLATION_UNSPECIFIED;
        case 1:
          return CONSTANT_ADDRESS;
        case 2:
          return APPEND_PATH_TO_ADDRESS;
        default:
          return null;
      }
    }

    public static org.apache.rocketmq.shaded.com.google.protobuf.Internal.EnumLiteMap<PathTranslation> internalGetValueMap() {
      return internalValueMap;
    }

    private static final org.apache.rocketmq.shaded.com.google.protobuf.Internal.EnumLiteMap<PathTranslation>
        internalValueMap =
            new org.apache.rocketmq.shaded.com.google.protobuf.Internal.EnumLiteMap<PathTranslation>() {
              public PathTranslation findValueByNumber(int number) {
                return PathTranslation.forNumber(number);
              }
            };

    public final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.api.BackendRule.getDescriptor().getEnumTypes().get(0);
    }

    private static final PathTranslation[] VALUES = values();

    public static PathTranslation valueOf(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PathTranslation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.BackendRule.PathTranslation)
  }

  private int authenticationCase_ = 0;
  private java.lang.Object authentication_;

  public enum AuthenticationCase
      implements
          org.apache.rocketmq.shaded.com.google.protobuf.Internal.EnumLite,
          org.apache.rocketmq.shaded.com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    JWT_AUDIENCE(7),
    DISABLE_AUTH(8),
    AUTHENTICATION_NOT_SET(0);
    private final int value;

    private AuthenticationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthenticationCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthenticationCase forNumber(int value) {
      switch (value) {
        case 7:
          return JWT_AUDIENCE;
        case 8:
          return DISABLE_AUTH;
        case 0:
          return AUTHENTICATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthenticationCase getAuthenticationCase() {
    return AuthenticationCase.forNumber(authenticationCase_);
  }

  public static final int SELECTOR_FIELD_NUMBER = 1;
  private volatile java.lang.Object selector_;
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The selector.
   */
  @java.lang.Override
  public java.lang.String getSelector() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Selects the methods to which this rule applies.
   * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
   * </pre>
   *
   * <code>string selector = 1;</code>
   *
   * @return The bytes for selector.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
    java.lang.Object ref = selector_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selector_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDRESS_FIELD_NUMBER = 2;
  private volatile java.lang.Object address_;
  /**
   *
   *
   * <pre>
   * The address of the API backend.
   * The scheme is used to determine the backend protocol and security.
   * The following schemes are accepted:
   *    SCHEME        PROTOCOL    SECURITY
   *    http://       HTTP        None
   *    https://      HTTP        TLS
   *    grpc://       gRPC        None
   *    grpcs://      gRPC        TLS
   * It is recommended to explicitly include a scheme. Leaving out the scheme
   * may cause constrasting behaviors across platforms.
   * If the port is unspecified, the default is:
   * - 80 for schemes without TLS
   * - 443 for schemes with TLS
   * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
   * to specify the protocol version.
   * </pre>
   *
   * <code>string address = 2;</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public java.lang.String getAddress() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      address_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The address of the API backend.
   * The scheme is used to determine the backend protocol and security.
   * The following schemes are accepted:
   *    SCHEME        PROTOCOL    SECURITY
   *    http://       HTTP        None
   *    https://      HTTP        TLS
   *    grpc://       gRPC        None
   *    grpcs://      gRPC        TLS
   * It is recommended to explicitly include a scheme. Leaving out the scheme
   * may cause constrasting behaviors across platforms.
   * If the port is unspecified, the default is:
   * - 80 for schemes without TLS
   * - 443 for schemes with TLS
   * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
   * to specify the protocol version.
   * </pre>
   *
   * <code>string address = 2;</code>
   *
   * @return The bytes for address.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getAddressBytes() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      address_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEADLINE_FIELD_NUMBER = 3;
  private double deadline_;
  /**
   *
   *
   * <pre>
   * The number of seconds to wait for a response from a request. The default
   * varies based on the request protocol and deployment environment.
   * </pre>
   *
   * <code>double deadline = 3;</code>
   *
   * @return The deadline.
   */
  @java.lang.Override
  public double getDeadline() {
    return deadline_;
  }

  public static final int MIN_DEADLINE_FIELD_NUMBER = 4;
  private double minDeadline_;
  /**
   *
   *
   * <pre>
   * Minimum deadline in seconds needed for this method. Calls having deadline
   * value lower than this will be rejected.
   * </pre>
   *
   * <code>double min_deadline = 4;</code>
   *
   * @return The minDeadline.
   */
  @java.lang.Override
  public double getMinDeadline() {
    return minDeadline_;
  }

  public static final int OPERATION_DEADLINE_FIELD_NUMBER = 5;
  private double operationDeadline_;
  /**
   *
   *
   * <pre>
   * The number of seconds to wait for the completion of a long running
   * operation. The default is no deadline.
   * </pre>
   *
   * <code>double operation_deadline = 5;</code>
   *
   * @return The operationDeadline.
   */
  @java.lang.Override
  public double getOperationDeadline() {
    return operationDeadline_;
  }

  public static final int PATH_TRANSLATION_FIELD_NUMBER = 6;
  private int pathTranslation_;
  /**
   * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
   *
   * @return The enum numeric value on the wire for pathTranslation.
   */
  @java.lang.Override
  public int getPathTranslationValue() {
    return pathTranslation_;
  }
  /**
   * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
   *
   * @return The pathTranslation.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation getPathTranslation() {
    @SuppressWarnings("deprecation")
    org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation result =
        org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.valueOf(pathTranslation_);
    return result == null ? org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.UNRECOGNIZED : result;
  }

  public static final int JWT_AUDIENCE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The JWT audience is used when generating a JWT ID token for the backend.
   * This ID token will be added in the HTTP "authorization" header, and sent
   * to the backend.
   * </pre>
   *
   * <code>string jwt_audience = 7;</code>
   *
   * @return Whether the jwtAudience field is set.
   */
  public boolean hasJwtAudience() {
    return authenticationCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The JWT audience is used when generating a JWT ID token for the backend.
   * This ID token will be added in the HTTP "authorization" header, and sent
   * to the backend.
   * </pre>
   *
   * <code>string jwt_audience = 7;</code>
   *
   * @return The jwtAudience.
   */
  public java.lang.String getJwtAudience() {
    java.lang.Object ref = "";
    if (authenticationCase_ == 7) {
      ref = authentication_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (authenticationCase_ == 7) {
        authentication_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The JWT audience is used when generating a JWT ID token for the backend.
   * This ID token will be added in the HTTP "authorization" header, and sent
   * to the backend.
   * </pre>
   *
   * <code>string jwt_audience = 7;</code>
   *
   * @return The bytes for jwtAudience.
   */
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getJwtAudienceBytes() {
    java.lang.Object ref = "";
    if (authenticationCase_ == 7) {
      ref = authentication_;
    }
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (authenticationCase_ == 7) {
        authentication_ = b;
      }
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_AUTH_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * When disable_auth is true, a JWT ID token won't be generated and the
   * original "Authorization" HTTP header will be preserved. If the header is
   * used to carry the original token and is expected by the backend, this
   * field must be set to true to preserve the header.
   * </pre>
   *
   * <code>bool disable_auth = 8;</code>
   *
   * @return Whether the disableAuth field is set.
   */
  @java.lang.Override
  public boolean hasDisableAuth() {
    return authenticationCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * When disable_auth is true, a JWT ID token won't be generated and the
   * original "Authorization" HTTP header will be preserved. If the header is
   * used to carry the original token and is expected by the backend, this
   * field must be set to true to preserve the header.
   * </pre>
   *
   * <code>bool disable_auth = 8;</code>
   *
   * @return The disableAuth.
   */
  @java.lang.Override
  public boolean getDisableAuth() {
    if (authenticationCase_ == 8) {
      return (java.lang.Boolean) authentication_;
    }
    return false;
  }

  public static final int PROTOCOL_FIELD_NUMBER = 9;
  private volatile java.lang.Object protocol_;
  /**
   *
   *
   * <pre>
   * The protocol used for sending a request to the backend.
   * The supported values are "http/1.1" and "h2".
   * The default value is inferred from the scheme in the
   * [address][google.api.BackendRule.address] field:
   *    SCHEME        PROTOCOL
   *    http://       http/1.1
   *    https://      http/1.1
   *    grpc://       h2
   *    grpcs://      h2
   * For secure HTTP backends (https://) that support HTTP/2, set this field
   * to "h2" for improved performance.
   * Configuring this field to non-default values is only supported for secure
   * HTTP backends. This field will be ignored for all other backends.
   * See
   * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
   * for more details on the supported values.
   * </pre>
   *
   * <code>string protocol = 9;</code>
   *
   * @return The protocol.
   */
  @java.lang.Override
  public java.lang.String getProtocol() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The protocol used for sending a request to the backend.
   * The supported values are "http/1.1" and "h2".
   * The default value is inferred from the scheme in the
   * [address][google.api.BackendRule.address] field:
   *    SCHEME        PROTOCOL
   *    http://       http/1.1
   *    https://      http/1.1
   *    grpc://       h2
   *    grpcs://      h2
   * For secure HTTP backends (https://) that support HTTP/2, set this field
   * to "h2" for improved performance.
   * Configuring this field to non-default values is only supported for secure
   * HTTP backends. This field will be ignored for all other backends.
   * See
   * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
   * for more details on the supported values.
   * </pre>
   *
   * <code>string protocol = 9;</code>
   *
   * @return The bytes for protocol.
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getProtocolBytes() {
    java.lang.Object ref = protocol_;
    if (ref instanceof java.lang.String) {
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
          org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protocol_ = b;
      return b;
    } else {
      return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selector_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, address_);
    }
    if (java.lang.Double.doubleToRawLongBits(deadline_) != 0) {
      output.writeDouble(3, deadline_);
    }
    if (java.lang.Double.doubleToRawLongBits(minDeadline_) != 0) {
      output.writeDouble(4, minDeadline_);
    }
    if (java.lang.Double.doubleToRawLongBits(operationDeadline_) != 0) {
      output.writeDouble(5, operationDeadline_);
    }
    if (pathTranslation_
        != org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.PATH_TRANSLATION_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, pathTranslation_);
    }
    if (authenticationCase_ == 7) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 7, authentication_);
    }
    if (authenticationCase_ == 8) {
      output.writeBool(8, (boolean) ((java.lang.Boolean) authentication_));
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.writeString(output, 9, protocol_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(selector_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, selector_);
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(2, address_);
    }
    if (java.lang.Double.doubleToRawLongBits(deadline_) != 0) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(3, deadline_);
    }
    if (java.lang.Double.doubleToRawLongBits(minDeadline_) != 0) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(4, minDeadline_);
    }
    if (java.lang.Double.doubleToRawLongBits(operationDeadline_) != 0) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeDoubleSize(5, operationDeadline_);
    }
    if (pathTranslation_
        != org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.PATH_TRANSLATION_UNSPECIFIED.getNumber()) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeEnumSize(6, pathTranslation_);
    }
    if (authenticationCase_ == 7) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(7, authentication_);
    }
    if (authenticationCase_ == 8) {
      size +=
          org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeBoolSize(
              8, (boolean) ((java.lang.Boolean) authentication_));
    }
    if (!org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.isStringEmpty(protocol_)) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.computeStringSize(9, protocol_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.api.BackendRule)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.api.BackendRule other = (org.apache.rocketmq.shaded.com.google.api.BackendRule) obj;

    if (!getSelector().equals(other.getSelector())) return false;
    if (!getAddress().equals(other.getAddress())) return false;
    if (java.lang.Double.doubleToLongBits(getDeadline())
        != java.lang.Double.doubleToLongBits(other.getDeadline())) return false;
    if (java.lang.Double.doubleToLongBits(getMinDeadline())
        != java.lang.Double.doubleToLongBits(other.getMinDeadline())) return false;
    if (java.lang.Double.doubleToLongBits(getOperationDeadline())
        != java.lang.Double.doubleToLongBits(other.getOperationDeadline())) return false;
    if (pathTranslation_ != other.pathTranslation_) return false;
    if (!getProtocol().equals(other.getProtocol())) return false;
    if (!getAuthenticationCase().equals(other.getAuthenticationCase())) return false;
    switch (authenticationCase_) {
      case 7:
        if (!getJwtAudience().equals(other.getJwtAudience())) return false;
        break;
      case 8:
        if (getDisableAuth() != other.getDisableAuth()) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getSelector().hashCode();
    hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getAddress().hashCode();
    hash = (37 * hash) + DEADLINE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + org.apache.rocketmq.shaded.com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDeadline()));
    hash = (37 * hash) + MIN_DEADLINE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + org.apache.rocketmq.shaded.com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getMinDeadline()));
    hash = (37 * hash) + OPERATION_DEADLINE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + org.apache.rocketmq.shaded.com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getOperationDeadline()));
    hash = (37 * hash) + PATH_TRANSLATION_FIELD_NUMBER;
    hash = (53 * hash) + pathTranslation_;
    hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getProtocol().hashCode();
    switch (authenticationCase_) {
      case 7:
        hash = (37 * hash) + JWT_AUDIENCE_FIELD_NUMBER;
        hash = (53 * hash) + getJwtAudience().hashCode();
        break;
      case 8:
        hash = (37 * hash) + DISABLE_AUTH_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.rocketmq.shaded.com.google.protobuf.Internal.hashBoolean(getDisableAuth());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.api.BackendRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A backend rule provides configuration for an individual API element.
   * </pre>
   *
   * Protobuf type {@code google.api.BackendRule}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.BackendRule)
      org.apache.rocketmq.shaded.com.google.api.BackendRuleOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.api.BackendProto.internal_static_google_api_BackendRule_descriptor;
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.api.BackendProto.internal_static_google_api_BackendRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.api.BackendRule.class, org.apache.rocketmq.shaded.com.google.api.BackendRule.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.api.BackendRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      selector_ = "";

      address_ = "";

      deadline_ = 0D;

      minDeadline_ = 0D;

      operationDeadline_ = 0D;

      pathTranslation_ = 0;

      protocol_ = "";

      authenticationCase_ = 0;
      authentication_ = null;
      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.api.BackendProto.internal_static_google_api_BackendRule_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.BackendRule getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.api.BackendRule.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.BackendRule build() {
      org.apache.rocketmq.shaded.com.google.api.BackendRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.BackendRule buildPartial() {
      org.apache.rocketmq.shaded.com.google.api.BackendRule result = new org.apache.rocketmq.shaded.com.google.api.BackendRule(this);
      result.selector_ = selector_;
      result.address_ = address_;
      result.deadline_ = deadline_;
      result.minDeadline_ = minDeadline_;
      result.operationDeadline_ = operationDeadline_;
      result.pathTranslation_ = pathTranslation_;
      if (authenticationCase_ == 7) {
        result.authentication_ = authentication_;
      }
      if (authenticationCase_ == 8) {
        result.authentication_ = authentication_;
      }
      result.protocol_ = protocol_;
      result.authenticationCase_ = authenticationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.api.BackendRule) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.api.BackendRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.api.BackendRule other) {
      if (other == org.apache.rocketmq.shaded.com.google.api.BackendRule.getDefaultInstance()) return this;
      if (!other.getSelector().isEmpty()) {
        selector_ = other.selector_;
        onChanged();
      }
      if (!other.getAddress().isEmpty()) {
        address_ = other.address_;
        onChanged();
      }
      if (other.getDeadline() != 0D) {
        setDeadline(other.getDeadline());
      }
      if (other.getMinDeadline() != 0D) {
        setMinDeadline(other.getMinDeadline());
      }
      if (other.getOperationDeadline() != 0D) {
        setOperationDeadline(other.getOperationDeadline());
      }
      if (other.pathTranslation_ != 0) {
        setPathTranslationValue(other.getPathTranslationValue());
      }
      if (!other.getProtocol().isEmpty()) {
        protocol_ = other.protocol_;
        onChanged();
      }
      switch (other.getAuthenticationCase()) {
        case JWT_AUDIENCE:
          {
            authenticationCase_ = 7;
            authentication_ = other.authentication_;
            onChanged();
            break;
          }
        case DISABLE_AUTH:
          {
            setDisableAuth(other.getDisableAuth());
            break;
          }
        case AUTHENTICATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.api.BackendRule parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.api.BackendRule) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int authenticationCase_ = 0;
    private java.lang.Object authentication_;

    public AuthenticationCase getAuthenticationCase() {
      return AuthenticationCase.forNumber(authenticationCase_);
    }

    public Builder clearAuthentication() {
      authenticationCase_ = 0;
      authentication_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object selector_ = "";
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The selector.
     */
    public java.lang.String getSelector() {
      java.lang.Object ref = selector_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return The bytes for selector.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getSelectorBytes() {
      java.lang.Object ref = selector_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selector_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      selector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelector() {

      selector_ = getDefaultInstance().getSelector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selects the methods to which this rule applies.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     * </pre>
     *
     * <code>string selector = 1;</code>
     *
     * @param value The bytes for selector to set.
     * @return This builder for chaining.
     */
    public Builder setSelectorBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      selector_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object address_ = "";
    /**
     *
     *
     * <pre>
     * The address of the API backend.
     * The scheme is used to determine the backend protocol and security.
     * The following schemes are accepted:
     *    SCHEME        PROTOCOL    SECURITY
     *    http://       HTTP        None
     *    https://      HTTP        TLS
     *    grpc://       gRPC        None
     *    grpcs://      gRPC        TLS
     * It is recommended to explicitly include a scheme. Leaving out the scheme
     * may cause constrasting behaviors across platforms.
     * If the port is unspecified, the default is:
     * - 80 for schemes without TLS
     * - 443 for schemes with TLS
     * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
     * to specify the protocol version.
     * </pre>
     *
     * <code>string address = 2;</code>
     *
     * @return The address.
     */
    public java.lang.String getAddress() {
      java.lang.Object ref = address_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address of the API backend.
     * The scheme is used to determine the backend protocol and security.
     * The following schemes are accepted:
     *    SCHEME        PROTOCOL    SECURITY
     *    http://       HTTP        None
     *    https://      HTTP        TLS
     *    grpc://       gRPC        None
     *    grpcs://      gRPC        TLS
     * It is recommended to explicitly include a scheme. Leaving out the scheme
     * may cause constrasting behaviors across platforms.
     * If the port is unspecified, the default is:
     * - 80 for schemes without TLS
     * - 443 for schemes with TLS
     * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
     * to specify the protocol version.
     * </pre>
     *
     * <code>string address = 2;</code>
     *
     * @return The bytes for address.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getAddressBytes() {
      java.lang.Object ref = address_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        address_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address of the API backend.
     * The scheme is used to determine the backend protocol and security.
     * The following schemes are accepted:
     *    SCHEME        PROTOCOL    SECURITY
     *    http://       HTTP        None
     *    https://      HTTP        TLS
     *    grpc://       gRPC        None
     *    grpcs://      gRPC        TLS
     * It is recommended to explicitly include a scheme. Leaving out the scheme
     * may cause constrasting behaviors across platforms.
     * If the port is unspecified, the default is:
     * - 80 for schemes without TLS
     * - 443 for schemes with TLS
     * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
     * to specify the protocol version.
     * </pre>
     *
     * <code>string address = 2;</code>
     *
     * @param value The address to set.
     * @return This builder for chaining.
     */
    public Builder setAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      address_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address of the API backend.
     * The scheme is used to determine the backend protocol and security.
     * The following schemes are accepted:
     *    SCHEME        PROTOCOL    SECURITY
     *    http://       HTTP        None
     *    https://      HTTP        TLS
     *    grpc://       gRPC        None
     *    grpcs://      gRPC        TLS
     * It is recommended to explicitly include a scheme. Leaving out the scheme
     * may cause constrasting behaviors across platforms.
     * If the port is unspecified, the default is:
     * - 80 for schemes without TLS
     * - 443 for schemes with TLS
     * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
     * to specify the protocol version.
     * </pre>
     *
     * <code>string address = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddress() {

      address_ = getDefaultInstance().getAddress();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address of the API backend.
     * The scheme is used to determine the backend protocol and security.
     * The following schemes are accepted:
     *    SCHEME        PROTOCOL    SECURITY
     *    http://       HTTP        None
     *    https://      HTTP        TLS
     *    grpc://       gRPC        None
     *    grpcs://      gRPC        TLS
     * It is recommended to explicitly include a scheme. Leaving out the scheme
     * may cause constrasting behaviors across platforms.
     * If the port is unspecified, the default is:
     * - 80 for schemes without TLS
     * - 443 for schemes with TLS
     * For HTTP backends, use [protocol][google.api.BackendRule.protocol]
     * to specify the protocol version.
     * </pre>
     *
     * <code>string address = 2;</code>
     *
     * @param value The bytes for address to set.
     * @return This builder for chaining.
     */
    public Builder setAddressBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      address_ = value;
      onChanged();
      return this;
    }

    private double deadline_;
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for a response from a request. The default
     * varies based on the request protocol and deployment environment.
     * </pre>
     *
     * <code>double deadline = 3;</code>
     *
     * @return The deadline.
     */
    @java.lang.Override
    public double getDeadline() {
      return deadline_;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for a response from a request. The default
     * varies based on the request protocol and deployment environment.
     * </pre>
     *
     * <code>double deadline = 3;</code>
     *
     * @param value The deadline to set.
     * @return This builder for chaining.
     */
    public Builder setDeadline(double value) {

      deadline_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for a response from a request. The default
     * varies based on the request protocol and deployment environment.
     * </pre>
     *
     * <code>double deadline = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeadline() {

      deadline_ = 0D;
      onChanged();
      return this;
    }

    private double minDeadline_;
    /**
     *
     *
     * <pre>
     * Minimum deadline in seconds needed for this method. Calls having deadline
     * value lower than this will be rejected.
     * </pre>
     *
     * <code>double min_deadline = 4;</code>
     *
     * @return The minDeadline.
     */
    @java.lang.Override
    public double getMinDeadline() {
      return minDeadline_;
    }
    /**
     *
     *
     * <pre>
     * Minimum deadline in seconds needed for this method. Calls having deadline
     * value lower than this will be rejected.
     * </pre>
     *
     * <code>double min_deadline = 4;</code>
     *
     * @param value The minDeadline to set.
     * @return This builder for chaining.
     */
    public Builder setMinDeadline(double value) {

      minDeadline_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum deadline in seconds needed for this method. Calls having deadline
     * value lower than this will be rejected.
     * </pre>
     *
     * <code>double min_deadline = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinDeadline() {

      minDeadline_ = 0D;
      onChanged();
      return this;
    }

    private double operationDeadline_;
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for the completion of a long running
     * operation. The default is no deadline.
     * </pre>
     *
     * <code>double operation_deadline = 5;</code>
     *
     * @return The operationDeadline.
     */
    @java.lang.Override
    public double getOperationDeadline() {
      return operationDeadline_;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for the completion of a long running
     * operation. The default is no deadline.
     * </pre>
     *
     * <code>double operation_deadline = 5;</code>
     *
     * @param value The operationDeadline to set.
     * @return This builder for chaining.
     */
    public Builder setOperationDeadline(double value) {

      operationDeadline_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds to wait for the completion of a long running
     * operation. The default is no deadline.
     * </pre>
     *
     * <code>double operation_deadline = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationDeadline() {

      operationDeadline_ = 0D;
      onChanged();
      return this;
    }

    private int pathTranslation_ = 0;
    /**
     * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
     *
     * @return The enum numeric value on the wire for pathTranslation.
     */
    @java.lang.Override
    public int getPathTranslationValue() {
      return pathTranslation_;
    }
    /**
     * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
     *
     * @param value The enum numeric value on the wire for pathTranslation to set.
     * @return This builder for chaining.
     */
    public Builder setPathTranslationValue(int value) {

      pathTranslation_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
     *
     * @return The pathTranslation.
     */
    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation getPathTranslation() {
      @SuppressWarnings("deprecation")
      org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation result =
          org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.valueOf(pathTranslation_);
      return result == null ? org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation.UNRECOGNIZED : result;
    }
    /**
     * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
     *
     * @param value The pathTranslation to set.
     * @return This builder for chaining.
     */
    public Builder setPathTranslation(org.apache.rocketmq.shaded.com.google.api.BackendRule.PathTranslation value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pathTranslation_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.google.api.BackendRule.PathTranslation path_translation = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPathTranslation() {

      pathTranslation_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @return Whether the jwtAudience field is set.
     */
    @java.lang.Override
    public boolean hasJwtAudience() {
      return authenticationCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @return The jwtAudience.
     */
    @java.lang.Override
    public java.lang.String getJwtAudience() {
      java.lang.Object ref = "";
      if (authenticationCase_ == 7) {
        ref = authentication_;
      }
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (authenticationCase_ == 7) {
          authentication_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @return The bytes for jwtAudience.
     */
    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getJwtAudienceBytes() {
      java.lang.Object ref = "";
      if (authenticationCase_ == 7) {
        ref = authentication_;
      }
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (authenticationCase_ == 7) {
          authentication_ = b;
        }
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @param value The jwtAudience to set.
     * @return This builder for chaining.
     */
    public Builder setJwtAudience(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authenticationCase_ = 7;
      authentication_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJwtAudience() {
      if (authenticationCase_ == 7) {
        authenticationCase_ = 0;
        authentication_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The JWT audience is used when generating a JWT ID token for the backend.
     * This ID token will be added in the HTTP "authorization" header, and sent
     * to the backend.
     * </pre>
     *
     * <code>string jwt_audience = 7;</code>
     *
     * @param value The bytes for jwtAudience to set.
     * @return This builder for chaining.
     */
    public Builder setJwtAudienceBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authenticationCase_ = 7;
      authentication_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When disable_auth is true, a JWT ID token won't be generated and the
     * original "Authorization" HTTP header will be preserved. If the header is
     * used to carry the original token and is expected by the backend, this
     * field must be set to true to preserve the header.
     * </pre>
     *
     * <code>bool disable_auth = 8;</code>
     *
     * @return Whether the disableAuth field is set.
     */
    public boolean hasDisableAuth() {
      return authenticationCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * When disable_auth is true, a JWT ID token won't be generated and the
     * original "Authorization" HTTP header will be preserved. If the header is
     * used to carry the original token and is expected by the backend, this
     * field must be set to true to preserve the header.
     * </pre>
     *
     * <code>bool disable_auth = 8;</code>
     *
     * @return The disableAuth.
     */
    public boolean getDisableAuth() {
      if (authenticationCase_ == 8) {
        return (java.lang.Boolean) authentication_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * When disable_auth is true, a JWT ID token won't be generated and the
     * original "Authorization" HTTP header will be preserved. If the header is
     * used to carry the original token and is expected by the backend, this
     * field must be set to true to preserve the header.
     * </pre>
     *
     * <code>bool disable_auth = 8;</code>
     *
     * @param value The disableAuth to set.
     * @return This builder for chaining.
     */
    public Builder setDisableAuth(boolean value) {
      authenticationCase_ = 8;
      authentication_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When disable_auth is true, a JWT ID token won't be generated and the
     * original "Authorization" HTTP header will be preserved. If the header is
     * used to carry the original token and is expected by the backend, this
     * field must be set to true to preserve the header.
     * </pre>
     *
     * <code>bool disable_auth = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableAuth() {
      if (authenticationCase_ == 8) {
        authenticationCase_ = 0;
        authentication_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object protocol_ = "";
    /**
     *
     *
     * <pre>
     * The protocol used for sending a request to the backend.
     * The supported values are "http/1.1" and "h2".
     * The default value is inferred from the scheme in the
     * [address][google.api.BackendRule.address] field:
     *    SCHEME        PROTOCOL
     *    http://       http/1.1
     *    https://      http/1.1
     *    grpc://       h2
     *    grpcs://      h2
     * For secure HTTP backends (https://) that support HTTP/2, set this field
     * to "h2" for improved performance.
     * Configuring this field to non-default values is only supported for secure
     * HTTP backends. This field will be ignored for all other backends.
     * See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for more details on the supported values.
     * </pre>
     *
     * <code>string protocol = 9;</code>
     *
     * @return The protocol.
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (!(ref instanceof java.lang.String)) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString bs = (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The protocol used for sending a request to the backend.
     * The supported values are "http/1.1" and "h2".
     * The default value is inferred from the scheme in the
     * [address][google.api.BackendRule.address] field:
     *    SCHEME        PROTOCOL
     *    http://       http/1.1
     *    https://      http/1.1
     *    grpc://       h2
     *    grpcs://      h2
     * For secure HTTP backends (https://) that support HTTP/2, set this field
     * to "h2" for improved performance.
     * Configuring this field to non-default values is only supported for secure
     * HTTP backends. This field will be ignored for all other backends.
     * See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for more details on the supported values.
     * </pre>
     *
     * <code>string protocol = 9;</code>
     *
     * @return The bytes for protocol.
     */
    public org.apache.rocketmq.shaded.com.google.protobuf.ByteString getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof String) {
        org.apache.rocketmq.shaded.com.google.protobuf.ByteString b =
            org.apache.rocketmq.shaded.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (org.apache.rocketmq.shaded.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The protocol used for sending a request to the backend.
     * The supported values are "http/1.1" and "h2".
     * The default value is inferred from the scheme in the
     * [address][google.api.BackendRule.address] field:
     *    SCHEME        PROTOCOL
     *    http://       http/1.1
     *    https://      http/1.1
     *    grpc://       h2
     *    grpcs://      h2
     * For secure HTTP backends (https://) that support HTTP/2, set this field
     * to "h2" for improved performance.
     * Configuring this field to non-default values is only supported for secure
     * HTTP backends. This field will be ignored for all other backends.
     * See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for more details on the supported values.
     * </pre>
     *
     * <code>string protocol = 9;</code>
     *
     * @param value The protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      protocol_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol used for sending a request to the backend.
     * The supported values are "http/1.1" and "h2".
     * The default value is inferred from the scheme in the
     * [address][google.api.BackendRule.address] field:
     *    SCHEME        PROTOCOL
     *    http://       http/1.1
     *    https://      http/1.1
     *    grpc://       h2
     *    grpcs://      h2
     * For secure HTTP backends (https://) that support HTTP/2, set this field
     * to "h2" for improved performance.
     * Configuring this field to non-default values is only supported for secure
     * HTTP backends. This field will be ignored for all other backends.
     * See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for more details on the supported values.
     * </pre>
     *
     * <code>string protocol = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtocol() {

      protocol_ = getDefaultInstance().getProtocol();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The protocol used for sending a request to the backend.
     * The supported values are "http/1.1" and "h2".
     * The default value is inferred from the scheme in the
     * [address][google.api.BackendRule.address] field:
     *    SCHEME        PROTOCOL
     *    http://       http/1.1
     *    https://      http/1.1
     *    grpc://       h2
     *    grpcs://      h2
     * For secure HTTP backends (https://) that support HTTP/2, set this field
     * to "h2" for improved performance.
     * Configuring this field to non-default values is only supported for secure
     * HTTP backends. This field will be ignored for all other backends.
     * See
     * https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
     * for more details on the supported values.
     * </pre>
     *
     * <code>string protocol = 9;</code>
     *
     * @param value The bytes for protocol to set.
     * @return This builder for chaining.
     */
    public Builder setProtocolBytes(org.apache.rocketmq.shaded.com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      protocol_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.BackendRule)
  }

  // @@protoc_insertion_point(class_scope:google.api.BackendRule)
  private static final org.apache.rocketmq.shaded.com.google.api.BackendRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.api.BackendRule();
  }

  public static org.apache.rocketmq.shaded.com.google.api.BackendRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<BackendRule> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<BackendRule>() {
        @java.lang.Override
        public BackendRule parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new BackendRule(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<BackendRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<BackendRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.BackendRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
