/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/consumer.proto

package org.apache.rocketmq.shaded.com.google.api;

/**
 *
 *
 * <pre>
 * A descriptor for defining project properties for a service. One service may
 * have many consumer projects, and the service may want to behave differently
 * depending on some properties on the project. For example, a project may be
 * associated with a school, or a business, or a government agency, a business
 * type property on the project may affect how a service responds to the client.
 * This descriptor defines which properties are allowed to be set on a project.
 * Example:
 *    project_properties:
 *      properties:
 *      - name: NO_WATERMARK
 *        type: BOOL
 *        description: Allows usage of the API without watermarks.
 *      - name: EXTENDED_TILE_CACHE_PERIOD
 *        type: INT64
 * </pre>
 *
 * Protobuf type {@code google.api.ProjectProperties}
 */
public final class ProjectProperties extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.ProjectProperties)
    ProjectPropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProjectProperties.newBuilder() to construct.
  private ProjectProperties(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProjectProperties() {
    properties_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProjectProperties();
  }

  @java.lang.Override
  public final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ProjectProperties(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                properties_ = new java.util.ArrayList<org.apache.rocketmq.shaded.com.google.api.Property>();
                mutable_bitField0_ |= 0x00000001;
              }
              properties_.add(
                  input.readMessage(org.apache.rocketmq.shaded.com.google.api.Property.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (org.apache.rocketmq.shaded.com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        properties_ = java.util.Collections.unmodifiableList(properties_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return org.apache.rocketmq.shaded.com.google.api.ConsumerProto.internal_static_google_api_ProjectProperties_descriptor;
  }

  @java.lang.Override
  protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.apache.rocketmq.shaded.com.google.api.ConsumerProto
        .internal_static_google_api_ProjectProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.apache.rocketmq.shaded.com.google.api.ProjectProperties.class, org.apache.rocketmq.shaded.com.google.api.ProjectProperties.Builder.class);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 1;
  private java.util.List<org.apache.rocketmq.shaded.com.google.api.Property> properties_;
  /**
   *
   *
   * <pre>
   * List of per consumer project-specific properties.
   * </pre>
   *
   * <code>repeated .google.api.Property properties = 1;</code>
   */
  @java.lang.Override
  public java.util.List<org.apache.rocketmq.shaded.com.google.api.Property> getPropertiesList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * List of per consumer project-specific properties.
   * </pre>
   *
   * <code>repeated .google.api.Property properties = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder> getPropertiesOrBuilderList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * List of per consumer project-specific properties.
   * </pre>
   *
   * <code>repeated .google.api.Property properties = 1;</code>
   */
  @java.lang.Override
  public int getPropertiesCount() {
    return properties_.size();
  }
  /**
   *
   *
   * <pre>
   * List of per consumer project-specific properties.
   * </pre>
   *
   * <code>repeated .google.api.Property properties = 1;</code>
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.Property getProperties(int index) {
    return properties_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of per consumer project-specific properties.
   * </pre>
   *
   * <code>repeated .google.api.Property properties = 1;</code>
   */
  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder getPropertiesOrBuilder(int index) {
    return properties_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < properties_.size(); i++) {
      output.writeMessage(1, properties_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < properties_.size(); i++) {
      size += org.apache.rocketmq.shaded.com.google.protobuf.CodedOutputStream.computeMessageSize(1, properties_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof org.apache.rocketmq.shaded.com.google.api.ProjectProperties)) {
      return super.equals(obj);
    }
    org.apache.rocketmq.shaded.com.google.api.ProjectProperties other = (org.apache.rocketmq.shaded.com.google.api.ProjectProperties) obj;

    if (!getPropertiesList().equals(other.getPropertiesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPropertiesCount() > 0) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getPropertiesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(java.nio.ByteBuffer data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      java.nio.ByteBuffer data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(org.apache.rocketmq.shaded.com.google.protobuf.ByteString data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.ByteString data,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(byte[] data)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      byte[] data, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseDelimitedFrom(
      java.io.InputStream input, org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties parseFrom(
      org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
      org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.apache.rocketmq.shaded.com.google.api.ProjectProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A descriptor for defining project properties for a service. One service may
   * have many consumer projects, and the service may want to behave differently
   * depending on some properties on the project. For example, a project may be
   * associated with a school, or a business, or a government agency, a business
   * type property on the project may affect how a service responds to the client.
   * This descriptor defines which properties are allowed to be set on a project.
   * Example:
   *    project_properties:
   *      properties:
   *      - name: NO_WATERMARK
   *        type: BOOL
   *        description: Allows usage of the API without watermarks.
   *      - name: EXTENDED_TILE_CACHE_PERIOD
   *        type: INT64
   * </pre>
   *
   * Protobuf type {@code google.api.ProjectProperties}
   */
  public static final class Builder extends org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.ProjectProperties)
      org.apache.rocketmq.shaded.com.google.api.ProjectPropertiesOrBuilder {
    public static final org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return org.apache.rocketmq.shaded.com.google.api.ConsumerProto.internal_static_google_api_ProjectProperties_descriptor;
    }

    @java.lang.Override
    protected org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.rocketmq.shaded.com.google.api.ConsumerProto
          .internal_static_google_api_ProjectProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.rocketmq.shaded.com.google.api.ProjectProperties.class,
              org.apache.rocketmq.shaded.com.google.api.ProjectProperties.Builder.class);
    }

    // Construct using org.apache.rocketmq.shaded.com.google.api.ProjectProperties.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        propertiesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return org.apache.rocketmq.shaded.com.google.api.ConsumerProto.internal_static_google_api_ProjectProperties_descriptor;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.ProjectProperties getDefaultInstanceForType() {
      return org.apache.rocketmq.shaded.com.google.api.ProjectProperties.getDefaultInstance();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.ProjectProperties build() {
      org.apache.rocketmq.shaded.com.google.api.ProjectProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.api.ProjectProperties buildPartial() {
      org.apache.rocketmq.shaded.com.google.api.ProjectProperties result = new org.apache.rocketmq.shaded.com.google.api.ProjectProperties(this);
      int from_bitField0_ = bitField0_;
      if (propertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          properties_ = java.util.Collections.unmodifiableList(properties_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.properties_ = properties_;
      } else {
        result.properties_ = propertiesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.protobuf.Message other) {
      if (other instanceof org.apache.rocketmq.shaded.com.google.api.ProjectProperties) {
        return mergeFrom((org.apache.rocketmq.shaded.com.google.api.ProjectProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.apache.rocketmq.shaded.com.google.api.ProjectProperties other) {
      if (other == org.apache.rocketmq.shaded.com.google.api.ProjectProperties.getDefaultInstance()) return this;
      if (propertiesBuilder_ == null) {
        if (!other.properties_.isEmpty()) {
          if (properties_.isEmpty()) {
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePropertiesIsMutable();
            properties_.addAll(other.properties_);
          }
          onChanged();
        }
      } else {
        if (!other.properties_.isEmpty()) {
          if (propertiesBuilder_.isEmpty()) {
            propertiesBuilder_.dispose();
            propertiesBuilder_ = null;
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000001);
            propertiesBuilder_ =
                org.apache.rocketmq.shaded.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPropertiesFieldBuilder()
                    : null;
          } else {
            propertiesBuilder_.addAllMessages(other.properties_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
        org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      org.apache.rocketmq.shaded.com.google.api.ProjectProperties parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (org.apache.rocketmq.shaded.com.google.api.ProjectProperties) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<org.apache.rocketmq.shaded.com.google.api.Property> properties_ = java.util.Collections.emptyList();

    private void ensurePropertiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        properties_ = new java.util.ArrayList<org.apache.rocketmq.shaded.com.google.api.Property>(properties_);
        bitField0_ |= 0x00000001;
      }
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.rocketmq.shaded.com.google.api.Property,
            org.apache.rocketmq.shaded.com.google.api.Property.Builder,
            org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder>
        propertiesBuilder_;

    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public java.util.List<org.apache.rocketmq.shaded.com.google.api.Property> getPropertiesList() {
      if (propertiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(properties_);
      } else {
        return propertiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public int getPropertiesCount() {
      if (propertiesBuilder_ == null) {
        return properties_.size();
      } else {
        return propertiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.api.Property getProperties(int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder setProperties(int index, org.apache.rocketmq.shaded.com.google.api.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.set(index, value);
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder setProperties(int index, org.apache.rocketmq.shaded.com.google.api.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.set(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder addProperties(org.apache.rocketmq.shaded.com.google.api.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder addProperties(int index, org.apache.rocketmq.shaded.com.google.api.Property value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(index, value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder addProperties(org.apache.rocketmq.shaded.com.google.api.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder addProperties(int index, org.apache.rocketmq.shaded.com.google.api.Property.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder addAllProperties(java.lang.Iterable<? extends org.apache.rocketmq.shaded.com.google.api.Property> values) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        org.apache.rocketmq.shaded.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
        onChanged();
      } else {
        propertiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder clearProperties() {
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        propertiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public Builder removeProperties(int index) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.remove(index);
        onChanged();
      } else {
        propertiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.api.Property.Builder getPropertiesBuilder(int index) {
      return getPropertiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder getPropertiesOrBuilder(int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public java.util.List<? extends org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder> getPropertiesOrBuilderList() {
      if (propertiesBuilder_ != null) {
        return propertiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(properties_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.api.Property.Builder addPropertiesBuilder() {
      return getPropertiesFieldBuilder().addBuilder(org.apache.rocketmq.shaded.com.google.api.Property.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public org.apache.rocketmq.shaded.com.google.api.Property.Builder addPropertiesBuilder(int index) {
      return getPropertiesFieldBuilder()
          .addBuilder(index, org.apache.rocketmq.shaded.com.google.api.Property.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of per consumer project-specific properties.
     * </pre>
     *
     * <code>repeated .google.api.Property properties = 1;</code>
     */
    public java.util.List<org.apache.rocketmq.shaded.com.google.api.Property.Builder> getPropertiesBuilderList() {
      return getPropertiesFieldBuilder().getBuilderList();
    }

    private org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
            org.apache.rocketmq.shaded.com.google.api.Property,
            org.apache.rocketmq.shaded.com.google.api.Property.Builder,
            org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder>
        getPropertiesFieldBuilder() {
      if (propertiesBuilder_ == null) {
        propertiesBuilder_ =
            new org.apache.rocketmq.shaded.com.google.protobuf.RepeatedFieldBuilderV3<
                org.apache.rocketmq.shaded.com.google.api.Property,
                org.apache.rocketmq.shaded.com.google.api.Property.Builder,
                org.apache.rocketmq.shaded.com.google.api.PropertyOrBuilder>(
                properties_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        properties_ = null;
      }
      return propertiesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.apache.rocketmq.shaded.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.ProjectProperties)
  }

  // @@protoc_insertion_point(class_scope:google.api.ProjectProperties)
  private static final org.apache.rocketmq.shaded.com.google.api.ProjectProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new org.apache.rocketmq.shaded.com.google.api.ProjectProperties();
  }

  public static org.apache.rocketmq.shaded.com.google.api.ProjectProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.apache.rocketmq.shaded.com.google.protobuf.Parser<ProjectProperties> PARSER =
      new org.apache.rocketmq.shaded.com.google.protobuf.AbstractParser<ProjectProperties>() {
        @java.lang.Override
        public ProjectProperties parsePartialFrom(
            org.apache.rocketmq.shaded.com.google.protobuf.CodedInputStream input,
            org.apache.rocketmq.shaded.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.apache.rocketmq.shaded.com.google.protobuf.InvalidProtocolBufferException {
          return new ProjectProperties(input, extensionRegistry);
        }
      };

  public static org.apache.rocketmq.shaded.com.google.protobuf.Parser<ProjectProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.protobuf.Parser<ProjectProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.apache.rocketmq.shaded.com.google.api.ProjectProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
