/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance.metadata.proxy;

import com.google.common.base.Joiner;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.utils.IpUtils;

public final class ProxyInstanceMetaData
implements InstanceMetaData {
    private static final String DELIMITER = "@";
    private final String id;
    private final String ip;
    private final int port;

    public ProxyInstanceMetaData(String id, int port) {
        this.id = id;
        this.ip = IpUtils.getIp();
        this.port = port;
    }

    public ProxyInstanceMetaData(String id, String attributes) {
        this.id = id;
        String[] attributesList = attributes.split(DELIMITER);
        this.ip = attributesList[0];
        this.port = Integer.parseInt(attributesList[1]);
    }

    @Override
    public InstanceType getType() {
        return InstanceType.PROXY;
    }

    @Override
    public String getAttributes() {
        return Joiner.on((String)DELIMITER).join((Object)this.ip, (Object)this.port, new Object[0]);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

