/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.opentracing;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.toolkit.opentracing.SkywalkingActiveSpan;
import org.apache.skywalking.apm.toolkit.opentracing.SkywalkingContext;
import org.apache.skywalking.apm.toolkit.opentracing.SkywalkingSpan;
import org.apache.skywalking.apm.toolkit.opentracing.Tag;

public class SkywalkingSpanBuilder
implements Tracer.SpanBuilder {
    private List<Tag> tags = new LinkedList<Tag>();
    private String operationName;
    private boolean isEntry = false;
    private boolean isExit = false;
    private int port;
    private String peer;
    private boolean isError = false;
    private long startTime;

    public SkywalkingSpanBuilder(String operationName) {
        this.operationName = operationName;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        if (parent instanceof SkywalkingContext) {
            return this;
        }
        throw new IllegalArgumentException("parent must be type of SpanContext");
    }

    public Tracer.SpanBuilder asChildOf(BaseSpan<?> parent) {
        if (parent instanceof SkywalkingSpan || parent instanceof SkywalkingActiveSpan) {
            return this;
        }
        throw new IllegalArgumentException("parent must be type of SkywalkingSpan");
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        if ("follows_from".equals(referenceType)) {
            throw new IllegalArgumentException("only support CHILD_OF reference");
        }
        return this.asChildOf(referencedContext);
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        if (Tags.SPAN_KIND.getKey().equals(key)) {
            if ("client".equals(value) || "producer".equals(value)) {
                this.isEntry = false;
                this.isExit = true;
            } else if ("server".equals(value) || "consumer".equals(value)) {
                this.isEntry = true;
                this.isExit = false;
            } else {
                this.isEntry = false;
                this.isExit = false;
            }
        } else if (Tags.PEER_HOST_IPV4.getKey().equals(key) || Tags.PEER_HOST_IPV6.getKey().equals(key) || Tags.PEER_HOSTNAME.getKey().equals(key)) {
            this.peer = value;
        } else if (Tags.PEER_SERVICE.getKey().equals(key)) {
            this.operationName = value;
        } else {
            this.tags.add(new Tag(key, value));
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            this.isError = value;
        } else {
            this.tags.add(new Tag(key, value ? "true" : "false"));
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        if (Tags.PEER_PORT.getKey().equals(key)) {
            this.port = value.intValue();
        } else {
            this.tags.add(new Tag(key, value.toString()));
        }
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTime = microseconds;
        return this;
    }

    public ActiveSpan startActive() {
        return new SkywalkingActiveSpan(new SkywalkingSpan(this));
    }

    public Span startManual() {
        return new SkywalkingSpan(this);
    }

    @Deprecated
    public Span start() {
        return this.startManual();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public int getPort() {
        return this.port;
    }

    public String getPeer() {
        return this.peer;
    }

    public boolean isError() {
        return this.isError;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        return this;
    }
}

