/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.RandomDataGenerator$$anonfun$17$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Random;

public final class RandomDataGenerator$ {
    public static final RandomDataGenerator$ MODULE$;
    private final float org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_INTERESTING_VALUE;
    private final float org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL;
    private final int MAX_STR_LEN;
    private final int MAX_ARR_SIZE;
    private final int MAX_MAP_SIZE;

    static {
        new RandomDataGenerator$();
    }

    public float org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_INTERESTING_VALUE() {
        return this.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_INTERESTING_VALUE;
    }

    public float org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL() {
        return this.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL;
    }

    public final int MAX_STR_LEN() {
        return this.MAX_STR_LEN;
    }

    public final int MAX_ARR_SIZE() {
        return this.MAX_ARR_SIZE;
    }

    public final int MAX_MAP_SIZE() {
        return this.MAX_MAP_SIZE;
    }

    private <T> Some<Function0<T>> randomNumeric(Random rand, Function1<Random, T> uniformRand, Seq<T> interestingValues) {
        Serializable f2 = new Serializable(rand, uniformRand, interestingValues){
            public static final long serialVersionUID = 0L;
            private final Random rand$2;
            private final Function1 uniformRand$1;
            private final Seq interestingValues$1;

            public final T apply() {
                return (T)(this.rand$2.nextFloat() <= RandomDataGenerator$.MODULE$.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_INTERESTING_VALUE() ? this.interestingValues$1.apply(this.rand$2.nextInt(this.interestingValues$1.length())) : this.uniformRand$1.apply((Object)this.rand$2));
            }
            {
                this.rand$2 = rand$2;
                this.uniformRand$1 = uniformRand$1;
                this.interestingValues$1 = interestingValues$1;
            }
        };
        return new Some((Object)f2);
    }

    public float intBitsToFloat(int bits) {
        float value = Float.intBitsToFloat(bits);
        return Predef$.MODULE$.float2Float(value).isNaN() ? Float.NaN : value;
    }

    public double longBitsToDouble(long bits) {
        double value = Double.longBitsToDouble(bits);
        return Predef$.MODULE$.double2Double(value).isNaN() ? Double.NaN : value;
    }

    public StructType randomSchema(Random rand, int numFields, Seq<DataType> acceptedTypes) {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.tabulate(numFields, (Function1)new Serializable(rand, acceptedTypes){
            public static final long serialVersionUID = 0L;
            private final Random rand$3;
            private final Seq acceptedTypes$1;

            public final StructField apply(int i) {
                DataType dt = (DataType)this.acceptedTypes$1.apply(this.rand$3.nextInt(this.acceptedTypes$1.size()));
                return new StructField(new StringBuilder().append((Object)"col_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), dt, this.rand$3.nextBoolean(), StructField$.MODULE$.apply$default$4());
            }
            {
                this.rand$3 = rand$3;
                this.acceptedTypes$1 = acceptedTypes$1;
            }
        }));
    }

    public StructType randomNestedSchema(Random rand, int totalFields, Seq<DataType> acceptedTypes) {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int i = 0;
        int numFields = totalFields;
        while (numFields > 0) {
            int v = rand.nextInt(3);
            if (v == 0) {
                DataType dt = (DataType)acceptedTypes.apply(rand.nextInt(acceptedTypes.size()));
                fields.$plus$eq((Object)new StructField(new StringBuilder().append((Object)"col_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), dt, rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                --numFields;
            } else if (v == 1) {
                DataType dt = (DataType)acceptedTypes.apply(rand.nextInt(acceptedTypes.size()));
                fields.$plus$eq((Object)new StructField(new StringBuilder().append((Object)"col_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (DataType)ArrayType$.MODULE$.apply(dt), rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                --numFields;
            } else {
                int n = Math.max(rand.nextInt(numFields), 1);
                StructType nested = this.randomNestedSchema(rand, n, acceptedTypes);
                fields.$plus$eq((Object)new StructField(new StringBuilder().append((Object)"col_").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (DataType)nested, rand.nextBoolean(), StructField$.MODULE$.$lessinit$greater$default$4()));
                numFields -= n;
            }
            ++i;
        }
        return StructType$.MODULE$.apply((Seq)fields);
    }

    public Option<Function0<Object>> forType(DataType dataType, boolean nullable, Random rand) {
        DecimalType decimalType;
        Option option;
        Option option2;
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Object)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final String apply() {
                    return this.rand$1.nextString(this.rand$1.nextInt(RandomDataGenerator$.MODULE$.MAX_STR_LEN()));
                }
                {
                    this.rand$1 = rand$1;
                }
            });
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Object)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                /*
                 * WARNING - void declaration
                 */
                public final byte[] apply() {
                    void var1_1;
                    byte[] arr = new byte[this.rand$1.nextInt(RandomDataGenerator$.MODULE$.MAX_STR_LEN())];
                    this.rand$1.nextBytes(arr);
                    return var1_1;
                }
                {
                    this.rand$1 = rand$1;
                }
            });
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Object)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.rand$1.nextBoolean();
                }
                {
                    this.rand$1 = rand$1;
                }
            });
        } else if (DateType$.MODULE$.equals(dataType2)) {
            Serializable generator = new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final Date apply() {
                    long milliseconds = this.rand$1.nextLong() % 253402329599999L;
                    while (milliseconds < -62135740800000L) {
                        milliseconds = this.rand$1.nextLong() % 253402329599999L;
                    }
                    return DateTimeUtils$.MODULE$.toJavaDate((int)(milliseconds / 86400000L));
                }
                {
                    this.rand$1 = rand$1;
                }
            };
            option2 = new Some((Object)generator);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            Serializable generator = new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final Timestamp apply() {
                    long milliseconds = this.rand$1.nextLong() % 253402329599999L;
                    while (milliseconds < -62135740800000L) {
                        milliseconds = this.rand$1.nextLong() % 253402329599999L;
                    }
                    return DateTimeUtils$.MODULE$.toJavaTimestamp(milliseconds * 1000L);
                }
                {
                    this.rand$1 = rand$1;
                }
            };
            option2 = new Some((Object)generator);
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Object)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final CalendarInterval apply() {
                    int months = this.rand$1.nextInt(1000);
                    long ns = this.rand$1.nextLong();
                    return new CalendarInterval(months, ns);
                }
                {
                    this.rand$1 = rand$1;
                }
            });
        } else if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            option2 = new Some((Object)new Serializable(rand, precision, scale){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;
                private final int precision$1;
                private final int scale$1;

                public final BigDecimal apply() {
                    return package$.MODULE$.BigDecimal().apply(this.rand$1.nextLong() % (long)scala.math.package$.MODULE$.pow(10.0, (double)this.precision$1), this.scale$1, new MathContext(this.precision$1)).bigDecimal();
                }
                {
                    this.rand$1 = rand$1;
                    this.precision$1 = precision$1;
                    this.scale$1 = scale$1;
                }
            });
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Random r) {
                    return RandomDataGenerator$.MODULE$.longBitsToDouble(r.nextLong());
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double$.MODULE$.MinValue(), Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN, 0.0}))));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(Random r) {
                    return RandomDataGenerator$.MODULE$.intBitsToFloat(r.nextInt());
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{Float$.MODULE$.MinValue(), Float.MIN_VALUE, Float.MAX_VALUE, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NaN, 0.0f}))));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte apply(Random x$1) {
                    return (byte)x$1.nextInt();
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-128, 127, (byte)0}))));
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Random x$2) {
                    return x$2.nextInt();
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 0}))));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Random x$3) {
                    return x$3.nextLong();
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 0L}))));
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            option2 = this.randomNumeric(rand, (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final short apply(Random x$4) {
                    return (short)x$4.nextInt();
                }
            }, (Seq)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, (short)0}))));
        } else if (NullType$.MODULE$.equals(dataType2)) {
            option2 = new Some((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            option2 = this.forType(elementType, containsNull, rand).map((Function1)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                public final Random rand$1;

                public final Function0<Seq<Object>> apply(Function0<Object> elementGenerator) {
                    return new Serializable(this, elementGenerator){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.16 $outer;
                        private final Function0 elementGenerator$1;

                        public final Seq<Object> apply() {
                            return (Seq)Seq$.MODULE$.fill(this.$outer.rand$1.nextInt(RandomDataGenerator$.MODULE$.MAX_ARR_SIZE()), this.elementGenerator$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.elementGenerator$1 = elementGenerator$1;
                        }
                    };
                }
                {
                    this.rand$1 = rand$1;
                }
            });
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            option2 = this.forType(keyType, false, rand).flatMap((Function1)new Serializable(rand, valueType, valueContainsNull){
                public static final long serialVersionUID = 0L;
                public final Random rand$1;
                private final DataType valueType$1;
                private final boolean valueContainsNull$1;

                public final Option<Function0<Map<Object, Object>>> apply(Function0<Object> keyGenerator) {
                    return RandomDataGenerator$.MODULE$.forType(this.valueType$1, this.valueContainsNull$1, this.rand$1).map((Function1)new Serializable(this, keyGenerator){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.17 $outer;
                        public final Function0 keyGenerator$1;

                        public final Function0<Map<Object, Object>> apply(Function0<Object> valueGenerator) {
                            return new Serializable(this, valueGenerator){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$17$$anonfun$apply$2 $outer;
                                private final Function0 valueGenerator$1;

                                public final Map<Object, Object> apply() {
                                    int length = this.$outer.org$apache$spark$sql$RandomDataGenerator$$anonfun$$anonfun$$$outer().rand$1.nextInt(RandomDataGenerator$.MODULE$.MAX_MAP_SIZE());
                                    HashSet keys = (HashSet)HashSet$.MODULE$.apply((Seq)Seq$.MODULE$.fill(length, this.$outer.keyGenerator$1));
                                    for (int count = 0; keys.size() < length && count < RandomDataGenerator$.MODULE$.MAX_MAP_SIZE(); ++count) {
                                        keys.$plus$eq(this.$outer.keyGenerator$1.apply());
                                    }
                                    Seq values = (Seq)Seq$.MODULE$.fill(keys.size(), this.valueGenerator$1);
                                    return ((TraversableOnce)keys.zip((GenIterable)values, HashSet$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.valueGenerator$1 = valueGenerator$1;
                                }
                            };
                        }

                        public /* synthetic */ anonfun.17 org$apache$spark$sql$RandomDataGenerator$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.keyGenerator$1 = keyGenerator$1;
                        }
                    });
                }
                {
                    this.rand$1 = rand$1;
                    this.valueType$1 = valueType$1;
                    this.valueContainsNull$1 = valueContainsNull$1;
                }
            });
        } else if (dataType2 instanceof StructType) {
            None$ none$;
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Seq maybeFieldGenerators = (Seq)Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(rand){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;

                public final Option<Function0<Object>> apply(StructField field) {
                    return RandomDataGenerator$.MODULE$.forType(field.dataType(), field.nullable(), this.rand$1);
                }
                {
                    this.rand$1 = rand$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            if (maybeFieldGenerators.forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Option<Function0<Object>> x$5) {
                    return x$5.isDefined();
                }
            })) {
                Seq fieldGenerators = (Seq)maybeFieldGenerators.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Function0<Object> apply(Option<Function0<Object>> x$6) {
                        return (Function0)x$6.get();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                none$ = new Some((Object)new Serializable(fieldGenerators){
                    public static final long serialVersionUID = 0L;
                    private final Seq fieldGenerators$1;

                    public final Row apply() {
                        return Row$.MODULE$.fromSeq((Seq)this.fieldGenerators$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Function0<Object> x$7) {
                                return x$7.apply();
                            }
                        }, Seq$.MODULE$.canBuildFrom()));
                    }
                    {
                        this.fieldGenerators$1 = fieldGenerators$1;
                    }
                });
            } else {
                none$ = None$.MODULE$;
            }
            option2 = none$;
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            Option<Function0<Object>> maybeSqlTypeGenerator = this.forType(userDefinedType.sqlType(), nullable, rand);
            Function1 toCatalystType = CatalystTypeConverters$.MODULE$.createToCatalystConverter(userDefinedType.sqlType());
            option2 = maybeSqlTypeGenerator.map((Function1)new Serializable(toCatalystType, userDefinedType){
                public static final long serialVersionUID = 0L;
                public final Function1 toCatalystType$1;
                public final UserDefinedType x20$1;

                public final Function0<Object> apply(Function0<Object> sqlTypeGenerator) {
                    return new Serializable(this, sqlTypeGenerator){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.22 $outer;
                        private final Function0 sqlTypeGenerator$1;

                        public final Object apply() {
                            Object generatedScalaValue = this.sqlTypeGenerator$1.apply();
                            return generatedScalaValue == null ? null : this.$outer.x20$1.deserialize(this.$outer.toCatalystType$1.apply(generatedScalaValue));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sqlTypeGenerator$1 = sqlTypeGenerator$1;
                        }
                    };
                }
                {
                    this.toCatalystType$1 = toCatalystType$1;
                    this.x20$1 = x20$1;
                }
            });
        } else {
            option2 = None$.MODULE$;
        }
        Option valueGenerator = option2;
        return valueGenerator.map((Function1)new Serializable(nullable, rand){
            public static final long serialVersionUID = 0L;
            private final boolean nullable$1;
            public final Random rand$1;

            public final Function0<Object> apply(Function0<Object> valueGenerator) {
                return this.nullable$1 ? new Serializable(this, valueGenerator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.forType.1 $outer;
                    private final Function0 valueGenerator$2;

                    public final Object apply() {
                        return this.$outer.rand$1.nextFloat() <= RandomDataGenerator$.MODULE$.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL() ? null : this.valueGenerator$2.apply();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.valueGenerator$2 = valueGenerator$2;
                    }
                } : valueGenerator;
            }
            {
                this.nullable$1 = nullable$1;
                this.rand$1 = rand$1;
            }
        });
    }

    public boolean forType$default$2() {
        return true;
    }

    public Random forType$default$3() {
        return new Random();
    }

    public Row randomRow(Random rand, StructType schema) {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable(rand, fields){
            public static final long serialVersionUID = 0L;
            private final Random rand$4;
            private final ArrayBuffer fields$1;

            public final ArrayBuffer<Object> apply(StructField f2) {
                ArrayBuffer arrayBuffer;
                DataType dataType = f2.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayBuffer arrayBuffer2;
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType childType = arrayType.elementType();
                    boolean nullable = arrayType.containsNull();
                    if (f2.nullable() && this.rand$4.nextFloat() <= RandomDataGenerator$.MODULE$.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL()) {
                        arrayBuffer2 = null;
                    } else {
                        ArrayBuffer arr = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                        int n = 1;
                        Option<Function0<Object>> generator = RandomDataGenerator$.MODULE$.forType(childType, nullable, this.rand$4);
                        Predef$.MODULE$.assert(generator.isDefined(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Unsupported type";
                            }
                        });
                        Function0 gen = (Function0)generator.get();
                        for (int i = 0; i < n; ++i) {
                            arr.$plus$eq(gen.apply());
                        }
                        arrayBuffer2 = arr;
                    }
                    ArrayBuffer data = arrayBuffer2;
                    arrayBuffer = this.fields$1.$plus$eq(data);
                } else if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] children2 = structType.fields();
                    arrayBuffer = this.fields$1.$plus$eq((Object)RandomDataGenerator$.MODULE$.randomRow(this.rand$4, new StructType(children2)));
                } else {
                    Option<Function0<Object>> generator = RandomDataGenerator$.MODULE$.forType(f2.dataType(), f2.nullable(), this.rand$4);
                    Predef$.MODULE$.assert(generator.isDefined(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unsupported type";
                        }
                    });
                    Function0 gen = (Function0)generator.get();
                    arrayBuffer = this.fields$1.$plus$eq(gen.apply());
                }
                return arrayBuffer;
            }
            {
                this.rand$4 = rand$4;
                this.fields$1 = fields$1;
            }
        });
        return Row$.MODULE$.fromSeq((Seq)fields);
    }

    private RandomDataGenerator$() {
        MODULE$ = this;
        this.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_INTERESTING_VALUE = 0.5f;
        this.org$apache$spark$sql$RandomDataGenerator$$PROBABILITY_OF_NULL = 0.1f;
        this.MAX_STR_LEN = 1024;
        this.MAX_ARR_SIZE = 128;
        this.MAX_MAP_SIZE = 128;
    }
}

