/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$$anonfun$14$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$$anonfun$14$$anonfun$apply$2$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$$anonfun$15$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$$anonfun$15$$anonfun$apply$5$;
import org.apache.spark.sql.catalyst.encoders.RowEncoderSuite$$anonfun$15$$anonfun$apply$5$$anonfun$apply$6$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.CodegenInterpretedPlanTest;
import org.apache.spark.sql.catalyst.plans.CodegenInterpretedPlanTest$class;
import org.apache.spark.sql.catalyst.plans.PlanTestBase$class;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001f\ty!k\\<F]\u000e|G-\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005AQM\\2pI\u0016\u00148O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0003qY\u0006t7/\u0003\u0002\u001a-\tQ2i\u001c3fO\u0016t\u0017J\u001c;feB\u0014X\r^3e!2\fg\u000eV3ti\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u00039\u0019HO];di>37\u000b\u001e:j]\u001e,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K\u0019\tQ\u0001^=qKNL!a\n\u0013\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004*\u0001\u0001\u0006IAI\u0001\u0010gR\u0014Xo\u0019;PMN#(/\u001b8hA!91\u0006\u0001b\u0001\n\u0013\t\u0013aC:ueV\u001cGo\u00144V\tRCa!\f\u0001!\u0002\u0013\u0011\u0013\u0001D:ueV\u001cGo\u00144V\tR\u0003\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\u000eCJ\u0014\u0018-_(g'R\u0014\u0018N\\4\u0016\u0003E\u0002\"a\t\u001a\n\u0005M\"#!C!se\u0006LH+\u001f9f\u0011\u0019)\u0004\u0001)A\u0005c\u0005q\u0011M\u001d:bs>37\u000b\u001e:j]\u001e\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001M\u0001\fCJ\u0014\u0018-_(g\u001dVdG\u000e\u0003\u0004:\u0001\u0001\u0006I!M\u0001\rCJ\u0014\u0018-_(g\u001dVdG\u000e\t\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0003-i\u0017\r](g'R\u0014\u0018N\\4\u0016\u0003u\u0002\"a\t \n\u0005}\"#aB'baRK\b/\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001f\u0002\u00195\f\u0007o\u00144TiJLgn\u001a\u0011\t\u000f\r\u0003!\u0019!C\u0005a\u0005Q\u0011M\u001d:bs>3W\u000b\u0012+\t\r\u0015\u0003\u0001\u0015!\u00032\u0003-\t'O]1z\u001f\u001a,F\t\u0016\u0011\t\u000b\u001d\u0003A\u0011\u0002%\u0002!\u0015t7m\u001c3f\t\u0016\u001cw\u000eZ3UKN$HCA%P!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;\t\u000bA3\u0005\u0019\u0001\u0012\u0002\rM\u001c\u0007.Z7b\u0001")
public class RowEncoderSuite
extends SparkFunSuite
implements CodegenInterpretedPlanTest {
    private final StructType structOfString;
    private final StructType structOfUDT;
    private final ArrayType arrayOfString;
    private final ArrayType arrayOfNull;
    private final MapType mapOfString;
    private final ArrayType arrayOfUDT;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$plans$CodegenInterpretedPlanTest$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        FunSuiteLike.class.test((FunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        CodegenInterpretedPlanTest$class.test(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testFallback(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        CodegenInterpretedPlanTest$class.testFallback(this, testName, testTags, testFun, pos);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase$class.conf(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase$class.normalizeExprIds(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase$class.normalizePlan(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase$class.comparePlans(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase$class.compareExpressions(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase$class.compareJoinOrder(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f2) {
        PlanTestBase$class.withSQLConf(this, pairs, f2);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase$class.comparePlans$default$3(this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    private StructType structOfString() {
        return this.structOfString;
    }

    private StructType structOfUDT() {
        return this.structOfUDT;
    }

    private ArrayType arrayOfString() {
        return this.arrayOfString;
    }

    private ArrayType arrayOfNull() {
        return this.arrayOfNull;
    }

    private MapType mapOfString() {
        return this.mapOfString;
    }

    private ArrayType arrayOfUDT() {
        return this.arrayOfUDT;
    }

    private void encodeDecodeTest(StructType schema) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"encode/decode: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.simpleString()})), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this, schema){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;
            private final StructType schema$1;

            public final Object apply() {
                ExpressionEncoder qual$9 = RowEncoder$.MODULE$.apply(this.schema$1);
                Seq x$17 = qual$9.resolveAndBind$default$1();
                Analyzer x$18 = qual$9.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$9.resolveAndBind(x$17, x$18);
                Function0 inputGenerator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)this.schema$1, false, RandomDataGenerator$.MODULE$.forType$default$3()).get();
                ObjectRef input = ObjectRef.create(null);
                try {
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1)new Serializable(this, encoder2, inputGenerator, input){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$encodeDecodeTest$1 $outer;
                        private final ExpressionEncoder encoder$2;
                        private final Function0 inputGenerator$1;
                        private final ObjectRef input$1;

                        public final Assertion apply(int _) {
                            this.input$1.elem = (Row)this.inputGenerator$1.apply();
                            InternalRow row = this.encoder$2.toRow((Object)((Row)this.input$1.elem));
                            Row convertedBack = (Row)this.encoder$2.fromRow(row);
                            Row $org_scalatest_assert_macro_left = (Row)this.input$1.elem;
                            Row $org_scalatest_assert_macro_right = convertedBack;
                            Row row2 = $org_scalatest_assert_macro_left;
                            Row row3 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(row2 != null ? !row2.equals(row3) : row3 != null), Prettifier$.MODULE$.default());
                            return this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.encoder$2 = encoder$2;
                            this.inputGenerator$1 = inputGenerator$1;
                            this.input$1 = input$1;
                        }
                    });
                    return BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    throw this.$outer.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n               |schema: ", "\n               |input: ", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema$1.simpleString(), (Row)input.elem})))).stripMargin(), exception, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
                }
            }

            public /* synthetic */ RowEncoderSuite org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.schema$1 = schema$1;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }

    public RowEncoderSuite() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        PlanTestBase$class.$init$(this);
        CodegenInterpretedPlanTest$class.$init$(this);
        this.structOfString = new StructType().add("str", (DataType)StringType$.MODULE$);
        this.structOfUDT = new StructType().add("udt", (DataType)new ExamplePointUDT(), false);
        this.arrayOfString = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
        this.arrayOfNull = ArrayType$.MODULE$.apply((DataType)NullType$.MODULE$);
        this.mapOfString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
        this.arrayOfUDT = new ArrayType((DataType)new ExamplePointUDT(), false);
        this.encodeDecodeTest(new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$).add("udt", (DataType)new ExamplePointUDT()));
        this.encodeDecodeTest(new StructType().add("arrayOfNull", (DataType)this.arrayOfNull()).add("arrayOfString", (DataType)this.arrayOfString()).add("arrayOfArrayOfString", (DataType)ArrayType$.MODULE$.apply((DataType)this.arrayOfString())).add("arrayOfArrayOfInt", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))).add("arrayOfMap", (DataType)ArrayType$.MODULE$.apply((DataType)this.mapOfString())).add("arrayOfStruct", (DataType)ArrayType$.MODULE$.apply((DataType)this.structOfString())).add("arrayOfUDT", (DataType)this.arrayOfUDT()));
        this.encodeDecodeTest(new StructType().add("mapOfIntAndString", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)).add("mapOfStringAndArray", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.arrayOfString())).add("mapOfArrayAndInt", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)IntegerType$.MODULE$)).add("mapOfArray", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)this.arrayOfString())).add("mapOfStringAndStruct", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.structOfString())).add("mapOfStructAndString", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)StringType$.MODULE$)).add("mapOfStruct", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)this.structOfString())));
        this.encodeDecodeTest(new StructType().add("structOfString", (DataType)this.structOfString()).add("structOfStructOfString", (DataType)new StructType().add("struct", (DataType)this.structOfString())).add("structOfArray", (DataType)new StructType().add("array", (DataType)this.arrayOfString())).add("structOfMap", (DataType)new StructType().add("map", (DataType)this.mapOfString())).add("structOfArrayAndMap", (DataType)new StructType().add("array", (DataType)this.arrayOfString()).add("map", (DataType)this.mapOfString())).add("structOfUDT", (DataType)this.structOfUDT()));
        this.test("encode/decode decimal type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("string", (DataType)StringType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("java_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("scala_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("catalyst_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
                Seq x$1 = qual$1.resolveAndBind$default$1();
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$1.resolveAndBind(x$1, x$2);
                java.math.BigDecimal javaDecimal = new java.math.BigDecimal("1234.5678");
                BigDecimal scalaDecimal = package$.MODULE$.BigDecimal().apply("1234.5678");
                Decimal catalystDecimal = Decimal$.MODULE$.apply("1234.5678");
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100), "test", BoxesRunTime.boxToDouble((double)0.123), javaDecimal, scalaDecimal, catalystDecimal}));
                InternalRow row = encoder2.toRow((Object)input);
                Row convertedBack = (Row)encoder2.fromRow(row);
                int $org_scalatest_assert_macro_left = convertedBack.getDecimal(3).compareTo(javaDecimal);
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                int $org_scalatest_assert_macro_left2 = convertedBack.getDecimal(4).compareTo(scalaDecimal.bigDecimal());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                int $org_scalatest_assert_macro_left3 = convertedBack.getDecimal(5).compareTo(catalystDecimal.toJavaBigDecimal());
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("RowEncoder should preserve decimal precision and scale", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("decimal", (DataType)new DecimalType(10, 5), false);
                ExpressionEncoder qual$2 = RowEncoder$.MODULE$.apply(schema);
                Seq x$3 = qual$2.resolveAndBind$default$1();
                Analyzer x$4 = qual$2.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$2.resolveAndBind(x$3, x$4);
                Decimal decimal = Decimal$.MODULE$.apply("67123.45");
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{decimal}));
                InternalRow row = encoder2.toRow((Object)input);
                Object $org_scalatest_assert_macro_left = row.toSeq(schema).head();
                Decimal $org_scalatest_assert_macro_right = decimal;
                Object object = $org_scalatest_assert_macro_left;
                Decimal decimal2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("RowEncoder should preserve schema nullability", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$, false);
                ExpressionEncoder qual$3 = RowEncoder$.MODULE$.apply(schema);
                Seq x$5 = qual$3.resolveAndBind$default$1();
                Analyzer x$6 = qual$3.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$3.resolveAndBind(x$5, x$6);
                Seq $org_scalatest_assert_macro_left = encoder2.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder2.serializer().head()).dataType();
                IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
                DataType dataType = $org_scalatest_assert_macro_left2;
                IntegerType$ integerType$ = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder2.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("RowEncoder should preserve nested column name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false), false);
                ExpressionEncoder qual$4 = RowEncoder$.MODULE$.apply(schema);
                Seq x$7 = qual$4.resolveAndBind$default$1();
                Analyzer x$8 = qual$4.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$4.resolveAndBind(x$7, x$8);
                Seq $org_scalatest_assert_macro_left = encoder2.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder2.serializer().head()).dataType();
                StructType $org_scalatest_assert_macro_right2 = new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false);
                DataType dataType = $org_scalatest_assert_macro_left2;
                StructType structType = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(structType) : structType != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder2.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = false;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("RowEncoder should support primitive arrays", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Object apply() {
                StructType schema = new StructType().add("booleanPrimitiveArray", (DataType)new ArrayType((DataType)BooleanType$.MODULE$, false)).add("bytePrimitiveArray", (DataType)new ArrayType((DataType)ByteType$.MODULE$, false)).add("shortPrimitiveArray", (DataType)new ArrayType((DataType)ShortType$.MODULE$, false)).add("intPrimitiveArray", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)).add("longPrimitiveArray", (DataType)new ArrayType((DataType)LongType$.MODULE$, false)).add("floatPrimitiveArray", (DataType)new ArrayType((DataType)FloatType$.MODULE$, false)).add("doublePrimitiveArray", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false));
                ExpressionEncoder qual$5 = RowEncoder$.MODULE$.apply(schema);
                Seq x$9 = qual$5.resolveAndBind$default$1();
                Analyzer x$10 = qual$5.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$5.resolveAndBind(x$9, x$10);
                Seq input = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{new boolean[]{true, false}, new byte[]{(byte)1, (byte)64, 127}, new short[]{(short)1, (short)255, Short.MAX_VALUE}, new int[]{1, 10000, Integer.MAX_VALUE}, new long[]{1, 1000000, Long.MAX_VALUE}, new float[]{(float)1.1, (float)123.456, Float.MAX_VALUE}, new double[]{11.1111, 123456.7890123, Double.MAX_VALUE}}));
                InternalRow row = encoder2.toRow((Object)Row$.MODULE$.fromSeq(input));
                Row convertedBack = (Row)encoder2.fromRow(row);
                return ((TraversableLike)input.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, convertedBack){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final Row convertedBack$1;

                    public final Assertion apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object array = tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().convertToEqualizer(this.convertedBack$1.getSeq(index));
                            Object $org_scalatest_assert_macro_right = array;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                            Assertion assertion = this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
                            return assertion;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.convertedBack$1 = convertedBack$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ RowEncoderSuite org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("RowEncoder should support array as the external type for ArrayType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("array", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).add("nestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$))).add("deepNestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$))));
                ExpressionEncoder qual$6 = RowEncoder$.MODULE$.apply(schema);
                Seq x$11 = qual$6.resolveAndBind$default$1();
                Analyzer x$12 = qual$6.resolveAndBind$default$2();
                ExpressionEncoder encoder2 = qual$6.resolveAndBind(x$11, x$12);
                Row input = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null}), ClassTag$.MODULE$.Any()), (Object[])new String[][]{(String[])((Object[])new String[]{"abc", null}), null}, new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Object[][]{(Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), null}), ClassTag$.MODULE$.Any()), null})), null}}));
                InternalRow row = encoder2.toRow((Object)input);
                Row convertedBack = (Row)encoder2.fromRow(row);
                Seq $org_scalatest_assert_macro_left = convertedBack.getSeq(0);
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null}));
                Seq seq = $org_scalatest_assert_macro_left;
                Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                Seq $org_scalatest_assert_macro_left2 = convertedBack.getSeq(1);
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", null})), null}));
                Seq seq3 = $org_scalatest_assert_macro_left2;
                Seq seq4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
                Seq $org_scalatest_assert_macro_left3 = convertedBack.getSeq(2);
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), null})), null})), null}));
                Seq seq5 = $org_scalatest_assert_macro_left3;
                Seq seq6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq5 != null ? !seq5.equals(seq6) : seq6 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("RowEncoder should throw RuntimeException if input row object is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$);
                ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
                RuntimeException e = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this, encoder2){
                    public static final long serialVersionUID = 0L;
                    private final ExpressionEncoder encoder$1;

                    public final InternalRow apply() {
                        return this.encoder$1.toRow(null);
                    }
                    {
                        this.encoder$1 = encoder$1;
                    }
                }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right2 = "top level row object";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("RowEncoder should validate external type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final Assertion apply() {
                RuntimeException e1 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$);
                        ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
                        return encoder2.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1))})));
                    }
                }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "java.lang.Short is not a valid external type";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
                RuntimeException e2 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)StringType$.MODULE$);
                        ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
                        return encoder2.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                    }
                }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "java.lang.Integer is not a valid external type";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
                RuntimeException e3 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)StringType$.MODULE$));
                        ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
                        return encoder2.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})));
                    }
                }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
                String $org_scalatest_assert_macro_left3 = e3.getMessage();
                String $org_scalatest_assert_macro_right3 = "scala.Tuple2 is not a valid external type";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
                RuntimeException e4 = (RuntimeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply() {
                        StructType schema = new StructType().add("a", (DataType)ArrayType$.MODULE$.apply((DataType)TimestampType$.MODULE$));
                        ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
                        return encoder2.toRow((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String[]{"a"}})));
                    }
                }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
                String $org_scalatest_assert_macro_left4 = e4.getMessage();
                String $org_scalatest_assert_macro_right4 = "java.lang.String is not a valid external type";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply(AtomicType elementType) {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1)new Serializable(this, elementType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;
                    public final AtomicType elementType$1;

                    public final void apply(boolean containsNull) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1)new Serializable(this, containsNull){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$14$$anonfun$apply$2 $outer;
                            public final boolean containsNull$1;

                            public final void apply(boolean nullable) {
                                this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().test(new StringBuilder().append((Object)"RowEncoder should preserve array nullability: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ArrayType(", ", containsNull = ", "), nullable = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.elementType$1, BoxesRunTime.boxToBoolean((boolean)this.containsNull$1), BoxesRunTime.boxToBoolean((boolean)nullable)}))).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this, nullable){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$14$$anonfun$apply$2$$anonfun$apply$3 $outer;
                                    private final boolean nullable$1;

                                    public final Assertion apply() {
                                        StructType schema = new StructType().add("array", (DataType)new ArrayType((DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().elementType$1, this.$outer.containsNull$1), this.nullable$1);
                                        ExpressionEncoder qual$7 = RowEncoder$.MODULE$.apply(schema);
                                        Seq x$13 = qual$7.resolveAndBind$default$1();
                                        Analyzer x$14 = qual$7.resolveAndBind$default$2();
                                        ExpressionEncoder encoder2 = qual$7.resolveAndBind(x$13, x$14);
                                        Seq $org_scalatest_assert_macro_left = encoder2.serializer();
                                        int $org_scalatest_assert_macro_right = 1;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                        this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                                        DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder2.serializer().head()).dataType();
                                        ArrayType $org_scalatest_assert_macro_right2 = new ArrayType((DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().elementType$1, this.$outer.containsNull$1);
                                        DataType dataType = $org_scalatest_assert_macro_left2;
                                        ArrayType arrayType = $org_scalatest_assert_macro_right2;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                                        this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                                        boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder2.serializer().head()).nullable();
                                        boolean $org_scalatest_assert_macro_right3 = this.nullable$1;
                                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.nullable$1 = nullable$1;
                                    }
                                }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                            }

                            public /* synthetic */ $anonfun$14$$anonfun$apply$2 org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.containsNull$1 = containsNull$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$14 org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.elementType$1 = elementType$1;
                    }
                });
            }

            public /* synthetic */ RowEncoderSuite org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowEncoderSuite $outer;

            public final void apply(AtomicType keyType) {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$}))).foreach((Function1)new Serializable(this, keyType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    public final AtomicType keyType$1;

                    public final void apply(AtomicType valueType) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1)new Serializable(this, valueType){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$15$$anonfun$apply$5 $outer;
                            public final AtomicType valueType$1;

                            public final void apply(boolean valueContainsNull) {
                                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1)new Serializable(this, valueContainsNull){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$15$$anonfun$apply$5$$anonfun$apply$6 $outer;
                                    public final boolean valueContainsNull$1;

                                    public final void apply(boolean nullable) {
                                        this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().test(new StringBuilder().append((Object)"RowEncoder should preserve map nullability: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MapType(", ", ", ", valueContainsNull = ", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().keyType$1, this.$outer.valueType$1, BoxesRunTime.boxToBoolean((boolean)this.valueContainsNull$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nullable = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)nullable)}))).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)new Serializable(this, nullable){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$15$$anonfun$apply$5$$anonfun$apply$6$$anonfun$apply$7 $outer;
                                            private final boolean nullable$2;

                                            public final Assertion apply() {
                                                StructType schema = new StructType().add("map", (DataType)new MapType((DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().keyType$1, (DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().valueType$1, this.$outer.valueContainsNull$1), this.nullable$2);
                                                ExpressionEncoder qual$8 = RowEncoder$.MODULE$.apply(schema);
                                                Seq x$15 = qual$8.resolveAndBind$default$1();
                                                Analyzer x$16 = qual$8.resolveAndBind$default$2();
                                                ExpressionEncoder encoder2 = qual$8.resolveAndBind(x$15, x$16);
                                                Seq $org_scalatest_assert_macro_left = encoder2.serializer();
                                                int $org_scalatest_assert_macro_right = 1;
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                                                this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                                                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder2.serializer().head()).dataType();
                                                MapType $org_scalatest_assert_macro_right2 = new MapType((DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().keyType$1, (DataType)this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().valueType$1, this.$outer.valueContainsNull$1);
                                                DataType dataType = $org_scalatest_assert_macro_left2;
                                                MapType mapType = $org_scalatest_assert_macro_right2;
                                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(mapType) : mapType != null), Prettifier$.MODULE$.default());
                                                this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
                                                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder2.serializer().head()).nullable();
                                                boolean $org_scalatest_assert_macro_right3 = this.nullable$2;
                                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                                                return this.$outer.org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.nullable$2 = nullable$2;
                                            }
                                        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                                    }

                                    public /* synthetic */ $anonfun$15$$anonfun$apply$5$$anonfun$apply$6 org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.valueContainsNull$1 = valueContainsNull$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$15$$anonfun$apply$5 org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.valueType$1 = valueType$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$15 org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.keyType$1 = keyType$1;
                    }
                });
            }

            public /* synthetic */ RowEncoderSuite org$apache$spark$sql$catalyst$encoders$RowEncoderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

