/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.ResolveTimeZone;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.CodegenObjectFactoryMode$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper$;
import org.apache.spark.sql.catalyst.expressions.FromUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.LiteralGenerator$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateMutableProjection$;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.optimizer.SimpleTestOptimizer$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType$;
import org.apache.spark.util.Utils$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Shrink$;
import org.scalacheck.util.Buildable$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.enablers.CheckerAsserting$;
import org.scalatest.enablers.WheneverAsserting$;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.GeneratorDrivenPropertyChecks;
import org.scalatest.prop.Whenever;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ExpressionEvalHelper$class {
    public static InternalRow create_row(SparkFunSuite $this, Seq values) {
        return InternalRow$.MODULE$.fromSeq((Seq)values.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object a) {
                return CatalystTypeConverters$.MODULE$.convertToCatalyst(a);
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private static Expression prepareEvaluation(SparkFunSuite $this, Expression expression) {
        SerializerInstance serializer = new JavaSerializer(new SparkConf()).newInstance();
        ResolveTimeZone resolver = new ResolveTimeZone(new SQLConf());
        return resolver.resolveTimeZones((Expression)serializer.deserialize(serializer.serialize((Object)expression, ClassTag$.MODULE$.apply(Expression.class)), ClassTag$.MODULE$.Nothing()));
    }

    public static void checkEvaluation(SparkFunSuite $this, Function0 expression, Object expected, InternalRow inputRow) {
        Object catalystValue = CatalystTypeConverters$.MODULE$.convertToCatalyst(expected);
        ((ExpressionEvalHelper)$this).checkEvaluationWithoutCodegen(ExpressionEvalHelper$class.expr$1($this, expression), catalystValue, inputRow);
        ((ExpressionEvalHelper)$this).checkEvaluationWithGeneratedMutableProjection(ExpressionEvalHelper$class.expr$1($this, expression), catalystValue, inputRow);
        if (GenerateUnsafeProjection$.MODULE$.canSupport(ExpressionEvalHelper$class.expr$1($this, expression).dataType())) {
            ((ExpressionEvalHelper)$this).checkEvaluationWithUnsafeProjection(ExpressionEvalHelper$class.expr$1($this, expression), catalystValue, inputRow);
        }
        ((ExpressionEvalHelper)$this).checkEvaluationWithOptimization(ExpressionEvalHelper$class.expr$1($this, expression), catalystValue, inputRow);
    }

    public static InternalRow checkEvaluation$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkResult(SparkFunSuite $this, Object result, Object expected, DataType exprDataType) {
        DataType dataType = UserDefinedType$.MODULE$.sqlType(exprDataType);
        Tuple2 tuple2 = new Tuple2(result, expected);
        if (tuple2 != null) {
            Object result2 = tuple2._1();
            Object expected2 = tuple2._2();
            if (result2 instanceof byte[]) {
                byte[] byArray = (byte[])result2;
                if (expected2 instanceof byte[]) {
                    byte[] byArray2 = (byte[])expected2;
                    return Arrays.equals(byArray, byArray2);
                }
            }
        }
        if (tuple2 != null) {
            Object result3 = tuple2._1();
            Object expected3 = tuple2._2();
            if (result3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)result3);
                if (expected3 instanceof TripleEqualsSupport.Spread) {
                    TripleEqualsSupport.Spread spread = (TripleEqualsSupport.Spread)expected3;
                    return spread.isWithin((Object)BoxesRunTime.boxToDouble((double)d));
                }
            }
        }
        if (tuple2 != null) {
            Object result4 = tuple2._1();
            Object expected4 = tuple2._2();
            if (result4 instanceof InternalRow) {
                InternalRow internalRow = (InternalRow)result4;
                if (expected4 instanceof InternalRow) {
                    Bool bool;
                    InternalRow internalRow2 = (InternalRow)expected4;
                    StructType st = (StructType)dataType;
                    int $org_scalatest_assert_macro_left = internalRow.numFields();
                    int $org_scalatest_assert_macro_right = st.length();
                    Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left2.value()) {
                        int $org_scalatest_assert_macro_left3 = internalRow2.numFields();
                        int $org_scalatest_assert_macro_right2 = st.length();
                        bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    } else {
                        bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                    return ((IterableLike)st.zipWithIndex(Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this, internalRow, internalRow2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SparkFunSuite $outer;
                        private final InternalRow x6$1;
                        private final InternalRow x7$1;

                        public final boolean apply(Tuple2<StructField, Object> x0$1) {
                            Tuple2<StructField, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                StructField f2 = (StructField)tuple2._1();
                                int i = tuple2._2$mcI$sp();
                                boolean bl = ((ExpressionEvalHelper)this.$outer).checkResult(this.x6$1.get(i, f2.dataType()), this.x7$1.get(i, f2.dataType()), f2.dataType());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x6$1 = x6$1;
                            this.x7$1 = x7$1;
                        }
                    });
                }
            }
        }
        if (tuple2 != null) {
            Object result5 = tuple2._1();
            Object expected5 = tuple2._2();
            if (result5 instanceof ArrayData) {
                ArrayData arrayData = (ArrayData)result5;
                if (expected5 instanceof ArrayData) {
                    ArrayData arrayData2 = (ArrayData)expected5;
                    if (arrayData.numElements() != arrayData2.numElements()) return false;
                    DataType et = ((ArrayType)dataType).elementType();
                    boolean isSame = true;
                    for (int i = 0; isSame && i < arrayData.numElements(); ++i) {
                        isSame = ((ExpressionEvalHelper)$this).checkResult(arrayData.get(i, et), arrayData2.get(i, et), et);
                    }
                    if (!isSame) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            Object result6 = tuple2._1();
            Object expected6 = tuple2._2();
            if (result6 instanceof MapData) {
                MapData mapData = (MapData)result6;
                if (expected6 instanceof MapData) {
                    MapData mapData2 = (MapData)expected6;
                    DataType kt = ((MapType)dataType).keyType();
                    DataType vt = ((MapType)dataType).valueType();
                    if (!((ExpressionEvalHelper)$this).checkResult(mapData.keyArray(), mapData2.keyArray(), (DataType)ArrayType$.MODULE$.apply(kt))) return false;
                    if (!((ExpressionEvalHelper)$this).checkResult(mapData.valueArray(), mapData2.valueArray(), (DataType)ArrayType$.MODULE$.apply(vt))) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            Object result7 = tuple2._1();
            Object expected7 = tuple2._2();
            if (result7 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)result7);
                if (expected7 instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)expected7);
                    if (!Predef$.MODULE$.double2Double(d2).isNaN()) {
                        if (d2 != d) return false;
                        return true;
                    }
                    boolean bl = Predef$.MODULE$.double2Double(d).isNaN();
                    return bl;
                }
            }
        }
        if (tuple2 != null) {
            Object result8 = tuple2._1();
            Object expected8 = tuple2._2();
            if (result8 instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)result8);
                if (expected8 instanceof Float) {
                    float f3 = BoxesRunTime.unboxToFloat((Object)expected8);
                    if (!Predef$.MODULE$.float2Float(f3).isNaN()) {
                        if (f3 != f2) return false;
                        return true;
                    }
                    boolean bl = Predef$.MODULE$.float2Float(f2).isNaN();
                    return bl;
                }
            }
        }
        if (tuple2 != null) {
            Object result9 = tuple2._1();
            Object expected9 = tuple2._2();
            if (result9 instanceof Row) {
                Row row = (Row)result9;
                if (expected9 instanceof InternalRow) {
                    InternalRow internalRow = (InternalRow)expected9;
                    Seq seq = row.toSeq();
                    Seq seq2 = internalRow.toSeq(row.schema());
                    if (seq != null) {
                        if (!seq.equals(seq2)) return false;
                        return true;
                    }
                    if (seq2 == null) return true;
                    return false;
                }
            }
        }
        if (!BoxesRunTime.equals((Object)result, (Object)expected)) return false;
        return true;
    }

    public static void checkExceptionInExpression(SparkFunSuite $this, Function0 expression, String expectedErrMsg, ClassTag evidence$1) {
        ((ExpressionEvalHelper)$this).checkExceptionInExpression((Function0<Expression>)expression, InternalRow$.MODULE$.empty(), expectedErrMsg, evidence$1);
    }

    public static void checkExceptionInExpression(SparkFunSuite $this, Function0 expression, InternalRow inputRow, String expectedErrMsg, ClassTag evidence$2) {
        ExpressionEvalHelper$class.checkException$1($this, (Function0)new Serializable($this, expression, inputRow){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function0 expression$2;
            private final InternalRow inputRow$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((ExpressionEvalHelper)this.$outer).evaluateWithoutCodegen(ExpressionEvalHelper$class.expr$2(this.$outer, this.expression$2), this.inputRow$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expression$2 = expression$2;
                this.inputRow$1 = inputRow$1;
            }
        }, "non-codegen mode", expectedErrMsg, evidence$2);
        ExpressionEvalHelper$class.checkException$1($this, (Function0)new Serializable($this, expression, inputRow){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function0 expression$2;
            private final InternalRow inputRow$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((ExpressionEvalHelper)this.$outer).evaluateWithGeneratedMutableProjection(ExpressionEvalHelper$class.expr$2(this.$outer, this.expression$2), this.inputRow$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expression$2 = expression$2;
                this.inputRow$1 = inputRow$1;
            }
        }, "codegen mode", expectedErrMsg, evidence$2);
        if (GenerateUnsafeProjection$.MODULE$.canSupport(ExpressionEvalHelper$class.expr$2($this, expression).dataType())) {
            ExpressionEvalHelper$class.checkException$1($this, (Function0)new Serializable($this, expression, inputRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkFunSuite $outer;
                private final Function0 expression$2;
                private final InternalRow inputRow$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ((ExpressionEvalHelper)this.$outer).evaluateWithUnsafeProjection(ExpressionEvalHelper$class.expr$2(this.$outer, this.expression$2), this.inputRow$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.expression$2 = expression$2;
                    this.inputRow$1 = inputRow$1;
                }
            }, "unsafe mode", expectedErrMsg, evidence$2);
        }
    }

    public static Object evaluateWithoutCodegen(SparkFunSuite $this, Expression expression, InternalRow inputRow) {
        expression.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Expression x0$2) {
                Expression expression = x0$2;
                if (expression instanceof Nondeterministic) {
                    Nondeterministic nondeterministic = (Nondeterministic)expression;
                    nondeterministic.initialize(0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
        return expression.eval(inputRow);
    }

    public static InternalRow evaluateWithoutCodegen$default$2(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static package.Projection generateProject(SparkFunSuite $this, Function0 generator, Expression expression) {
        try {
            return (package.Projection)generator.apply();
        }
        catch (Throwable throwable) {
            throw $this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |Code generation of ", " failed:\n            |", "\n            |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression, throwable, Utils$.MODULE$.exceptionString(throwable)})))).stripMargin(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }
    }

    public static void checkEvaluationWithoutCodegen(SparkFunSuite $this, Expression expression, Object expected, InternalRow inputRow) {
        InternalRow internalRow;
        Object actual;
        try {
            actual = ((ExpressionEvalHelper)$this).evaluateWithoutCodegen(expression, inputRow);
            if (((ExpressionEvalHelper)$this).checkResult(actual, expected, expression.dataType())) {
                return;
            }
            internalRow = inputRow;
        }
        catch (Exception exception) {
            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception evaluating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression})), (Throwable)exception, new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        }
        InternalRow internalRow2 = package$.MODULE$.EmptyRow();
        String input = !(internalRow != null ? !internalRow.equals(internalRow2) : internalRow2 != null) ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", input: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputRow}));
        throw $this.fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrect evaluation (codegen off): ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"actual: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{actual}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected: ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, input}))).toString(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }

    public static InternalRow checkEvaluationWithoutCodegen$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static void checkEvaluationWithGeneratedMutableProjection(SparkFunSuite $this, Expression expression, Object expected, InternalRow inputRow) {
        Object actual = ((ExpressionEvalHelper)$this).evaluateWithGeneratedMutableProjection(expression, inputRow);
        if (((ExpressionEvalHelper)$this).checkResult(actual, expected, expression.dataType())) {
            return;
        }
        InternalRow internalRow = inputRow;
        InternalRow internalRow2 = package$.MODULE$.EmptyRow();
        String input = !(internalRow != null ? !internalRow.equals(internalRow2) : internalRow2 != null) ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", input: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputRow}));
        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrect evaluation: ", ", actual: ", ", expected: ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression, actual, expected, input})), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
    }

    public static InternalRow checkEvaluationWithGeneratedMutableProjection$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static Object evaluateWithGeneratedMutableProjection(SparkFunSuite $this, Expression expression, InternalRow inputRow) {
        package.Projection plan = ((ExpressionEvalHelper)$this).generateProject((Function0<package.Projection>)new Serializable($this, expression){
            public static final long serialVersionUID = 0L;
            private final Expression expression$3;

            public final package.MutableProjection apply() {
                Expression x$9 = this.expression$3;
                String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$3}));
                ExprId x$11 = Alias$.MODULE$.apply$default$3(x$9, x$10);
                Seq x$12 = Alias$.MODULE$.apply$default$4(x$9, x$10);
                Option x$13 = Alias$.MODULE$.apply$default$5(x$9, x$10);
                Alias alias = new Alias(x$9, x$10, x$11, x$12, x$13);
                return (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)alias));
            }
            {
                this.expression$3 = expression$3;
            }
        }, expression);
        plan.initialize(0);
        return ((SpecializedGetters)plan.apply((Object)inputRow)).get(0, expression.dataType());
    }

    public static InternalRow evaluateWithGeneratedMutableProjection$default$2(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static void checkEvaluationWithUnsafeProjection(SparkFunSuite $this, Expression expression, Object expected, InternalRow inputRow) {
        Seq modes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{CodegenObjectFactoryMode$.MODULE$.CODEGEN_ONLY(), CodegenObjectFactoryMode$.MODULE$.NO_CODEGEN()}));
        modes.foreach((Function1)new Serializable($this, expression, expected, inputRow){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            public final Expression expression$4;
            public final Object expected$1;
            public final InternalRow inputRow$2;

            public final void apply(Enumeration.Value fallbackMode) {
                ((PlanTestBase)this.$outer).withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CODEGEN_FACTORY_MODE().key()), (Object)fallbackMode.toString())}), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExpressionEvalHelper$.anonfun.checkEvaluationWithUnsafeProjection.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        UnsafeRow expectedRow;
                        String input;
                        InternalRow unsafeRow;
                        block7: {
                            block6: {
                                block5: {
                                    unsafeRow = ((ExpressionEvalHelper)this.$outer.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer()).evaluateWithUnsafeProjection(this.$outer.expression$4, this.$outer.inputRow$2);
                                    InternalRow internalRow = this.$outer.inputRow$2;
                                    InternalRow internalRow2 = package$.MODULE$.EmptyRow();
                                    String string = !(internalRow != null ? !internalRow.equals(internalRow2) : internalRow2 != null) ? "" : (input = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", input: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputRow$2})));
                                    if (this.$outer.expected$1 != null) break block5;
                                    if (!unsafeRow.isNullAt(0)) {
                                        InternalRow expectedRow2 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expected$1, this.$outer.expected$1}));
                                        throw this.$outer.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer().fail(new StringBuilder().append((Object)"Incorrect evaluation in unsafe mode: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", actual: ", ", expected: ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expression$4, unsafeRow, expectedRow2, input}))).toString(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
                                    }
                                    break block6;
                                }
                                InternalRow lit = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expected$1, this.$outer.expected$1}));
                                expectedRow = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.$outer.expression$4.dataType(), this.$outer.expression$4.dataType()})).apply(lit);
                                InternalRow internalRow = unsafeRow;
                                UnsafeRow unsafeRow2 = expectedRow;
                                if (internalRow != null ? !internalRow.equals(unsafeRow2) : unsafeRow2 != null) break block7;
                            }
                            return;
                        }
                        throw this.$outer.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer().fail(new StringBuilder().append((Object)"Incorrect evaluation in unsafe mode: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", actual: ", ", expected: ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expression$4, unsafeRow, expectedRow, input}))).toString(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SparkFunSuite org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expression$4 = expression$4;
                this.expected$1 = expected$1;
                this.inputRow$2 = inputRow$2;
            }
        });
    }

    public static InternalRow checkEvaluationWithUnsafeProjection$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static InternalRow evaluateWithUnsafeProjection(SparkFunSuite $this, Expression expression, InternalRow inputRow) {
        package.Projection plan = ((ExpressionEvalHelper)$this).generateProject((Function0<package.Projection>)new Serializable($this, expression){
            public static final long serialVersionUID = 0L;
            private final Expression expression$5;

            public final UnsafeProjection apply() {
                Expression x$14 = this.expression$5;
                String x$15 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$5}));
                ExprId x$16 = Alias$.MODULE$.apply$default$3(x$14, x$15);
                Seq x$17 = Alias$.MODULE$.apply$default$4(x$14, x$15);
                Option x$18 = Alias$.MODULE$.apply$default$5(x$14, x$15);
                Alias alias = new Alias(x$14, x$15, x$16, x$17, x$18);
                Expression x$19 = this.expression$5;
                String x$20 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$5}));
                ExprId x$21 = Alias$.MODULE$.apply$default$3(x$19, x$20);
                Seq x$22 = Alias$.MODULE$.apply$default$4(x$19, x$20);
                Option x$23 = Alias$.MODULE$.apply$default$5(x$19, x$20);
                Alias alias2 = new Alias(x$19, x$20, x$21, x$22, x$23);
                return UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)alias2).$colon$colon((Object)alias));
            }
            {
                this.expression$5 = expression$5;
            }
        }, expression);
        plan.initialize(0);
        return (InternalRow)plan.apply((Object)inputRow);
    }

    public static InternalRow evaluateWithUnsafeProjection$default$2(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static void checkEvaluationWithOptimization(SparkFunSuite $this, Expression expression, Object expected, InternalRow inputRow) {
        Expression x$24 = expression;
        String x$25 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression}));
        ExprId x$26 = Alias$.MODULE$.apply$default$3(x$24, x$25);
        Seq x$27 = Alias$.MODULE$.apply$default$4(x$24, x$25);
        Option x$28 = Alias$.MODULE$.apply$default$5(x$24, x$25);
        Alias alias = new Alias(x$24, x$25, x$26, x$27, x$28);
        Project plan = new Project((Seq)Nil$.MODULE$.$colon$colon((Object)alias), (LogicalPlan)new OneRowRelation());
        LogicalPlan analyzedPlan = SimpleAnalyzer$.MODULE$.execute((LogicalPlan)plan);
        LogicalPlan optimizedPlan = (LogicalPlan)SimpleTestOptimizer$.MODULE$.execute((TreeNode)analyzedPlan);
        ((ExpressionEvalHelper)$this).checkEvaluationWithoutCodegen((Expression)optimizedPlan.expressions().head(), expected, inputRow);
    }

    public static InternalRow checkEvaluationWithOptimization$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static void checkDoubleEvaluation(SparkFunSuite $this, Function0 expression, TripleEqualsSupport.Spread expected, InternalRow inputRow) {
        ((ExpressionEvalHelper)$this).checkEvaluationWithoutCodegen((Expression)expression.apply(), expected, ((ExpressionEvalHelper)$this).checkEvaluationWithoutCodegen$default$3());
        ((ExpressionEvalHelper)$this).checkEvaluationWithGeneratedMutableProjection((Expression)expression.apply(), expected, ((ExpressionEvalHelper)$this).checkEvaluationWithGeneratedMutableProjection$default$3());
        ((ExpressionEvalHelper)$this).checkEvaluationWithOptimization((Expression)expression.apply(), expected, ((ExpressionEvalHelper)$this).checkEvaluationWithOptimization$default$3());
        package.Projection plan = ((ExpressionEvalHelper)$this).generateProject((Function0<package.Projection>)new Serializable($this, expression){
            public static final long serialVersionUID = 0L;
            private final Function0 expression$6;

            public final package.MutableProjection apply() {
                Expression x$29 = (Expression)this.expression$6.apply();
                String x$30 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$6.apply()}));
                ExprId x$31 = Alias$.MODULE$.apply$default$3(x$29, x$30);
                Seq x$32 = Alias$.MODULE$.apply$default$4(x$29, x$30);
                Option x$33 = Alias$.MODULE$.apply$default$5(x$29, x$30);
                Alias alias = new Alias(x$29, x$30, x$31, x$32, x$33);
                return (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)alias));
            }
            {
                this.expression$6 = expression$6;
            }
        }, (Expression)expression.apply());
        plan.initialize(0);
        Object actual = ((SpecializedGetters)plan.apply((Object)inputRow)).get(0, ((Expression)expression.apply()).dataType());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((ExpressionEvalHelper)$this).checkResult(actual, expected, ((Expression)expression.apply()).dataType()), "ExpressionEvalHelper.this.checkResult(actual, expected, expression.dataType)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        plan = ((ExpressionEvalHelper)$this).generateProject((Function0<package.Projection>)new Serializable($this, expression){
            public static final long serialVersionUID = 0L;
            private final Function0 expression$6;

            public final UnsafeProjection apply() {
                Expression x$34 = (Expression)this.expression$6.apply();
                String x$35 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$6.apply()}));
                ExprId x$36 = Alias$.MODULE$.apply$default$3(x$34, x$35);
                Seq x$37 = Alias$.MODULE$.apply$default$4(x$34, x$35);
                Option x$38 = Alias$.MODULE$.apply$default$5(x$34, x$35);
                Alias alias = new Alias(x$34, x$35, x$36, x$37, x$38);
                return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)alias));
            }
            {
                this.expression$6 = expression$6;
            }
        }, (Expression)expression.apply());
        plan.initialize(0);
        DataType dataType = ((Expression)expression.apply()).dataType();
        actual = ((SpecializedGetters)FromUnsafeProjection$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)dataType)).apply(plan.apply((Object)inputRow))).get(0, ((Expression)expression.apply()).dataType());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((ExpressionEvalHelper)$this).checkResult(actual, expected, ((Expression)expression.apply()).dataType()), "ExpressionEvalHelper.this.checkResult(actual, expected, expression.dataType)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    public static InternalRow checkDoubleEvaluation$default$3(SparkFunSuite $this) {
        return package$.MODULE$.EmptyRow();
    }

    public static void checkConsistencyBetweenInterpretedAndCodegen(SparkFunSuite $this, Function1 c, DataType dataType) {
        ((GeneratorDrivenPropertyChecks)$this).forAll(LiteralGenerator$.MODULE$.randomGen(dataType), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function1 c$1;

            public final void apply(Literal l) {
                ExpressionEvalHelper$class.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$cmpInterpretWithCodegen((SparkFunSuite)((ExpressionEvalHelper)this.$outer), package$.MODULE$.EmptyRow(), (Expression)this.c$1.apply((Object)l));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.c$1 = c$1;
            }
        }, (Configuration.PropertyCheckConfigurable)((Configuration)$this).generatorDrivenConfig(), Shrink$.MODULE$.shrinkAny(), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
    }

    public static void checkConsistencyBetweenInterpretedAndCodegen(SparkFunSuite $this, Function2 c, DataType dataType1, DataType dataType2) {
        ((GeneratorDrivenPropertyChecks)$this).forAll(LiteralGenerator$.MODULE$.randomGen(dataType1), LiteralGenerator$.MODULE$.randomGen(dataType2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function2)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function2 c$2;

            public final void apply(Literal l1, Literal l2) {
                ExpressionEvalHelper$class.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$cmpInterpretWithCodegen((SparkFunSuite)((ExpressionEvalHelper)this.$outer), package$.MODULE$.EmptyRow(), (Expression)this.c$2.apply((Object)l1, (Object)l2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.c$2 = c$2;
            }
        }, (Configuration.PropertyCheckConfigurable)((Configuration)$this).generatorDrivenConfig(), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkAny(), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
    }

    public static void checkConsistencyBetweenInterpretedAndCodegen(SparkFunSuite $this, Function3 c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ((GeneratorDrivenPropertyChecks)$this).forAll(LiteralGenerator$.MODULE$.randomGen(dataType1), LiteralGenerator$.MODULE$.randomGen(dataType2), LiteralGenerator$.MODULE$.randomGen(dataType3), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function3)new Serializable($this, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function3 c$3;

            public final void apply(Literal l1, Literal l2, Literal l3) {
                ExpressionEvalHelper$class.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$cmpInterpretWithCodegen((SparkFunSuite)((ExpressionEvalHelper)this.$outer), package$.MODULE$.EmptyRow(), (Expression)this.c$3.apply((Object)l1, (Object)l2, (Object)l3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.c$3 = c$3;
            }
        }, (Configuration.PropertyCheckConfigurable)((Configuration)$this).generatorDrivenConfig(), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkAny(), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    public static void checkConsistencyBetweenInterpretedAndCodegen(SparkFunSuite $this, Function1 c, DataType dataType, int minNumElements) {
        ((GeneratorDrivenPropertyChecks)$this).forAll(Gen$.MODULE$.listOf((Function0)new Serializable($this, dataType){
            public static final long serialVersionUID = 0L;
            private final DataType dataType$1;

            public final Gen<Literal> apply() {
                return LiteralGenerator$.MODULE$.randomGen(this.dataType$1);
            }
            {
                this.dataType$1 = dataType$1;
            }
        }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function1)new Serializable($this, c, minNumElements){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            public final Function1 c$4;
            private final int minNumElements$1;

            public final void apply(Seq<Literal> literals) {
                ((Whenever)this.$outer).whenever(literals.size() >= this.minNumElements$1, (Function0)new Serializable(this, literals){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExpressionEvalHelper$.anonfun.checkConsistencyBetweenInterpretedAndCodegen.5 $outer;
                    private final Seq literals$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ExpressionEvalHelper$class.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$cmpInterpretWithCodegen((SparkFunSuite)((ExpressionEvalHelper)this.$outer.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer()), package$.MODULE$.EmptyRow(), (Expression)this.$outer.c$4.apply((Object)this.literals$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.literals$1 = literals$1;
                    }
                }, WheneverAsserting$.MODULE$.assertingNatureOfT());
            }

            public /* synthetic */ SparkFunSuite org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.c$4 = c$4;
                this.minNumElements$1 = minNumElements$1;
            }
        }, (Configuration.PropertyCheckConfigurable)((Configuration)$this).generatorDrivenConfig(), Shrink$.MODULE$.shrinkContainer((Function1)Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableCanBuildFrom(List$.MODULE$.canBuildFrom())), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
    }

    public static int checkConsistencyBetweenInterpretedAndCodegen$default$3(SparkFunSuite $this) {
        return 0;
    }

    public static void org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$cmpInterpretWithCodegen(SparkFunSuite $this, InternalRow inputRow, Expression expr) {
        package.Projection plan;
        Object interpret;
        try {
            interpret = ((ExpressionEvalHelper)$this).evaluateWithoutCodegen(expr, inputRow);
            plan = ((ExpressionEvalHelper)$this).generateProject((Function0<package.Projection>)new Serializable($this, expr){
                public static final long serialVersionUID = 0L;
                private final Expression expr$3;

                public final package.MutableProjection apply() {
                    Expression x$39 = this.expr$3;
                    String x$40 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimized(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expr$3}));
                    ExprId x$41 = Alias$.MODULE$.apply$default$3(x$39, x$40);
                    Seq x$42 = Alias$.MODULE$.apply$default$4(x$39, x$40);
                    Option x$43 = Alias$.MODULE$.apply$default$5(x$39, x$40);
                    Alias alias = new Alias(x$39, x$40, x$41, x$42, x$43);
                    return (package.MutableProjection)GenerateMutableProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)alias));
                }
                {
                    this.expr$3 = expr$3;
                }
            }, expr);
        }
        catch (Exception exception) {
            throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception evaluating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr})), (Throwable)exception, new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }
        Object codegen = ((SpecializedGetters)plan.apply((Object)inputRow)).get(0, expr.dataType());
        if (ExpressionEvalHelper$class.org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$compareResults((SparkFunSuite)((ExpressionEvalHelper)$this), interpret, codegen)) {
            return;
        }
        throw $this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrect evaluation: ", ", interpret: ", ", codegen: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr, interpret, codegen})), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean org$apache$spark$sql$catalyst$expressions$ExpressionEvalHelper$$compareResults(SparkFunSuite $this, Object result, Object expected) {
        Tuple2 tuple2 = new Tuple2(result, expected);
        if (tuple2 != null) {
            Object result2 = tuple2._1();
            Object expected2 = tuple2._2();
            if (result2 instanceof byte[]) {
                byte[] byArray = (byte[])result2;
                if (expected2 instanceof byte[]) {
                    byte[] byArray2 = (byte[])expected2;
                    return Arrays.equals(byArray, byArray2);
                }
            }
        }
        if (tuple2 != null) {
            Object result3 = tuple2._1();
            Object expected3 = tuple2._2();
            if (result3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)result3);
                if (expected3 instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)expected3);
                    if (Predef$.MODULE$.double2Double(d).isNaN() && Predef$.MODULE$.double2Double(d2).isNaN()) {
                        return true;
                    }
                }
            }
        }
        if (tuple2 != null) {
            Object result4 = tuple2._1();
            Object expected4 = tuple2._2();
            if (result4 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)result4);
                if (expected4 instanceof Double) {
                    double d3 = BoxesRunTime.unboxToDouble((Object)expected4);
                    return ExpressionEvalHelper$class.relativeErrorComparison((SparkFunSuite)((ExpressionEvalHelper)$this), d, d3, ExpressionEvalHelper$class.relativeErrorComparison$default$3((SparkFunSuite)((ExpressionEvalHelper)$this)));
                }
            }
        }
        if (tuple2 != null) {
            Object result5 = tuple2._1();
            Object expected5 = tuple2._2();
            if (result5 instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)result5);
                if (expected5 instanceof Float) {
                    float f3 = BoxesRunTime.unboxToFloat((Object)expected5);
                    if (Predef$.MODULE$.float2Float(f2).isNaN() && Predef$.MODULE$.float2Float(f3).isNaN()) {
                        return true;
                    }
                }
            }
        }
        if (!BoxesRunTime.equals((Object)result, (Object)expected)) return false;
        return true;
    }

    private static boolean relativeErrorComparison(SparkFunSuite $this, double x, double y, double eps) {
        boolean bl;
        double absX = scala.math.package$.MODULE$.abs(x);
        double absY = scala.math.package$.MODULE$.abs(y);
        double diff = scala.math.package$.MODULE$.abs(x - y);
        if (x == y) {
            bl = true;
        } else {
            if (absX < Double.MIN_VALUE || absY < Double.MIN_VALUE) {
                throw new TestFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " or ", " is extremely close to zero, so the relative tolerance is meaningless."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)})), 0);
            }
            bl = diff < eps * scala.math.package$.MODULE$.min(absX, absY);
        }
        return bl;
    }

    private static double relativeErrorComparison$default$3(SparkFunSuite $this) {
        return 1.0E-8;
    }

    private static final Expression expr$1(SparkFunSuite $this, Function0 expression$1) {
        return ExpressionEvalHelper$class.prepareEvaluation((SparkFunSuite)((ExpressionEvalHelper)$this), (Expression)expression$1.apply());
    }

    private static final void checkException$1(SparkFunSuite $this, Function0 eval, String testMode2, String expectedErrMsg$1, ClassTag evidence$2$1) {
        $this.withClue((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testMode2})), (Function0)new Serializable($this, eval, expectedErrMsg$1, evidence$2$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkFunSuite $outer;
            private final Function0 eval$1;
            private final String expectedErrMsg$1;
            private final ClassTag evidence$2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String errMsg = ((Throwable)this.$outer.intercept(this.eval$1, this.evidence$2$1, new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127))).getMessage();
                if (errMsg.contains(this.expectedErrMsg$1)) {
                    return;
                }
                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected error message is `", "`, but `", "` found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expectedErrMsg$1, errMsg})), new Position("ExpressionEvalHelper.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.eval$1 = eval$1;
                this.expectedErrMsg$1 = expectedErrMsg$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public static final Expression expr$2(SparkFunSuite $this, Function0 expression$2) {
        return ExpressionEvalHelper$class.prepareEvaluation((SparkFunSuite)((ExpressionEvalHelper)$this), (Expression)expression$2.apply());
    }

    public static void $init$(SparkFunSuite $this) {
    }
}

