/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Random;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.Assert;
import org.junit.Test;

public class HiveHasherSuite {
    @Test
    public void testKnownIntegerInputs() {
        int[] inputs;
        for (int input : inputs = new int[]{0, Integer.MIN_VALUE, Integer.MAX_VALUE, 593689054, -189366624}) {
            Assert.assertEquals((long)input, (long)HiveHasher.hashInt((int)input));
        }
    }

    @Test
    public void testKnownLongInputs() {
        Assert.assertEquals((long)0L, (long)HiveHasher.hashLong((long)0L));
        Assert.assertEquals((long)41L, (long)HiveHasher.hashLong((long)-42L));
        Assert.assertEquals((long)42L, (long)HiveHasher.hashLong((long)42L));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)HiveHasher.hashLong((long)Long.MIN_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)HiveHasher.hashLong((long)Long.MAX_VALUE));
    }

    @Test
    public void testKnownStringAndIntInputs() {
        int[] inputs = new int[]{84, 19, 8};
        int[] expected = new int[]{-823832826, -823835053, 111972242};
        for (int i = 0; i < inputs.length; ++i) {
            UTF8String s = UTF8String.fromString((String)("val_" + inputs[i]));
            int hash = HiveHasher.hashUnsafeBytes((Object)s.getBaseObject(), (long)s.getBaseOffset(), (int)s.numBytes());
            Assert.assertEquals((long)expected[i], (long)(31 * inputs[i] + hash));
        }
    }

    @Test
    public void randomizedStressTest() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int vint = rand.nextInt();
            long lint = rand.nextLong();
            Assert.assertEquals((long)HiveHasher.hashInt((int)vint), (long)HiveHasher.hashInt((int)vint));
            Assert.assertEquals((long)HiveHasher.hashLong((long)lint), (long)HiveHasher.hashLong((long)lint));
            hashcodes.add(HiveHasher.hashLong((long)lint));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestBytes() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = rand.nextInt(100) * 8;
            byte[] bytes = new byte[byteArrSize];
            rand.nextBytes(bytes);
            Assert.assertEquals((long)HiveHasher.hashUnsafeBytes((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize), (long)HiveHasher.hashUnsafeBytes((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize));
            hashcodes.add(HiveHasher.hashUnsafeBytes((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestPaddedStrings() {
        int size = 64000;
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = 8;
            byte[] strBytes = String.valueOf(i).getBytes(StandardCharsets.UTF_8);
            byte[] paddedBytes = new byte[byteArrSize];
            System.arraycopy(strBytes, 0, paddedBytes, 0, strBytes.length);
            Assert.assertEquals((long)HiveHasher.hashUnsafeBytes((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize), (long)HiveHasher.hashUnsafeBytes((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize));
            hashcodes.add(HiveHasher.hashUnsafeBytes((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (int)byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }
}

