/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EmptyFunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentDate$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.optimizer.EliminateSortsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase$class;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001f\t\u0019R\t\\5nS:\fG/Z*peR\u001c8+^5uK*\u00111\u0001B\u0001\n_B$\u0018.\\5{KJT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tQ\u0001\u001d7b]NL!!\u0007\f\u0003\u0011Ac\u0017M\u001c+fgRDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C!C\u0005!1m\u001c8g+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0014%\u0005\u001d\u0019\u0016\u000bT\"p]\u001aDa!\u000b\u0001!\u0002\u0013\u0011\u0013!B2p]\u001a\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\bG\u0006$\u0018\r\\8h+\u0005i\u0003C\u0001\u00181\u001b\u0005y#BA\u0016\u0005\u0013\t\ttF\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\t\rM\u0002\u0001\u0015!\u0003.\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0003bB\u001b\u0001\u0005\u0004%\tAN\u0001\tC:\fG.\u001f>feV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;\t\u0005A\u0011M\\1msNL7/\u0003\u0002=s\tA\u0011I\\1msj,'\u000f\u0003\u0004?\u0001\u0001\u0006IaN\u0001\nC:\fG.\u001f>fe\u0002:Q\u0001\u0011\u0001\t\u0002\u0005\u000b\u0001b\u00149uS6L'0\u001a\t\u0003\u0005\u000ek\u0011\u0001\u0001\u0004\u0006\t\u0002A\t!\u0012\u0002\t\u001fB$\u0018.\\5{KN\u00111I\u0012\t\u0004\u000f*cU\"\u0001%\u000b\u0005%#\u0011!\u0002:vY\u0016\u001c\u0018BA&I\u00051\u0011V\u000f\\3Fq\u0016\u001cW\u000f^8s!\ti\u0005+D\u0001O\u0015\tye#A\u0004m_\u001eL7-\u00197\n\u0005Es%a\u0003'pO&\u001c\u0017\r\u001c)mC:DQaG\"\u0005\u0002M#\u0012!\u0011\u0005\b+\u000e\u0013\r\u0011\"\u0001W\u0003\u001d\u0011\u0017\r^2iKN,\u0012a\u0016\t\u00041~\u000bW\"A-\u000b\u0005i[\u0016!C5n[V$\u0018M\u00197f\u0015\taV,\u0001\u0006d_2dWm\u0019;j_:T\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Af\u0013A\u0001T5tiB\u0011!mY\u0007\u0002\u0007&\u0011AM\u0013\u0002\u0006\u0005\u0006$8\r\u001b\u0005\u0007M\u000e\u0003\u000b\u0011B,\u0002\u0011\t\fGo\u00195fg\u0002Bq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011.\u0001\u0007uKN$(+\u001a7bi&|g.F\u0001k!\ti5.\u0003\u0002m\u001d\niAj\\2bYJ+G.\u0019;j_:DaA\u001c\u0001!\u0002\u0013Q\u0017!\u0004;fgR\u0014V\r\\1uS>t\u0007\u0005")
public class EliminateSortsSuite
extends SparkFunSuite
implements PlanTest {
    private final SQLConf conf;
    private final SessionCatalog catalog;
    private final Analyzer analyzer;
    private final LocalRelation testRelation;
    private volatile EliminateSortsSuite$Optimize$ Optimize$module;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EliminateSortsSuite$Optimize$ Optimize$lzycompute() {
        EliminateSortsSuite eliminateSortsSuite = this;
        synchronized (eliminateSortsSuite) {
            if (this.Optimize$module != null) return this.Optimize$module;
            this.Optimize$module = new EliminateSortsSuite$Optimize$(this);
            return this.Optimize$module;
        }
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase$class.normalizeExprIds(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase$class.normalizePlan(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase$class.comparePlans(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase$class.compareExpressions(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase$class.compareJoinOrder(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f2) {
        PlanTestBase$class.withSQLConf(this, pairs, f2);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase$class.comparePlans$default$3(this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public SQLConf conf() {
        return this.conf;
    }

    public SessionCatalog catalog() {
        return this.catalog;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public EliminateSortsSuite$Optimize$ Optimize() {
        return this.Optimize$module == null ? this.Optimize$lzycompute() : this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public EliminateSortsSuite() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        PlanTestBase$class.$init$(this);
        this.conf = new SQLConf().copy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE()), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORDER_BY_ORDINAL()), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        this.catalog = new SessionCatalog((ExternalCatalog)new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2()), (FunctionRegistry)EmptyFunctionRegistry$.MODULE$, this.conf());
        this.analyzer = new Analyzer(this.catalog(), this.conf());
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol(symbol$1).int(), package.expressions$.MODULE$.DslSymbol(symbol$2).int(), package.expressions$.MODULE$.DslSymbol(symbol$3).int()}));
        this.test("Empty order by clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalRelation x = this.$outer.testRelation();
                LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Nil$.MODULE$);
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("All the SortOrder are no-op", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalRelation x = this.$outer.testRelation();
                LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(3), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(-1), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)this.$outer.analyzer().execute(query));
                LogicalPlan correctAnswer = this.$outer.analyzer().execute((LogicalPlan)x);
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Partial order-by clauses contain no-op SortOrder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;
            private static Symbol symbol$4;

            static {
                symbol$4 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalRelation x = this.$outer.testRelation();
                LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{SortOrder$.MODULE$.apply((Expression)package.expressions$.MODULE$.intToLiteral(3), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), package.expressions$.MODULE$.DslSymbol(symbol$4).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)this.$outer.analyzer().execute(query));
                LogicalPlan correctAnswer = this.$outer.analyzer().execute(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$4).asc()})));
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Remove no-op alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;
            private static Symbol symbol$5;
            private static Symbol symbol$6;
            private static Symbol symbol$7;
            private static Symbol symbol$8;

            static {
                symbol$5 = Symbol$.MODULE$.apply("a");
                symbol$6 = Symbol$.MODULE$.apply("x");
                symbol$7 = Symbol$.MODULE$.apply("y");
                symbol$8 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalRelation x = this.$outer.testRelation();
                LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).as(symbol$6), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()))).as(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)this.$outer.analyzer().execute(query));
                LogicalPlan correctAnswer = this.$outer.analyzer().execute(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)x).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).as(symbol$6), (Expression)package.expressions$.MODULE$.DslExpression((Expression)new Year((Expression)new CurrentDate(CurrentDate$.MODULE$.apply$default$1()))).as(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).desc()})));
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("SPARK-32318: should not remove orderBy in distribute statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;
            private static Symbol symbol$9;
            private static Symbol symbol$10;

            static {
                symbol$9 = Symbol$.MODULE$.apply("a");
                symbol$10 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)}));
                LogicalPlan orderByPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$10).desc()}));
                LogicalPlan distributedPlan = package.plans$.MODULE$.DslLogicalPlan(orderByPlan).distribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)}), 1);
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(distributedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(distributedPlan).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("SPARK-33183: remove consecutive no-op sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EliminateSortsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Nil$.MODULE$)).orderBy((Seq)Nil$.MODULE$)).orderBy((Seq)Nil$.MODULE$);
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(plan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("EliminateSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }
}

