/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST')\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY')\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query')\n       1\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t%u!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0003)beN,WK\u001d7\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011\u0001\u0002U1sg\u0016,&\u000f\\\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=Aq!I\tC\u0002\u0013%!%\u0001\u0003I\u001fN#V#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!\u0002;za\u0016\u001c(B\u0001\u0015\t\u0003\u0019)hn]1gK&\u0011!&\n\u0002\u000b+R3\u0005h\u0015;sS:<\u0007B\u0002\u0017\u0012A\u0003%1%A\u0003I\u001fN#\u0006\u0005C\u0004/#\t\u0007I\u0011\u0002\u0012\u0002\tA\u000bE\u000b\u0013\u0005\u0007aE\u0001\u000b\u0011B\u0012\u0002\u000bA\u000bE\u000b\u0013\u0011\t\u000fI\n\"\u0019!C\u0005E\u0005)\u0011+V#S3\"1A'\u0005Q\u0001\n\r\na!U+F%f\u0003\u0003b\u0002\u001c\u0012\u0005\u0004%IAI\u0001\u0004%\u00163\u0005B\u0002\u001d\u0012A\u0003%1%\u0001\u0003S\u000b\u001a\u0003\u0003b\u0002\u001e\u0012\u0005\u0004%IAI\u0001\t!J{EkT\"P\u0019\"1A(\u0005Q\u0001\n\r\n\u0011\u0002\u0015*P)>\u001bu\n\u0014\u0011\t\u000fy\n\"\u0019!C\u0005E\u0005!a)\u0013'F\u0011\u0019\u0001\u0015\u0003)A\u0005G\u0005)a)\u0013'FA!9!)\u0005b\u0001\n\u0013\u0011\u0013!C!V)\"{%+\u0013+Z\u0011\u0019!\u0015\u0003)A\u0005G\u0005Q\u0011)\u0016+I\u001fJKE+\u0017\u0011\t\u000f\u0019\u000b\"\u0019!C\u0005E\u0005AQkU#S\u0013:3u\n\u0003\u0004I#\u0001\u0006IaI\u0001\n+N+%+\u0013(G\u001f\u0002BqAS\tC\u0002\u0013%1*A\u0006S\u000b\u001e+\u0005\f\u0015*F\r&CV#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001\u00027b]\u001eT\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n11\u000b\u001e:j]\u001eDa!V\t!\u0002\u0013a\u0015\u0001\u0004*F\u000f\u0016C\u0006KU#G\u0013b\u0003\u0003bB,\u0012\u0005\u0004%IaS\u0001\f%\u0016;U\tW*V\u0005\u001aK\u0005\f\u0003\u0004Z#\u0001\u0006I\u0001T\u0001\r%\u0016;U\tW*V\u0005\u001aK\u0005\f\t\u0005\b7F\t\t\u0011\"!]\u0003\u0015\t\u0007\u000f\u001d7z)\ri&1\u000e\t\u0003!y3AA\u0005\u0002A?N1a\fY2gYj\u0001\"\u0001E1\n\u0005\t\u0014!AC#yaJ,7o]5p]B\u0011\u0001\u0003Z\u0005\u0003K\n\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t9'.D\u0001i\u0015\tI'!A\u0004d_\u0012,w-\u001a8\n\u0005-D'aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005Ui\u0017B\u00018\u0017\u0005\u001d\u0001&o\u001c3vGRD\u0001\u0002\u001d0\u0003\u0016\u0004%\t!]\u0001\tG\"LG\u000e\u001a:f]V\t!\u000fE\u0002tw\u0002t!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]t\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\tQh#A\u0004qC\u000e\\\u0017mZ3\n\u0005ql(aA*fc*\u0011!P\u0006\u0005\t\u007fz\u0013\t\u0012)A\u0005e\u0006I1\r[5mIJ,g\u000e\t\u0005\u0007=y#\t!a\u0001\u0015\u0007u\u000b)\u0001\u0003\u0004q\u0003\u0003\u0001\rA\u001d\u0005\b\u0003\u0013qF\u0011IA\u0006\u0003!qW\u000f\u001c7bE2,WCAA\u0007!\r)\u0012qB\u0005\u0004\u0003#1\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003+qF\u0011IA\f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u00033\u0001Ba]>\u0002\u001cA!\u0011QDA\u0011\u001b\t\tyB\u0003\u0002'\r%!\u00111EA\u0010\u0005!!\u0015\r^1UsB,\u0007bBA\u0014=\u0012\u0005\u0013\u0011F\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0004\u0005\b\u0003[qF\u0011IA\u0018\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003c\u0001B!a\r\u0002:9\u0019Q#!\u000e\n\u0007\u0005]b#\u0001\u0004Qe\u0016$WMZ\u0005\u0004'\u0006m\"bAA\u001c-!Q\u0011q\b0\t\u0006\u0004%I!!\u0011\u0002\u0013\r\f7\r[3e+JdWCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%!\u0006\u0019a.\u001a;\n\t\u00055\u0013q\t\u0002\u0004+JK\u0005BCA)=\"\u0005\t\u0015)\u0003\u0002D\u0005Q1-Y2iK\u0012,&\u000f\u001c\u0011)\t\u0005=\u0013Q\u000b\t\u0004+\u0005]\u0013bAA--\tIAO]1og&,g\u000e\u001e\u0005\u000b\u0003;r\u0006R1A\u0005\n\u0005}\u0013!D2bG\",G\rU1ui\u0016\u0014h.\u0006\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!\u0002:fO\u0016D(bAA6!\u0006!Q\u000f^5m\u0013\u0011\ty'!\u001a\u0003\u000fA\u000bG\u000f^3s]\"Q\u00111\u000f0\t\u0002\u0003\u0006K!!\u0019\u0002\u001d\r\f7\r[3e!\u0006$H/\u001a:oA!\"\u0011\u0011OA+\u0011)\tIH\u0018EC\u0002\u0013%\u00111P\u0001\u0016G\u0006\u001c\u0007.\u001a3FqR\u0014\u0018m\u0019;QCJ$h)\u001e8d+\t\ti\bE\u0004\u0016\u0003\u007f\n\u0019%!\r\n\u0007\u0005\u0005eCA\u0005Gk:\u001cG/[8oc!Q\u0011Q\u00110\t\u0002\u0003\u0006K!! \u0002-\r\f7\r[3e\u000bb$(/Y2u!\u0006\u0014HOR;oG\u0002BC!a!\u0002V!9\u00111\u00120\u0005B\u00055\u0015aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAAH!\u0011\t\t*a&\u000e\u0005\u0005M%bAAK\t\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u001a\u0006M%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000f\u0005ue\f\"\u0003\u0002 \u0006Qq-\u001a;QCR$XM\u001d8\u0015\t\u0005\u0005\u0014\u0011\u0015\u0005\b\u0003G\u000bY\n1\u0001$\u0003\rYW-\u001f\u0005\b\u0003OsF\u0011BAU\u0003\u00199W\r^+sYR!\u00111IAV\u0011\u001d\ti+!*A\u0002\r\n1!\u001e:m\u0011\u001d\t\tL\u0018C\u0005\u0003g\u000b!cZ3u\u000bb$(/Y2u!\u0006\u0014HOR;oGR!\u0011QPA[\u0011\u001d\t9,a,A\u0002\r\nQ\u0002]1siR{W\t\u001f;sC\u000e$\bbBA^=\u0012%\u0011QX\u0001\u0016Kb$(/Y2u-\u0006dW/\u001a$s_6\fV/\u001a:z)\u0015\u0019\u0013qXAb\u0011\u001d\t\t-!/A\u0002\r\nQ!];fefD\u0001\"!2\u0002:\u0002\u0007\u0011\u0011M\u0001\ba\u0006$H/\u001a:o\u0011\u001d\tIM\u0018C\u0005\u0003\u0017\fa\"\u001a=ue\u0006\u001cGO\u0012:p[V\u0013H\u000eF\u0003$\u0003\u001b\fy\r\u0003\u0005\u0002.\u0006\u001d\u0007\u0019AA\"\u0011\u001d\t9,a2A\u0002\rBq!a5_\t\u0013\t).\u0001\nqCJ\u001cX-\u0016:m/&$\bn\\;u\u0017\u0016LH#B\u0012\u0002X\u0006e\u0007bBAW\u0003#\u0004\ra\t\u0005\b\u0003o\u000b\t\u000e1\u0001$\u0011\u001d\tiN\u0018C!\u0003?\fA!\u001a<bYR!\u0011\u0011]At!\r)\u00121]\u0005\u0004\u0003K4\"aA!os\"Q\u0011\u0011^An!\u0003\u0005\r!a;\u0002\u000b%t\u0007/\u001e;\u0011\t\u00055\u0018q^\u0007\u0002\t%\u0019\u0011\u0011\u001f\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\n\u0003kt\u0016\u0011!C\u0001\u0003o\fAaY8qsR\u0019Q,!?\t\u0011A\f\u0019\u0010%AA\u0002ID\u0011\"!@_#\u0003%\t!a@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0001\u0016\u0004e\n\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=a#\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\t]a,!A\u0005B-\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\"\u0003B\u000e=\u0006\u0005I\u0011\u0001B\u000f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\u0002E\u0002\u0016\u0005CI1Aa\t\u0017\u0005\rIe\u000e\u001e\u0005\n\u0005Oq\u0016\u0011!C\u0001\u0005S\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002b\n-\u0002B\u0003B\u0017\u0005K\t\t\u00111\u0001\u0003 \u0005\u0019\u0001\u0010J\u0019\t\u0013\tEb,!A\u0005B\tM\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\u0002C\u0002B\u001c\u0005{\t\t/\u0004\u0002\u0003:)\u0019!1\b\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003@\te\"\u0001C%uKJ\fGo\u001c:\t\u0013\t\rc,!A\u0005\u0002\t\u0015\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055!q\t\u0005\u000b\u0005[\u0011\t%!AA\u0002\u0005\u0005\b\"\u0003B&=\u0006\u0005I\u0011\tB'\u0003\u0019)\u0017/^1mgR!\u0011Q\u0002B(\u0011)\u0011iC!\u0013\u0002\u0002\u0003\u0007\u0011\u0011\u001d\u0015\u0010=\nM#\u0011\fB.\u0005?\u0012\tG!\u001a\u0003hA\u0019\u0001C!\u0016\n\u0007\t]#AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tu\u0013aP0G+:\u001bu\fK;sY2\u0002\u0003/\u0019:u)>,\u0005\u0010\u001e:bGR\\F\u0006I6fsvK\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA\u0019\u0014x.\u001c\u0011bAU\u0013FJL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1M\u0001\u0003>)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u001b;uajzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40a\u0006$\bnP9vKJLX(M\u0014-A\u001dBuj\u0015+(S)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(QR$\bOO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|\u0003/\u0019;i\u007fE,XM]=>c\u001db\u0003eJ)V\u000bJKv%\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011rk\u0016\u0014\u00180P\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dBG\u000f\u001e9;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f9bi\"|\u0014/^3ssv\nt\u0005\f\u0011(#V+%+W\u0014-A\u001d\nX/\u001a:zO%R\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011I'A\u00033]Ar\u0003\u0007C\u0003q5\u0002\u0007!\u000fC\u0005\u0003pE\t\t\u0011\"!\u0003r\u00059QO\\1qa2LH\u0003\u0002B:\u0005s\u0002B!\u0006B;e&\u0019!q\u000f\f\u0003\r=\u0003H/[8o\u0011%\u0011YH!\u001c\u0002\u0002\u0003\u0007Q,A\u0002yIAB\u0011Ba \u0012\u0003\u0003%IA!!\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u00032!\u0014BC\u0013\r\u00119I\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
Serializable {
    private final Seq<Expression> children;
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(ParseUrl parseUrl) {
        return ParseUrl$.MODULE$.unapply(parseUrl);
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                URI uRI = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.cachedUrl = uRI;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.cachedUrl;
        }
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                Pattern pattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.cachedPattern = pattern;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.cachedPattern;
        }
    }

    private Function1 cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.cachedExtractPartFunc;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StringType$ apply() {
                return StringType$.MODULE$;
            }
        });
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.cachedUrl$lzycompute() : this.cachedUrl;
    }

    private Pattern cachedPattern() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cachedPattern$lzycompute() : this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.cachedExtractPartFunc$lzycompute() : this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() > 3 || this.children().size() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " function requires two or three arguments"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))) : ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder().append((Object)ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append((Object)key.toString()).append((Object)ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        Object object;
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            object = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(URI x$48) {
                    return x$48.getHost();
                }
            };
        } else {
            UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
            UTF8String uTF8String5 = uTF8String;
            if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(URI x$49) {
                        return x$49.getRawPath();
                    }
                };
            } else {
                UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                UTF8String uTF8String7 = uTF8String;
                if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(URI x$50) {
                            return x$50.getRawQuery();
                        }
                    };
                } else {
                    UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
                    UTF8String uTF8String9 = uTF8String;
                    if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
                        object = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(URI x$51) {
                                return x$51.getRawFragment();
                            }
                        };
                    } else {
                        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
                        UTF8String uTF8String11 = uTF8String;
                        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(URI x$52) {
                                    return x$52.getScheme();
                                }
                            };
                        } else {
                            UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
                            UTF8String uTF8String13 = uTF8String;
                            if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
                                object = new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(URI url) {
                                        return url.getRawQuery() != null ? new StringBuilder().append((Object)url.getRawPath()).append((Object)"?").append((Object)url.getRawQuery()).toString() : url.getRawPath();
                                    }
                                };
                            } else {
                                UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
                                UTF8String uTF8String15 = uTF8String;
                                if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
                                    object = new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(URI x$53) {
                                            return x$53.getRawAuthority();
                                        }
                                    };
                                } else {
                                    UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
                                    UTF8String uTF8String17 = uTF8String;
                                    object = !(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null) ? new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(URI x$54) {
                                            return x$54.getRawUserInfo();
                                        }
                                    } : new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Null$ apply(URI url) {
                                            return null;
                                        }
                                    };
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    private UTF8String extractValueFromQuery(UTF8String query2, Pattern pattern) {
        Matcher m = pattern.matcher(query2.toString());
        return m.find() ? UTF8String.fromString((String)m.group(2)) : null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        return this.cachedExtractPartFunc() != null ? UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url))) : UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        URI currentUrl;
        return this.cachedUrl() != null ? this.extractFromUrl(this.cachedUrl(), partToExtract) : ((currentUrl = this.getUrl(url)) != null ? this.extractFromUrl(currentUrl, partToExtract) : null);
    }

    @Override
    public Object eval(InternalRow input) {
        block7: {
            UTF8String uTF8String;
            block6: {
                Seq evaluated;
                block5: {
                    evaluated = (Seq)this.children().map((Function1)new Serializable(this, input){
                        public static final long serialVersionUID = 0L;
                        private final InternalRow input$2;

                        public final UTF8String apply(Expression e) {
                            return (UTF8String)e.eval(this.input$2);
                        }
                        {
                            this.input$2 = input$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    if (evaluated.contains(null)) {
                        return null;
                    }
                    if (evaluated.size() != 2) break block5;
                    uTF8String = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
                    break block6;
                }
                Predef$.MODULE$.assert(evaluated.size() == 3);
                Object object = evaluated.apply(1);
                UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
                if (object != null ? !object.equals(uTF8String2) : uTF8String2 != null) break block7;
                UTF8String query2 = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
                if (query2 == null) {
                    return null;
                }
                uTF8String = this.cachedPattern() != null ? this.extractValueFromQuery(query2, this.cachedPattern()) : this.extractValueFromQuery(query2, this.getPattern((UTF8String)evaluated.apply(2)));
            }
            return uTF8String;
        }
        return null;
    }

    public ParseUrl copy(Seq<Expression> children2) {
        return new ParseUrl(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2) {
        this.children = children2;
        ExpectsInputTypes$class.$init$(this);
        CodegenFallback$class.$init$(this);
    }
}

