/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.InterpretedOrdering;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TypeUtils$ {
    public static TypeUtils$ MODULE$;

    static {
        new TypeUtils$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeCheckResult checkForNumericExpr(DataType dt, String caller) {
        TypeCheckResult typeCheckResult;
        block3: {
            block2: {
                if (dt instanceof NumericType) break block2;
                DataType dataType = dt;
                NullType$ nullType$ = NullType$.MODULE$;
                if (dataType != null ? !dataType.equals(nullType$) : nullType$ != null) break block3;
            }
            typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            return typeCheckResult;
        }
        typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(29).append(caller).append(" requires numeric types, not ").append(dt.catalogString()).toString());
        return typeCheckResult;
    }

    public TypeCheckResult checkForOrderingExpr(DataType dt, String caller) {
        return RowOrdering$.MODULE$.isOrderable(dt) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(35).append(caller).append(" does not support ordering on type ").append(dt.catalogString()).toString());
    }

    public TypeCheckResult checkForSameTypeInputExpr(Seq<DataType> types, String caller) {
        if (!TypeCoercion$.MODULE$.haveSameType(types)) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append("input to ").append(caller).append(" should all be the same type, but it's ").append(((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.catalogString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString());
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public Numeric<Object> getNumeric(DataType t) {
        return ((NumericType)t).numeric();
    }

    public Ordering<Object> getInterpretedOrdering(DataType t) {
        InterpretedOrdering interpretedOrdering;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = t) instanceof AtomicType) {
                    AtomicType atomicType = (AtomicType)dataType;
                    interpretedOrdering = atomicType.ordering();
                    break block4;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    interpretedOrdering = arrayType.interpretedOrdering();
                    break block4;
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    interpretedOrdering = structType.interpretedOrdering();
                    break block4;
                }
                if (!(dataType instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                t = userDefinedType.sqlType();
            }
            throw new MatchError((Object)dataType);
        }
        return interpretedOrdering;
    }

    public int compareBinary(byte[] x, byte[] y) {
        int n;
        Object object = new Object();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), x.length).withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> i < y.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                int v1 = x[i] & 0xFF;
                int v2 = y[i] & 0xFF;
                int res = v1 - v2;
                if (res != 0) {
                    throw new NonLocalReturnControl.mcI.sp(object, res);
                }
            });
            n = x.length - y.length;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public boolean typeWithProperEquals(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BinaryType$.MODULE$.equals(dataType2) ? false : dataType2 instanceof AtomicType;
        return bl;
    }

    private TypeUtils$() {
        MODULE$ = this;
    }
}

