/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015a\u0007\u0001\"\u0003M\u0011!i\u0007\u0001#b\u0001\n\u0013q\u0007\"B=\u0001\t\u0003R\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"a\u0019\u0001#\u0003%\t!!\u0014\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001d\u0004\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\t\t\tAA\u0001\n\u0003\t\u0019\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003O;\u0011\"!2!\u0003\u0003E\t!a2\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003\u0013DaAR\r\u0005\u0002\u0005]\u0007\"CAm3\u0005\u0005IQIAn\u0011%\ti.GA\u0001\n\u0003\u000by\u000eC\u0005\u0002ff\t\t\u0011\"!\u0002h\"I\u0011\u0011`\r\u0002\u0002\u0013%\u00111 \u0002\f\u0003J\u0014\u0018-\u001f*f[>4XM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0015\u0001aFM\u001b<!\ty\u0003'D\u0001!\u0013\t\t\u0004E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011qfM\u0005\u0003i\u0001\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\t1D(\u0003\u0002>o\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\u0001\u0005CA\u0018B\u0013\t\u0011\u0005E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002I\u0013*\u0003\"a\f\u0001\t\u000by*\u0001\u0019\u0001!\t\u000b\u0011+\u0001\u0019\u0001!\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\nQ\u0001^=qKNL!AU(\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0006c\u0001,_C:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u000352\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005u;\u0014a\u00029bG.\fw-Z\u0005\u0003?\u0002\u00141aU3r\u0015\tiv\u0007\u0005\u0002OE&\u00111m\u0014\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\n\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003W\"\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\fK2,W.\u001a8u)f\u0004X-\u0001\u0005pe\u0012,'/\u001b8h+\u0005y\u0007c\u0001,qe&\u0011\u0011\u000f\u0019\u0002\t\u001fJ$WM]5oOB\u0011ag]\u0005\u0003i^\u00121!\u00118zQ\tQa\u000f\u0005\u00027o&\u0011\u0001p\u000e\u0002\niJ\fgn]5f]R\fAB\\;mYN\u000bg-Z#wC2$2A]>~\u0011\u0015a8\u00021\u0001s\u0003\r\t'O\u001d\u0005\u0006}.\u0001\rA]\u0001\u0006m\u0006dW/Z\u0001\nI><UM\\\"pI\u0016$b!a\u0001\u0002\u0010\u0005e\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0001%A\u0004d_\u0012,w-\u001a8\n\t\u00055\u0011q\u0001\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\u0003\u0007A\u0002\u0005M\u0011aA2uqB!\u0011QAA\u000b\u0013\u0011\t9\"a\u0002\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\u0004\u0007A\u0002\u0005\r\u0011AA3w\u0003A9WM\\\"pI\u00164uN\u001d*fgVdG\u000f\u0006\u0007\u0002\"\u0005E\u00121GA\u001b\u0003s\tY\u0004\u0005\u0003\u0002$\u0005-b\u0002BA\u0013\u0003O\u0001\"\u0001W\u001c\n\u0007\u0005%r'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S9\u0004bBA\t\u001b\u0001\u0007\u00111\u0003\u0005\b\u00037i\u0001\u0019AA\u0002\u0011\u001d\t9$\u0004a\u0001\u0003C\t!\"\u001b8qkR\f%O]1z\u0011\u0019qX\u00021\u0001\u0002\"!9\u0011QH\u0007A\u0002\u0005\u0005\u0012\u0001\u00048fo\u0006\u0013(/Y=TSj,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011E\u0001\u0005G>\u0004\u0018\u0010F\u0003I\u0003\u000f\nI\u0005C\u0004?\u001fA\u0005\t\u0019\u0001!\t\u000f\u0011{\u0001\u0013!a\u0001\u0001\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA(U\r\u0001\u0015\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011QL\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003[\ti'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002|A\u0019a'! \n\u0007\u0005}tGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002s\u0003\u000bC\u0011\"a\"\u0015\u0003\u0003\u0005\r!a\u001f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\tE\u0003\u0002\u0010\u0006U%/\u0004\u0002\u0002\u0012*\u0019\u00111S\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u0006E%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!(\u0002$B\u0019a'a(\n\u0007\u0005\u0005vGA\u0004C_>dW-\u00198\t\u0011\u0005\u001de#!AA\u0002I\fa!Z9vC2\u001cH\u0003BAO\u0003SC\u0001\"a\"\u0018\u0003\u0003\u0005\rA\u001d\u0015\u0010\u0001\u00055\u00161WA[\u0003s\u000bY,a0\u0002BB\u0019q&a,\n\u0007\u0005E\u0006EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0016AT0G+:\u001bu\fK1se\u0006LH\u0006I3mK6,g\u000e^\u0015![\u0001\u0012V-\\8wK\u0002\nG\u000e\u001c\u0011fY\u0016lWM\u001c;tAQD\u0017\r\u001e\u0011fcV\fG\u000e\t;pA\u0015dW-\\3oi\u00022'o\\7!CJ\u0014\u0018-\u001f\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!0\u0002-*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMb\u0003E\\;mY2\u00023'\u000b\u0017!g%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1rW\u000f\u001c7^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAb\u0003\u0015\u0011d\u0006\u000e\u00181\u0003-\t%O]1z%\u0016lwN^3\u0011\u0005=J2\u0003B\r\u0002Ln\u0002r!!4\u0002T\u0002\u0003\u0005*\u0004\u0002\u0002P*\u0019\u0011\u0011[\u001c\u0002\u000fI,h\u000e^5nK&!\u0011Q[Ah\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u000f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003S\nQ!\u00199qYf$R\u0001SAq\u0003GDQA\u0010\u000fA\u0002\u0001CQ\u0001\u0012\u000fA\u0002\u0001\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006U\b#\u0002\u001c\u0002l\u0006=\u0018bAAwo\t1q\n\u001d;j_:\u0004RANAy\u0001\u0002K1!a=8\u0005\u0019!V\u000f\u001d7fe!A\u0011q_\u000f\u0002\u0002\u0003\u0007\u0001*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q \t\u0005\u0003W\ny0\u0003\u0003\u0003\u0002\u00055$AB(cU\u0016\u001cG\u000f")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        block0: {
            if (v != null && $this.ordering().equiv(v, value$3)) break block0;
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

