/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern - Returns true if str matches pattern, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          The escape character is '\\'. If an escape character precedes a special symbol or another\n          escape character, the following character is matched literally. It is invalid to escape\n          any other character.\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it fallbacks\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n  ", examples="\n    Examples:\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%'\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u000e\u0001\u0003\u0016\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0012)A\u0005q!AA\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005>\u0001\tE\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d)\b!!A\u0005\u0002YDq!\u001f\u0001\u0012\u0002\u0013\u0005!\u0010\u0003\u0005\u0002\f\u0001\t\n\u0011\"\u0001{\u0011%\ti\u0001AA\u0001\n\u0003\ny\u0001C\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e!I\u0011Q\u0005\u0001\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003kA\u0011\"a\u0011\u0001\u0003\u0003%\t!!\u0012\t\u0013\u0005%\u0003!!A\u0005B\u0005-s!CA;7\u0005\u0005\t\u0012AA<\r!Q2$!A\t\u0002\u0005e\u0004B\u0002 \u0015\t\u0003\t9\t\u0003\u0005e)\u0005\u0005IQIAE\u0011%\tY\tFA\u0001\n\u0003\u000bi\tC\u0005\u0002\u0014R\t\t\u0011\"!\u0002\u0016\"I\u0011q\u0015\u000b\u0002\u0002\u0013%\u0011\u0011\u0016\u0002\u0005\u0019&\\WM\u0003\u0002\u001d;\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011&L\u001a\u0011\u0005)ZS\"A\u000e\n\u00051Z\"!F*ue&twMU3hKb,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\b!J|G-^2u!\tqC'\u0003\u00026_\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005A\u0004C\u0001\u0016:\u0013\tQ4D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002A\u0003\n\u0003\"A\u000b\u0001\t\u000bY*\u0001\u0019\u0001\u001d\t\u000bq*\u0001\u0019\u0001\u001d\u0002\r\u0015\u001c8-\u00199f)\t)\u0005\u000b\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011>j\u0011!\u0013\u0006\u0003\u0015\u001e\na\u0001\u0010:p_Rt\u0014B\u0001'0\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051{\u0003\"B)\u0007\u0001\u0004)\u0015!\u0001<\u0002\u000f5\fGo\u00195fgR\u0019Ak\u00162\u0011\u00059*\u0016B\u0001,0\u0005\u001d\u0011un\u001c7fC:DQ\u0001W\u0004A\u0002e\u000bQA]3hKb\u0004\"A\u00171\u000e\u0003mS!\u0001\u0017/\u000b\u0005us\u0016\u0001B;uS2T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b7\n9\u0001+\u0019;uKJt\u0007\"B2\b\u0001\u0004)\u0015aA:ue\u0006AAo\\*ue&tw\rF\u0001F\u0003%!wnR3o\u0007>$W\rF\u0002i]N\u0004\"!\u001b7\u000e\u0003)T!a[\u000e\u0002\u000f\r|G-Z4f]&\u0011QN\u001b\u0002\t\u000bb\u0004(oQ8eK\")q.\u0003a\u0001a\u0006\u00191\r\u001e=\u0011\u0005%\f\u0018B\u0001:k\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001^\u0005A\u0002!\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0004\u0001^D\bb\u0002\u001c\u000b!\u0003\u0005\r\u0001\u000f\u0005\by)\u0001\n\u00111\u00019\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001f\u0016\u0003qq\\\u0013! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00020\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0013y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018y\u000bA\u0001\\1oO&\u0019a*!\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0001c\u0001\u0018\u0002\"%\u0019\u00111E\u0018\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0012q\u0006\t\u0004]\u0005-\u0012bAA\u0017_\t\u0019\u0011I\\=\t\u0013\u0005Er\"!AA\u0002\u0005}\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00028A1\u0011\u0011HA \u0003Si!!a\u000f\u000b\u0007\u0005ur&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!\u0016q\t\u0005\n\u0003c\t\u0012\u0011!a\u0001\u0003S\ta!Z9vC2\u001cHc\u0001+\u0002N!I\u0011\u0011\u0007\n\u0002\u0002\u0003\u0007\u0011\u0011\u0006\u0015\u0018\u0001\u0005E\u0013qKA-\u0003;\ny&a\u0019\u0002f\u0005%\u00141NA8\u0003c\u00022AKA*\u0013\r\t)f\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY&\u00016tiJ\u0004sLR+O\u0007~\u0003\u0003/\u0019;uKJt\u0007%\f\u0011SKR,(O\\:!iJ,X\rI5gAM$(\u000fI7bi\u000eDWm\u001d\u0011qCR$XM\u001d8-A9,H\u000e\u001c\u0011jM\u0002\ng.\u001f\u0011be\u001e,X.\u001a8ug\u0002\n'/\u001a\u0011ok2dG\u0006\t4bYN,\u0007e\u001c;iKJ<\u0018n]3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002b\u0005A9D\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011qCR$XM\u001d8![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011qCR$XM\u001d8!SN\u0004\u0013\rI:ue&tw\rI<iS\u000eD\u0007%[:![\u0006$8\r[3eA1LG/\u001a:bY2LH\u0006I<ji\"T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fq\u000e,\u0007\u000f^5p]\u0002\"x\u000e\t;iK\u00022w\u000e\u001c7po&tw\rI:qK\u000eL\u0017\r\u001c\u0011ts6\u0014w\u000e\\:;\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I0![\u0006$8\r[3tA\u0005t\u0017\u0010I8oK\u0002\u001a\u0007.\u0019:bGR,'\u000fI5oAQDW\rI5oaV$\b\u0005K:j[&d\u0017M\u001d\u0011u_\u0002r\u0003%\u001b8!a>\u001c\u0018\u000e\u001f\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7/\u000b\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0005I7bi\u000eDWm\u001d\u0011{KJ|\u0007e\u001c:![>\u0014X\rI2iCJ\f7\r^3sg\u0002Jg\u000e\t;iK\u0002Jg\u000e];uA!\u001a\u0018.\\5mCJ\u0004Co\u001c\u0011/U\u0001Jg\u000e\t9pg&D\bE]3hk2\f'O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015D\bO]3tg&|gn]\u0015\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0015\u001c8-\u00199fA\rD\u0017M]1di\u0016\u0014\b%[:!Oq;c\u0006I%gA\u0005t\u0007%Z:dCB,\u0007e\u00195be\u0006\u001cG/\u001a:!aJ,7-\u001a3fg\u0002\n\u0007e\u001d9fG&\fG\u000eI:z[\n|G\u000eI8sA\u0005tw\u000e\u001e5fe*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3tG\u0006\u0004X\rI2iCJ\f7\r^3sY\u0001\"\b.\u001a\u0011g_2dwn^5oO\u0002\u001a\u0007.\u0019:bGR,'\u000fI5tA5\fGo\u00195fI\u0002b\u0017\u000e^3sC2d\u0017P\f\u0011Ji\u0002J7\u000fI5om\u0006d\u0017\u000e\u001a\u0011u_\u0002*7oY1qK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1os\u0002zG\u000f[3sA\rD\u0017M]1di\u0016\u0014hF\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0016N\\2fAM\u0003\u0018M]6!e9\u0002D\u0006I:ue&tw\r\t7ji\u0016\u0014\u0018\r\\:!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b8!_J$WM\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGNY1dWNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u001a\u0006/\u0019:lAErc\u0007\t2fQ\u00064\u0018n\u001c:!e\u0016<\u0017M\u001d3j]\u001e\u00043\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d\u0007\u0005]1sg&twM\f\u0011G_J\u0004S\r_1na2,G\u0006I5gAQDW\rI2p]\u001aLw\rI5t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a8bE2,G\r\f\u0011uQ\u0016\u0004\u0003/\u0019;uKJt\u0007\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0011tQ>,H\u000e\u001a\u0011cK\u0002\u0012C,\u00192dE9R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qM\u0001h\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bVk]3sgrSu\u000e\u001b8(A}3UKT\"`A\u001dbVeU=ti\u0016lGI]5wKr+C\fX+tKJ\u001cXe\n\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002n\u0005i$\u0002\t\u0011!AU\u001bX\r\t*M\u0013.+\u0005\u0005^8![\u0006$8\r\u001b\u0011xSRD\u0007e\u001d;b]\u0012\f'\u000f\u001a\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7O\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111O\u0001\u0006c9\u0002d\u0006M\u0001\u0005\u0019&\\W\r\u0005\u0002+)M!A#a\u001f4!\u001d\ti(a!9q\u0001k!!a \u000b\u0007\u0005\u0005u&A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0015q\u0010\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA<)\t\t\t\"A\u0003baBd\u0017\u0010F\u0003A\u0003\u001f\u000b\t\nC\u00037/\u0001\u0007\u0001\bC\u0003=/\u0001\u0007\u0001(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u00151\u0015\t\u0006]\u0005e\u0015QT\u0005\u0004\u00037{#AB(qi&|g\u000eE\u0003/\u0003?C\u0004(C\u0002\u0002\">\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAS1\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAV!\u0011\t\u0019\"!,\n\t\u0005=\u0016Q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class Like
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple2<Expression, Expression>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Like>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v);
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        return new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(116).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(escapeFunc).append("(").append(rightStr).append("));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right) {
        return new Like(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

