/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0003\u0006\u0001/!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!I\u0004A!A!\u0002\u0013Q\u0004\"B\u001f\u0001\t\u0003q\u0004\u0002C\"\u0001\u0011\u000b\u0007I\u0011\u0002#\t\u000bE\u0003A\u0011\u0002*\t\u000be\u0003A\u0011\t.\t\u000b!\u0003A\u0011I0\u00033%\u001bx\u000e\u000f\u001c1cQKW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0006\u0003\u00171\tA!\u001e;jY*\u0011QBD\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0007\u0010#!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u0015%\u0011\u0011E\u0003\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'\u000f\u0005\u0002 G%\u0011AE\u0003\u0002\u0018\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b*\u001a7qKJ\fq\u0001]1ui\u0016\u0014h\u000e\u0005\u0002(]9\u0011\u0001\u0006\f\t\u0003Sii\u0011A\u000b\u0006\u0003WY\ta\u0001\u0010:p_Rt\u0014BA\u0017\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055R\u0012\u0001\u0003;j[\u0016TvN\\3\u0011\u0005M:T\"\u0001\u001b\u000b\u0005-)$\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qQ\u0012\u0001\u0002V5nKj{g.Z\u0001\u0007Y>\u001c\u0017\r\\3\u0011\u0005MZ\u0014B\u0001\u001f5\u0005\u0019aunY1mK\u00061A(\u001b8jiz\"Ba\u0010!B\u0005B\u0011q\u0004\u0001\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006s\u0011\u0001\rAO\u0001\nM>\u0014X.\u0019;uKJ,\u0012!\u0012\t\u0003\r.k\u0011a\u0012\u0006\u0003\u0011&\u000baAZ8s[\u0006$(B\u0001&6\u0003\u0011!\u0018.\\3\n\u00051;%!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\"\u0012QA\u0014\t\u00033=K!\u0001\u0015\u000e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u0003;p\u0013:\u001cH/\u00198u)\t\u0019v\u000b\u0005\u0002U+6\t\u0011*\u0003\u0002W\u0013\n9\u0011J\\:uC:$\b\"\u0002-\u0007\u0001\u00041\u0013!A:\u0002\u000bA\f'o]3\u0015\u0005ms\u0006CA\r]\u0013\ti&D\u0001\u0003M_:<\u0007\"\u0002-\b\u0001\u00041CC\u0001\u0014a\u0011\u0015\t\u0007\u00021\u0001\\\u0003\t)8\u000f")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toInstantWithZoneId$(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    private DateTimeFormatter formatter() {
        return !this.bitmap$trans$0 ? this.formatter$lzycompute() : this.formatter;
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return temporalAccessor.query(TemporalQueries.offset()) == null ? this.toInstantWithZoneId(temporalAccessor, this.timeZone.toZoneId()) : Instant.from(temporalAccessor);
    }

    @Override
    public long parse(String s) {
        return DateTimeUtils$.MODULE$.instantToMicros(this.toInstant(s));
    }

    @Override
    public String format(long us) {
        long secs = Math.floorDiv(us, 1000000L);
        long mos = Math.floorMod(us, 1000000L);
        Instant instant = Instant.ofEpochSecond(secs, mos * 1000L);
        return this.formatter().withZone(this.timeZone.toZoneId()).format(instant);
    }

    public Iso8601TimestampFormatter(String pattern, TimeZone timeZone, Locale locale) {
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        DateTimeFormatterHelper.$init$(this);
    }
}

