/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.arrow.ArrowUtils$;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ArrowConverters$ {
    public static final ArrowConverters$ MODULE$;

    static {
        new ArrowConverters$();
    }

    public Iterator<byte[]> toBatchIterator(Iterator<InternalRow> rowIter, StructType schema2, int maxRecordsPerBatch, String timeZoneId, TaskContext context) {
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema2, timeZoneId);
        BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("toBatchIterator", 0L, Long.MAX_VALUE);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
        VectorUnloader unloader = new VectorUnloader(root);
        ArrowWriter arrowWriter = ArrowWriter$.MODULE$.create(root);
        context.addTaskCompletionListener((Function1)new Serializable(allocator, root){
            public static final long serialVersionUID = 0L;
            private final BufferAllocator allocator$1;
            private final VectorSchemaRoot root$1;

            public final void apply(TaskContext x$1) {
                this.root$1.close();
                this.allocator$1.close();
            }
            {
                this.allocator$1 = allocator$1;
                this.root$1 = root$1;
            }
        });
        return new Iterator<byte[]>(rowIter, maxRecordsPerBatch, allocator, root, unloader, arrowWriter){
            public final Iterator rowIter$1;
            public final int maxRecordsPerBatch$1;
            private final BufferAllocator allocator$1;
            private final VectorSchemaRoot root$1;
            public final VectorUnloader unloader$1;
            public final ArrowWriter arrowWriter$1;

            public Iterator<byte[]> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.rowIter$1.hasNext()) return true;
                this.root$1.close();
                this.allocator$1.close();
                if (!false) return false;
                return true;
            }

            public byte[] next() {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
                Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(this, writeChannel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final WriteChannel writeChannel$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        for (int rowCount = 0; this.$outer.rowIter$1.hasNext() && (this.$outer.maxRecordsPerBatch$1 <= 0 || rowCount < this.$outer.maxRecordsPerBatch$1); ++rowCount) {
                            InternalRow row = (InternalRow)this.$outer.rowIter$1.next();
                            this.$outer.arrowWriter$1.write(row);
                        }
                        this.$outer.arrowWriter$1.finish();
                        ArrowRecordBatch batch = this.$outer.unloader$1.getRecordBatch();
                        MessageSerializer.serialize((WriteChannel)this.writeChannel$1, (ArrowRecordBatch)batch);
                        batch.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writeChannel$1 = writeChannel$1;
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.arrowWriter$1.reset();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return out.toByteArray();
            }
            {
                this.rowIter$1 = rowIter$1;
                this.maxRecordsPerBatch$1 = maxRecordsPerBatch$1;
                this.allocator$1 = allocator$1;
                this.root$1 = root$1;
                this.unloader$1 = unloader$1;
                this.arrowWriter$1 = arrowWriter$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
            }
        };
    }

    public Iterator<InternalRow> fromBatchIterator(Iterator<byte[]> arrowBatchIter, StructType schema2, String timeZoneId, TaskContext context) {
        BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("fromBatchIterator", 0L, Long.MAX_VALUE);
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema2, timeZoneId);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
        return new Iterator<InternalRow>(arrowBatchIter, context, allocator, root){
            private Iterator<InternalRow> rowIter;
            private final Iterator arrowBatchIter$1;
            private final BufferAllocator allocator$2;
            private final VectorSchemaRoot root$2;

            public Iterator<InternalRow> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<InternalRow> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<InternalRow, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<InternalRow, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<InternalRow, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<InternalRow, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<InternalRow> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<InternalRow> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<InternalRow> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<InternalRow> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<InternalRow> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<InternalRow, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<InternalRow> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<InternalRow> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<InternalRow> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<InternalRow> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<InternalRow> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<InternalRow, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private Iterator<InternalRow> rowIter() {
                return this.rowIter;
            }

            private void rowIter_$eq(Iterator<InternalRow> x$1) {
                this.rowIter = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.rowIter().hasNext()) return true;
                if (this.arrowBatchIter$1.hasNext()) {
                    this.rowIter_$eq(this.nextBatch());
                    return true;
                }
                this.root$2.close();
                this.allocator$2.close();
                return false;
            }

            public InternalRow next() {
                return (InternalRow)this.rowIter().next();
            }

            private Iterator<InternalRow> nextBatch() {
                ArrowRecordBatch arrowRecordBatch = ArrowConverters$.MODULE$.loadBatch((byte[])this.arrowBatchIter$1.next(), this.allocator$2);
                VectorLoader vectorLoader = new VectorLoader(this.root$2);
                vectorLoader.load(arrowRecordBatch);
                arrowRecordBatch.close();
                ColumnVector[] columns2 = (ColumnVector[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.root$2.getFieldVectors()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ColumnVector apply(FieldVector vector) {
                        return new ArrowColumnVector((ValueVector)vector);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnVector.class));
                ColumnarBatch batch = new ColumnarBatch(columns2);
                batch.setNumRows(this.root$2.getRowCount());
                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala();
            }
            {
                this.arrowBatchIter$1 = arrowBatchIter$1;
                this.allocator$2 = allocator$2;
                this.root$2 = root$2;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.rowIter = arrowBatchIter$1.hasNext() ? this.nextBatch() : package$.MODULE$.Iterator().empty();
                context$1.addTaskCompletionListener((Function1)new Serializable(this, allocator$2, root$2){
                    public static final long serialVersionUID = 0L;
                    private final BufferAllocator allocator$2;
                    private final VectorSchemaRoot root$2;

                    public final void apply(TaskContext x$2) {
                        this.root$2.close();
                        this.allocator$2.close();
                    }
                    {
                        this.allocator$2 = allocator$2;
                        this.root$2 = root$2;
                    }
                });
            }
        };
    }

    public ArrowRecordBatch loadBatch(byte[] batchBytes, BufferAllocator allocator) {
        ByteArrayInputStream in = new ByteArrayInputStream(batchBytes);
        return MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel(Channels.newChannel(in)), (BufferAllocator)allocator);
    }

    public Dataset<Row> toDataFrame(JavaRDD<byte[]> arrowBatchRDD, String schemaString2, SQLContext sqlContext) {
        StructType schema2 = (StructType)DataType$.MODULE$.fromJson(schemaString2);
        String timeZoneId = sqlContext.sessionState().conf().sessionLocalTimeZone();
        RDD rdd2 = arrowBatchRDD.rdd().mapPartitions((Function1)new Serializable(schema2, timeZoneId){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final String timeZoneId$1;

            public final Iterator<InternalRow> apply(Iterator<byte[]> iter) {
                TaskContext context = TaskContext$.MODULE$.get();
                return ArrowConverters$.MODULE$.fromBatchIterator(iter, this.schema$1, this.timeZoneId$1, context);
            }
            {
                this.schema$1 = schema$1;
                this.timeZoneId$1 = timeZoneId$1;
            }
        }, arrowBatchRDD.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return sqlContext.internalCreateDataFrame((RDD<InternalRow>)rdd2.setName("arrow"), schema2, sqlContext.internalCreateDataFrame$default$3());
    }

    public JavaRDD<byte[]> readArrowStreamFromFile(SQLContext sqlContext, String filename) {
        return (JavaRDD)Utils$.MODULE$.tryWithResource((Function0)new Serializable(filename){
            public static final long serialVersionUID = 0L;
            private final String filename$1;

            public final FileInputStream apply() {
                return new FileInputStream(this.filename$1);
            }
            {
                this.filename$1 = filename$1;
            }
        }, (Function1)new Serializable(sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final JavaRDD<byte[]> apply(FileInputStream fileStream) {
                byte[][] batches = (byte[][])ArrowConverters$.MODULE$.getBatchesFromStream(fileStream.getChannel()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                return JavaRDD$.MODULE$.fromRDD(this.sqlContext$1.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])batches), batches.length, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
    }

    public Iterator<byte[]> getBatchesFromStream(ReadableByteChannel in) {
        return new Iterator<byte[]>(in){
            private byte[] batch;
            private final ReadableByteChannel in$1;

            public Iterator<byte[]> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private byte[] batch() {
                return this.batch;
            }

            private void batch_$eq(byte[] x$1) {
                this.batch = x$1;
            }

            public boolean hasNext() {
                return this.batch() != null;
            }

            /*
             * WARNING - void declaration
             */
            public byte[] next() {
                void var1_1;
                byte[] prevBatch = this.batch();
                this.batch_$eq(this.readNextBatch());
                return var1_1;
            }

            private byte[] readNextBatch() {
                MessageMetadataResult msgMetadata;
                while ((msgMetadata = MessageSerializer.readMessage((ReadChannel)new ReadChannel(this.in$1))) != null) {
                    int bodyLength = (int)msgMetadata.getMessageBodyLength();
                    if (msgMetadata.getMessage().headerType() == 3) {
                        ByteBufferOutputStream bbout = new ByteBufferOutputStream(4 + msgMetadata.getMessageLength() + bodyLength);
                        MessageSerializer.writeMessageBuffer((WriteChannel)new WriteChannel(Channels.newChannel((OutputStream)bbout)), (int)msgMetadata.getMessageLength(), (ByteBuffer)msgMetadata.getMessageBuffer());
                        bbout.close();
                        ByteBuffer bb = bbout.toByteBuffer();
                        bb.position(bbout.getCount());
                        bb.limit(bb.capacity());
                        JavaUtils.readFully((ReadableByteChannel)this.in$1, (ByteBuffer)bb);
                        return bb.array();
                    }
                    Object object = bodyLength > 0 ? BoxesRunTime.boxToLong((long)Channels.newInputStream(this.in$1).skip(bodyLength)) : BoxedUnit.UNIT;
                }
                return null;
            }
            {
                this.in$1 = in$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.batch = this.readNextBatch();
            }
        };
    }

    private ArrowConverters$() {
        MODULE$ = this;
    }
}

