/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.io.Serializable;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.SparkJobIdWithUIData;
import org.apache.spark.streaming.ui.StreamingJobProgressListener;
import org.apache.spark.streaming.ui.StreamingTab;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.WebUIPage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005-h!B\f\u0019\u0001a\u0011\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u000b9\u0002A\u0011A\u0018\t\u000fI\u0002!\u0019!C\u0005g!1q\u0007\u0001Q\u0001\nQBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!IA\u0011\u0005\u0006/\u0002!I\u0001\u0017\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a/\u0001\t\u0003\ti\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAq\u0001\u0011%\u00111\u001d\u0002\n\u0005\u0006$8\r\u001b)bO\u0016T!!\u0007\u000e\u0002\u0005UL'BA\u000e\u001d\u0003%\u0019HO]3b[&twM\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h'\t\u00011\u0005\u0005\u0002%M5\tQE\u0003\u0002\u001a9%\u0011q%\n\u0002\n/\u0016\u0014W+\u0013)bO\u0016\fa\u0001]1sK:$8\u0001\u0001\t\u0003W1j\u0011\u0001G\u0005\u0003[a\u0011Ab\u0015;sK\u0006l\u0017N\\4UC\n\fa\u0001P5oSRtDC\u0001\u00192!\tY\u0003\u0001C\u0003)\u0005\u0001\u0007!&A\ttiJ,\u0017-\\5oO2K7\u000f^3oKJ,\u0012\u0001\u000e\t\u0003WUJ!A\u000e\r\u00039M#(/Z1nS:<'j\u001c2Qe><'/Z:t\u0019&\u001cH/\u001a8fe\u0006\u00112\u000f\u001e:fC6Lgn\u001a'jgR,g.\u001a:!\u0003\u0015\u0019Ho\u001c:f+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u001d\u0003\u0019\u0019H/\u0019;vg&\u0011q\b\u0010\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0003\u0019\u0019Ho\u001c:fA\u000591m\u001c7v[:\u001cX#A\"\u0011\u0007\u0011s\u0015K\u0004\u0002F\u0017:\u0011a)S\u0007\u0002\u000f*\u0011\u0001*K\u0001\u0007yI|w\u000e\u001e \n\u0003)\u000bQa]2bY\u0006L!\u0001T'\u0002\u000fA\f7m[1hK*\t!*\u0003\u0002P!\n\u00191+Z9\u000b\u00051k\u0005C\u0001*V\u001b\u0005\u0019&B\u0001+N\u0003\rAX\u000e\\\u0005\u0003-N\u0013AAT8eK\u0006qq-\u001a8fe\u0006$XMS8c%><H#C\"ZK*dg\u000f`A\u0002\u0011\u0015Q\u0006\u00021\u0001\\\u0003\u001d\u0011X-];fgR\u0004\"\u0001X2\u000e\u0003uS!AX0\u0002\t!$H\u000f\u001d\u0006\u0003A\u0006\fqa]3sm2,GOC\u0001c\u0003\u0015Q\u0017M^1y\u0013\t!WL\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\b\"\u00024\t\u0001\u00049\u0017\u0001D8viB,Ho\u00149ECR\f\u0007CA\u0016i\u0013\tI\u0007DA\u000bPkR\u0004X\u000f^(qKJ\fG/[8o+&#\u0015\r^1\t\u000b-D\u0001\u0019A\"\u0002'=,H\u000f];u\u001fB$Um]2sSB$\u0018n\u001c8\t\u000b5D\u0001\u0019\u00018\u00023\u0019|'/\\1ui\u0016$w*\u001e;qkR|\u0005\u000fR;sCRLwN\u001c\t\u0003_Nt!\u0001]9\u0011\u0005\u0019k\u0015B\u0001:N\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Il\u0005\"B<\t\u0001\u0004A\u0018!\u00078v[N\u0003\u0018M]6K_\n\u0014vn^:J]>+H\u000f];u\u001fB\u0004\"!\u001f>\u000e\u00035K!a_'\u0003\u0007%sG\u000fC\u0003~\u0011\u0001\u0007a0\u0001\u0006jg\u001aK'o\u001d;S_^\u0004\"!_@\n\u0007\u0005\u0005QJA\u0004C_>dW-\u00198\t\u000f\u0005\u0015\u0001\u00021\u0001\u0002\b\u0005i!n\u001c2JI^KG\u000f\u001b#bi\u0006\u00042aKA\u0005\u0013\r\tY\u0001\u0007\u0002\u0015'B\f'o\u001b&pE&#w+\u001b;i+&#\u0015\r^1\u0002G\u001d,g.\u001a:bi\u0016|U\u000f\u001e9vi>\u0003(k\\<XSRDw.\u001e;Ta\u0006\u00148NS8cgR91)!\u0005\u0002\u0014\u0005U\u0001\"\u00024\n\u0001\u00049\u0007\"B6\n\u0001\u0004\u0019\u0005\"B7\n\u0001\u0004q\u0017\u0001F4f]\u0016\u0014\u0018\r^3O_Jl\u0017\r\u001c&pEJ{w\u000fF\bD\u00037\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0011\u0015Q&\u00021\u0001\\\u0011\u00151'\u00021\u0001h\u0011\u0015Y'\u00021\u0001D\u0011\u0015i'\u00021\u0001o\u0011\u00159(\u00021\u0001y\u0011\u0015i(\u00021\u0001\u007f\u0011\u001d\tIC\u0003a\u0001\u0003W\t\u0001b\u001d9be.TuN\u0019\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\t1\u0018GC\u0002\u00026q\n1!\u00199j\u0013\u0011\tI$a\f\u0003\u000f){'\rR1uC\u0006)r-\u001a8fe\u0006$X\r\u0012:paB,GMS8c%><H#D\"\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI\u0005C\u0003g\u0017\u0001\u0007q\rC\u0003l\u0017\u0001\u00071\tC\u0003n\u0017\u0001\u0007a\u000eC\u0003x\u0017\u0001\u0007\u0001\u0010C\u0003~\u0017\u0001\u0007a\u0010\u0003\u0004\u0002L-\u0001\r\u0001_\u0001\u0006U>\u0014\u0017\nZ\u0001\u0016O\u0016tWM]1uK>+H\u000f];u\u001fBLEMU8x)\u001d\u0019\u0015\u0011KA*\u0003+BQA\u0017\u0007A\u0002mCQA\u001a\u0007A\u0002\u001dDq!a\u0016\r\u0001\u0004\tI&A\u0005ta\u0006\u00148NS8cgB!AITA\u0004\u0003m9WM\\3sCR,w*\u001e;qkR|\u0005\u000fR3tGJL\u0007\u000f^5p]R\u00191)a\u0018\t\r\u0005\u0005T\u00021\u0001h\u0003!yW\u000f\u001e9vi>\u0003\u0018AC4fi*{'\rR1uCR!\u0011qMA7!\u0015I\u0018\u0011NA\u0016\u0013\r\tY'\u0014\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005=d\u00021\u0001\u0002r\u0005Q1\u000f]1sW*{'-\u00133\u0011\t\u0005M\u0014Q\u0012\b\u0005\u0003k\nII\u0004\u0003\u0002x\u0005\u001de\u0002BA=\u0003\u000bsA!a\u001f\u0002\u0004:!\u0011QPAA\u001d\r1\u0015qP\u0005\u0002C%\u0011q\u0004I\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012bAAF1\u0005a2\u000b\u001e:fC6Lgn\u001a&pEB\u0013xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BAH\u0003#\u0013!b\u00159be.TuNY%e\u0015\r\tY\tG\u0001\rO\u0016$8\u000b^1hK\u0012\u000bG/\u0019\u000b\u0005\u0003/\u000by\nE\u0003z\u0003S\nI\n\u0005\u0003\u0002.\u0005m\u0015\u0002BAO\u0003_\u0011\u0011b\u0015;bO\u0016$\u0015\r^1\t\r\u0005\u0005v\u00021\u0001y\u0003\u001d\u0019H/Y4f\u0013\u0012\f!eZ3oKJ\fG/Z(viB,Ho\u00149fe\u0006$\u0018n\u001c8Ti\u0006$Xo\u001d$peVKEc\u00018\u0002(\"1\u0011\u0011\u0016\tA\u00029\fqAZ1jYV\u0014X-\u0001\thK:,'/\u0019;f\u0015>\u0014G+\u00192mKR)1)a,\u00022\")!,\u0005a\u00017\"9\u00111W\tA\u0002\u0005U\u0016a\u00032bi\u000eDW+\u0013#bi\u0006\u00042aKA\\\u0013\r\tI\f\u0007\u0002\f\u0005\u0006$8\r[+J\t\u0006$\u0018-\u0001\u0004sK:$WM\u001d\u000b\u0004\u0007\u0006}\u0006\"\u0002.\u0013\u0001\u0004Y\u0016AG4f]\u0016\u0014\u0018\r^3J]B,H/T3uC\u0012\fG/\u0019+bE2,GcA\"\u0002F\"9\u0011qY\nA\u0002\u0005%\u0017AD5oaV$X*\u001a;bI\u0006$\u0018m\u001d\t\u0005\t:\u000bY\rE\u0003z\u0003\u001bDh.C\u0002\u0002P6\u0013a\u0001V;qY\u0016\u0014\u0014\u0001G4f]\u0016\u0014\u0018\r^3J]B,H/T3uC\u0012\fG/\u0019*poR\u00191)!6\t\u000f\u0005]G\u00031\u0001\u0002L\u0006i\u0011N\u001c9vi6+G/\u00193bi\u0006\f\u0011$\\3uC\u0012\fG/\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$v\u000e\u0013+N\u0019R\u00191)!8\t\r\u0005}W\u00031\u0001o\u0003MiW\r^1eCR\fG)Z:de&\u0004H/[8o\u0003IyW\u000f\u001e9vi>\u00038\u000b^1ukN\u001cU\r\u001c7\u0015\u000b\r\u000b)/a:\t\r\u0005\u0005d\u00031\u0001h\u0011\u0019\tIO\u0006a\u0001q\u00069!o\\<ta\u0006t\u0007")
public class BatchPage
extends WebUIPage {
    private final StreamingTab parent;
    private final StreamingJobProgressListener streamingListener;
    private final AppStatusStore store;

    private StreamingJobProgressListener streamingListener() {
        return this.streamingListener;
    }

    private AppStatusStore store() {
        return this.store;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Node> columns() {
        void var3_3;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Output Op Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Description"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Output Op Duration "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken for all the jobs of this batch to finish processing from the time they were submitted.", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Status"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Job Id"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Job Duration "));
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken from submission time to completion time of the job", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Stages: Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("sorttable_nosort"), (MetaData)$md2);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Tasks (for all stages): Succeeded/Total"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Error"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    private scala.collection.immutable.Seq<Node> generateJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, SparkJobIdWithUIData jobIdWithData) {
        return jobIdWithData.jobData().isDefined() ? this.generateNormalJobRow(request, outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, (JobData)jobIdWithData.jobData().get()) : this.generateDroppedJobRow(outputOpData, outputOpDescription, formattedOutputOpDuration, numSparkJobRowsInOutputOp, isFirstRow, jobIdWithData.sparkJobId());
    }

    private scala.collection.immutable.Seq<Node> generateOutputOpRowWithoutSparkJobs(OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(outputOpDescription);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)formattedOutputOpDuration);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.outputOpStatusCell(outputOpData, 1));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Job Id "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateNormalJobRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, JobData sparkJob) {
        Nil$ nil$;
        Option duration = sparkJob.submissionTime().map((Function1 & Serializable)start -> BoxesRunTime.boxToLong((long)BatchPage.$anonfun$generateNormalJobRow$1(sparkJob, start)));
        String lastFailureReason = (String)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)sparkJob.stageIds().sorted(Ordering.Int$.MODULE$.reverse())).flatMap((Function1 & Serializable)stageId -> this.getStageData(BoxesRunTime.unboxToInt((Object)stageId)))).dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BatchPage.$anonfun$generateNormalJobRow$5(x$2)))).take(1)).flatMap((Function1 & Serializable)info -> info.failureReason())).headOption().getOrElse((Function0 & Serializable)() -> "");
        String formattedDuration = (String)duration.map((Function1 & Serializable)d -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)d))).getOrElse((Function0 & Serializable)() -> "-");
        String detailUrl = new StringBuilder(14).append(org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3())).append("/jobs/job/?id=").append(sparkJob.jobId()).toString();
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus(outputOpDescription);
            $buf3.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(sparkJob.jobId()), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", detailUrl, (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.jobId()));
        $buf6.$amp$plus(sparkJob.jobGroup().map((Function1 & Serializable)id -> new StringBuilder(2).append("(").append((String)id).append(")").toString()).getOrElse((Function0 & Serializable)() -> ""));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("sorttable_customkey", duration.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md5);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)formattedDuration);
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("stage-progress-cell"), (MetaData)$md6);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)sparkJob.numCompletedStages()));
        $buf8.$amp$plus((Object)new Text("/"));
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(sparkJob.stageIds().size() - sparkJob.numSkippedStages())));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numFailedStages() > 0 ? new StringBuilder(9).append("(").append(sparkJob.numFailedStages()).append(" failed)").toString() : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)(sparkJob.numSkippedStages() > 0 ? new StringBuilder(10).append("(").append(sparkJob.numSkippedStages()).append(" skipped)").toString() : BoxedUnit.UNIT));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.makeProgressBar(sparkJob.numActiveTasks(), sparkJob.numCompletedTasks(), sparkJob.numFailedTasks(), sparkJob.numSkippedTasks(), sparkJob.killedTasksSummary(), sparkJob.numTasks() - sparkJob.numSkippedTasks()));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(UIUtils$.MODULE$.failureReasonCell(lastFailureReason, UIUtils$.MODULE$.failureReasonCell$default$2(), UIUtils$.MODULE$.failureReasonCell$default$3()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateDroppedJobRow(OutputOperationUIData outputOpData, scala.collection.immutable.Seq<Node> outputOpDescription, String formattedOutputOpDuration, int numSparkJobRowsInOutputOp, boolean isFirstRow, int jobId) {
        Nil$ nil$;
        if (isFirstRow) {
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md);
            $md = new UnprefixedAttribute("class", (Seq)new Text("output-op-id-cell"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)Integer.toString(outputOpData.id()));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md2);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus(outputOpDescription);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("rowspan", Integer.toString(numSparkJobRowsInOutputOp), (MetaData)$md3);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)formattedOutputOpDuration);
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            nil$ = (AbstractSeq)$buf.$plus$plus(this.outputOpStatusCell(outputOpData, numSparkJobRowsInOutputOp));
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ prefixCells = nil$;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)prefixCells);
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(jobId), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)(jobId >= 0 ? Integer.toString(jobId) : "-"));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Duration "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Stages: Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Tasks (for all stages): Succeeded/Total "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Error "));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("-"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateOutputOpIdRow(HttpServletRequest request, OutputOperationUIData outputOpData, scala.collection.immutable.Seq<SparkJobIdWithUIData> sparkJobs) {
        scala.collection.immutable.Seq seq;
        String formattedOutputOpDuration = outputOpData.duration().isEmpty() ? "-" : org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)outputOpData.duration().get()));
        scala.collection.immutable.Seq<Node> description = this.generateOutputOpDescription(outputOpData);
        if (sparkJobs.isEmpty()) {
            seq = this.generateOutputOpRowWithoutSparkJobs(outputOpData, description, formattedOutputOpDuration);
        } else {
            scala.collection.immutable.Seq<Node> firstRow = this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), true, (SparkJobIdWithUIData)sparkJobs.head());
            scala.collection.immutable.Seq tailRows = (scala.collection.immutable.Seq)((IterableOps)sparkJobs.tail()).map((Function1 & Serializable)sparkJob -> this.generateJobRow(request, outputOpData, description, formattedOutputOpDuration, sparkJobs.size(), false, (SparkJobIdWithUIData)sparkJob));
            seq = (scala.collection.immutable.Seq)((IterableOps)firstRow.$plus$plus((IterableOnce)tailRows)).flatten(Predef$.MODULE$.$conforms());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<Node> generateOutputOpDescription(OutputOperationUIData outputOp) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)outputOp.name());
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-details"), (MetaData)$md);
        $md = new UnprefixedAttribute("onclick", (Seq)new Text("this.parentNode.querySelector('.stage-details').classList.toggle('collapsed')"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          +details\n      "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("stage-details collapsed"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)outputOp.description());
        $buf3.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    private Option<JobData> getJobData(int sparkJobId) {
        Some some;
        try {
            some = new Some((Object)this.store().job(sparkJobId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<StageData> getStageData(int stageId) {
        Some some;
        try {
            some = new Some((Object)this.store().lastStageAttempt(stageId));
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private String generateOutputOperationStatusForUI(String failure) {
        String string;
        if (failure.startsWith("org.apache.spark.SparkException")) {
            string = new StringBuilder(30).append("Failed due to Spark job error\n").append(failure).toString();
        } else {
            int nextLineIndex = failure.indexOf("\n");
            if (nextLineIndex < 0) {
                nextLineIndex = failure.length();
            }
            String firstLine = failure.substring(0, nextLineIndex);
            string = new StringBuilder(22).append("Failed due to error: ").append(firstLine).append("\n").append(failure).toString();
        }
        return string;
    }

    private scala.collection.immutable.Seq<Node> generateJobTable(HttpServletRequest request, BatchUIData batchUIData) {
        Map outputOpIdToSparkJobIds = (Map)batchUIData.outputOpIdSparkJobIdPairs().groupBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.outputOpId())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int outputOpId = tuple2._1$mcI$sp();
            Iterable outputOpIdAndSparkJobIds = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)outputOpId), ((IterableOnceOps)outputOpIdAndSparkJobIds.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sparkJobId()))).toSeq().sorted((Ordering)Ordering.Int$.MODULE$));
            return tuple22;
        });
        scala.collection.immutable.Seq outputOps = (scala.collection.immutable.Seq)batchUIData.outputOperations().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int outputOpId = tuple2._1$mcI$sp();
            OutputOperationUIData outputOperation = (OutputOperationUIData)tuple2._2();
            scala.collection.immutable.Seq sparkJobIds = (scala.collection.immutable.Seq)outputOpIdToSparkJobIds.getOrElse((Object)BoxesRunTime.boxToInteger((int)outputOpId), (Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty());
            Tuple2 tuple22 = new Tuple2((Object)outputOperation, (Object)sparkJobIds);
            return tuple22;
        }).toSeq().sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BatchPage.$anonfun$generateJobTable$6(x$5)), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq outputOpWithJobs = (scala.collection.immutable.Seq)outputOps.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
            scala.collection.immutable.Seq sparkJobIds = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)outputOpData, sparkJobIds.map((Function1 & Serializable)jobId -> BatchPage.$anonfun$generateJobTable$8(this, BoxesRunTime.unboxToInt((Object)jobId))));
            return tuple22;
        });
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered table-striped table-sm"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("batch-job-table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.columns());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(outputOpWithJobs.map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputOperationUIData outputOpData = (OutputOperationUIData)tuple2._1();
            scala.collection.immutable.Seq sparkJobs = (scala.collection.immutable.Seq)tuple2._2();
            scala.collection.immutable.Seq<Node> seq = this.generateOutputOpIdRow(request, outputOpData, (scala.collection.immutable.Seq<SparkJobIdWithUIData>)sparkJobs);
            return seq;
        }));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq seq;
        StreamingJobProgressListener streamingJobProgressListener = this.streamingListener();
        synchronized (streamingJobProgressListener) {
            BoxedUnit boxedUnit;
            Time batchTime = (Time)Option$.MODULE$.apply((Object)request.getParameter("id")).map((Function1 & Serializable)id -> new Time(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id)))).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Missing id parameter");
            });
            String formattedBatchTime = org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime(batchTime.milliseconds(), this.streamingListener().batchDuration(), org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$3(), org.apache.spark.ui.UIUtils$.MODULE$.formatBatchTime$default$4());
            BatchUIData batchUIData = (BatchUIData)this.streamingListener().getBatchUIData(batchTime).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(21).append("Batch ").append(formattedBatchTime).append(" does not exist").toString());
            });
            String formattedSchedulingDelay = (String)batchUIData.schedulingDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            String formattedProcessingTime = (String)batchUIData.processingDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            String formattedTotalDelay = (String)batchUIData.totalDelay().map((Function1 & Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable)() -> "-");
            scala.collection.immutable.Seq inputMetadatas = ((IterableOnceOps)batchUIData.streamIdToInputInfo().values().flatMap((Function1 & Serializable)inputInfo -> inputInfo.metadataDescription().map((Function1 & Serializable)desc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId())), desc)))).toSeq();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Batch Duration: "));
            $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(this.streamingListener().batchDuration()));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Input data size: "));
            $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToLong((long)batchUIData.numRecords()));
            $buf5.$amp$plus((Object)new Text(" records\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Scheduling delay: "));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)formattedSchedulingDelay);
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("Processing time: "));
            $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
            $buf9.$amp$plus((Object)new Text("\n            "));
            $buf9.$amp$plus((Object)formattedProcessingTime);
            $buf9.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("Total delay: "));
            $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf11.$amp$plus((Object)formattedTotalDelay);
            $buf11.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (inputMetadatas.nonEmpty()) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf14 = new NodeBuffer();
                $buf14.$amp$plus((Object)new Text("Input Metadata:"));
                $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
                $buf13.$amp$plus(this.generateInputMetadataTable((scala.collection.immutable.Seq<Tuple2<Object, String>>)inputMetadatas));
                $buf13.$amp$plus((Object)new Text("\n              "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13));
                boxedUnit = elem;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit);
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            scala.collection.immutable.Seq content = (scala.collection.immutable.Seq)summary.$plus$plus(this.generateJobTable(request, batchUIData));
            seq = org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(20).append("Details of batch at ").append(formattedBatchTime).toString(), (Function0 & Serializable)() -> content, (SparkUITab)this.parent, org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$5(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$6(), org.apache.spark.ui.UIUtils$.MODULE$.headerSparkPage$default$7());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Seq<Node> generateInputMetadataTable(scala.collection.immutable.Seq<Tuple2<Object, String>> inputMetadatas) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", org.apache.spark.ui.UIUtils$.MODULE$.TABLE_CLASS_STRIPED_SORTABLE(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Input"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Metadata "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Batch Input Details", "right"));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus(inputMetadatas.flatMap((Function1 & Serializable)inputMetadata -> this.generateInputMetadataRow((Tuple2<Object, String>)inputMetadata)));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Seq<Node> generateInputMetadataRow(Tuple2<Object, String> inputMetadata) {
        void var3_3;
        int streamId = inputMetadata._1$mcI$sp();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus(this.streamingListener().streamName(streamId).getOrElse((Function0 & Serializable)() -> new StringBuilder(7).append("Stream-").append(streamId).toString()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(this.metadataDescriptionToHTML((String)inputMetadata._2()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    private scala.collection.immutable.Seq<Node> metadataDescriptionToHTML(String metadataDescription) {
        return Unparsed$.MODULE$.apply(StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(StringEscapeUtils.escapeHtml4((String)metadataDescription)), "\t", "&nbsp;&nbsp;&nbsp;&nbsp;")), "\n", "<br/>"));
    }

    private scala.collection.immutable.Seq<Node> outputOpStatusCell(OutputOperationUIData outputOp, int rowspan) {
        Elem elem;
        Option<String> option = outputOp.failureReason();
        if (option instanceof Some) {
            Some some = (Some)option;
            String failureReason = (String)some.value();
            String failureReasonForUI = UIUtils$.MODULE$.createOutputOperationFailureForUI(failureReason);
            elem = UIUtils$.MODULE$.failureReasonCell(failureReasonForUI, rowspan, false);
        } else if (None$.MODULE$.equals(option)) {
            Elem elem2;
            if (outputOp.endTime().isEmpty()) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("-"));
                Elem elem3 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                elem2 = elem3;
            } else {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("rowspan", Integer.toString(rowspan), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("Succeeded"));
                Elem elem4 = new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
                elem2 = elem4;
            }
            elem = elem2;
        } else {
            throw new MatchError(option);
        }
        return elem;
    }

    public static final /* synthetic */ long $anonfun$generateNormalJobRow$1(JobData sparkJob$1, Date start) {
        long end = BoxesRunTime.unboxToLong((Object)sparkJob$1.completionTime().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> System.currentTimeMillis()));
        return end - start.getTime();
    }

    public static final /* synthetic */ boolean $anonfun$generateNormalJobRow$5(StageData x$2) {
        Option option = x$2.failureReason();
        None$ none$ = None$.MODULE$;
        return !(option != null ? !option.equals(none$) : none$ != null);
    }

    public static final /* synthetic */ int $anonfun$generateJobTable$6(Tuple2 x$5) {
        return ((OutputOperationUIData)x$5._1()).id();
    }

    public static final /* synthetic */ SparkJobIdWithUIData $anonfun$generateJobTable$8(BatchPage $this, int jobId) {
        return new SparkJobIdWithUIData(jobId, $this.getJobData(jobId));
    }

    public BatchPage(StreamingTab parent) {
        this.parent = parent;
        super("batch");
        this.streamingListener = parent.listener();
        this.store = parent.parent().store();
    }
}

