/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip.model.source;

import java.net.URL;
import org.codehaus.groovy.maven.gossip.config.ConfigurationException;
import org.codehaus.groovy.maven.gossip.config.MissingPropertyException;
import org.codehaus.groovy.maven.gossip.model.Configuration;
import org.codehaus.groovy.maven.gossip.model.Source;

public class ResourceSource
extends Source {
    private static final String CL_TYPE_TCL = "TCL";
    private static final String CL_TYPE_INTERNAL = "INTERNAL";
    private static final String CL_TYPE_SYSTEM = "SYSTEM";
    private String name;
    private String classLoaderType = "TCL";
    private ClassLoader classLoader;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceSource() {
    }

    public ResourceSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassLoaderType() {
        return this.classLoaderType;
    }

    public void setClassLoaderType(String type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.classLoaderType = type;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            String type = this.classLoaderType.toUpperCase();
            if (type.equals(CL_TYPE_TCL)) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            } else if (type.equals(CL_TYPE_INTERNAL)) {
                this.classLoader = this.getClass().getClassLoader();
            } else if (type.equals(CL_TYPE_SYSTEM)) {
                this.classLoader = ClassLoader.getSystemClassLoader();
            } else {
                throw new ConfigurationException("Invalid classLoaderType: " + this.classLoaderType);
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Configuration load() throws Exception {
        if (this.name == null) {
            throw new MissingPropertyException("name");
        }
        Configuration config = null;
        ClassLoader cl = this.getClassLoader();
        if (!$assertionsDisabled && cl == null) {
            throw new AssertionError();
        }
        this.log.trace("Loading resource for name: {}, CL: {}", this.name, cl);
        URL url = cl.getResource(this.name);
        this.log.trace("Loaded resource: {}", url);
        if (url == null) {
            this.log.trace("Unable to load; missing resource: {}", this.name);
        } else {
            config = this.load(url);
        }
        return config;
    }

    public String toString() {
        return "ResourceSource{name='" + this.name + '\'' + ", classLoaderType='" + this.classLoaderType + '\'' + ", classLoader=" + this.classLoader + '}';
    }

    static {
        $assertionsDisabled = !ResourceSource.class.desiredAssertionStatus();
    }
}

